/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.util.FormatterFormat;
import com.composum.sling.core.util.I18N;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.LoggerFormat;
import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.io.Writer;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpnlElFunctions {
    private static final Logger LOG;
    public static final Pattern HREF_PATTERN;
    public static final int QTYPE_QUOT = 0;
    public static final int QTYPE_APOS = 1;
    public static final String[] QTYPE_CHAR;
    public static final String[] QTYPE_ESC;
    public static final String[] RICH_TEXT_TAGS;
    public static final String[][] RICH_TEXT_BASIC_ESCAPE;
    protected static final List<String> RICH_TEXT_TAG_START;
    protected static final List<String> RICH_TEXT_TAG_CLOSED;
    protected static final int RICH_TEXT_TAG_MAX_LEN;
    public static final CharSequenceTranslator ESCAPE_RICH_TEXT;

    public static String escapeRichText(String input) {
        return ESCAPE_RICH_TEXT.translate((CharSequence)input);
    }

    public static String i18n(SlingHttpServletRequest request, String text) {
        return CpnlElFunctions.text(I18N.get(request, text));
    }

    public static String cpm(String uri) {
        CoreConfiguration config;
        if (StringUtils.isNotBlank((CharSequence)uri) && !uri.startsWith("/") && (config = CpnlElFunctions.getService(CoreConfiguration.class)) != null) {
            uri = config.getComposumBase() + uri;
        }
        return uri;
    }

    public static String child(Resource base, String path) {
        Resource child = base.getChild(path);
        return child != null ? child.getPath() : path;
    }

    public static String asset(SlingHttpServletRequest request, String path) {
        return XSS.getValidHref(LinkUtil.getUrl(request, path, null, ""));
    }

    public static String url(SlingHttpServletRequest request, String path) {
        return XSS.getValidHref(LinkUtil.getUrl(request, path));
    }

    public static String mappedUrl(SlingHttpServletRequest request, String path) {
        return XSS.getValidHref(LinkUtil.getMappedUrl(request, path));
    }

    public static String unmappedUrl(SlingHttpServletRequest request, String path) {
        return XSS.getValidHref(LinkUtil.getUnmappedUrl(request, path));
    }

    public static String externalUrl(SlingHttpServletRequest request, String path) {
        return XSS.getValidHref(LinkUtil.getAbsoluteUrl(request, LinkUtil.getUrl(request, path)));
    }

    public static String mappedExternalUrl(SlingHttpServletRequest request, String path) {
        return XSS.getValidHref(LinkUtil.getAbsoluteUrl(request, LinkUtil.getMappedUrl(request, path)));
    }

    public static String unmappedExternalUrl(SlingHttpServletRequest request, String path) {
        return XSS.getValidHref(LinkUtil.getAbsoluteUrl(request, LinkUtil.getUnmappedUrl(request, path)));
    }

    public static Object value(Object value) {
        return value instanceof String ? XSS.encodeForHTMLAttr((String)value) : value;
    }

    public static String text(String value) {
        return value != null ? XSS.encodeForHTML(value) : null;
    }

    public static String attr(SlingHttpServletRequest request, String value, int qType) {
        if (value != null) {
            value = CpnlElFunctions.rich(request, value);
            value = value.replaceAll("&", "&amp;").replaceAll(QTYPE_CHAR[qType], QTYPE_ESC[qType]);
        }
        return value;
    }

    public static String rich(SlingHttpServletRequest request, String value) {
        if (value != null) {
            if (StringUtils.isNotBlank((CharSequence)value) && !value.trim().startsWith("<p>")) {
                value = "<p>" + value + "</p>";
            }
            value = CpnlElFunctions.map(request, value);
            value = CpnlElFunctions.escapeRichText(value);
        }
        return value;
    }

    public static String map(SlingHttpServletRequest request, String value) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = HREF_PATTERN.matcher(value);
        int len = value.length();
        int pos = 0;
        while (matcher.find(pos)) {
            String unmapped = matcher.group(3);
            String mapped = CpnlElFunctions.url(request, unmapped);
            result.append(value, pos, matcher.start());
            result.append(matcher.group(1));
            result.append(mapped);
            result.append(matcher.group(4));
            pos = matcher.end();
        }
        if (pos >= 0 && pos < len) {
            result.append(value, pos, len);
        }
        return result.toString();
    }

    public static String filter(String value) {
        return XSS.filter(value);
    }

    public static String context(String context, String value) {
        return XSS.filter(context, value);
    }

    public static String path(String value) {
        return value != null ? LinkUtil.encodePath(value) : null;
    }

    public static String script(String value) {
        return value != null ? XSS.encodeForJSString(value) : null;
    }

    public static String style(String value) {
        return value != null ? XSS.encodeForCSSString(value) : null;
    }

    public static String cdata(String value) {
        return value != null ? "<![CDATA[" + value + "]]>" : null;
    }

    public static Format getFormatter(@NotNull Locale locale, @NotNull String format, Class<?> ... type) {
        Format formatter = null;
        Pattern TEXT_FORMAT_STRING = Pattern.compile("^(\\{([^}]+)}(.+)|(.*\\{}.*))$");
        Matcher matcher = TEXT_FORMAT_STRING.matcher(format);
        if (matcher.matches()) {
            if (matcher.group(2) != null) {
                switch (matcher.group(2)) {
                    case "Message": {
                        formatter = new MessageFormat(matcher.group(3), locale);
                        break;
                    }
                    case "Date": {
                        formatter = new SimpleDateFormat(matcher.group(3), locale);
                        break;
                    }
                    case "String": {
                        formatter = new FormatterFormat(matcher.group(3), locale);
                        break;
                    }
                    case "Log": {
                        formatter = new LoggerFormat(matcher.group(3));
                        break;
                    }
                    default: {
                        if (StringUtils.isBlank((CharSequence)matcher.group(2))) {
                            formatter = new LoggerFormat(matcher.group(4));
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                formatter = new LoggerFormat(matcher.group(4));
            }
        } else {
            formatter = type != null && type.length == 1 && type[0] != null && (Calendar.class.isAssignableFrom(type[0]) || Date.class.isAssignableFrom(type[0])) ? new SimpleDateFormat(format, locale) : new LoggerFormat(format);
        }
        return formatter;
    }

    protected static <T> T getService(Class<T> serviceClass) {
        BundleContext bundleContext = CpnlElFunctions.getBundelContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(serviceClass);
        return (T)(serviceReference != null ? bundleContext.getService(serviceReference) : null);
    }

    protected static BundleContext getBundelContext() {
        return FrameworkUtil.getBundle(CpnlElFunctions.class).getBundleContext();
    }

    static {
        int length;
        LOG = LoggerFactory.getLogger(CpnlElFunctions.class);
        HREF_PATTERN = Pattern.compile("(<a(\\s*[^>]*)?\\s*href\\s*=\\s*['\"])([^'\"]+)([\"'][^>]*>)");
        QTYPE_CHAR = new String[]{"\"", "'"};
        QTYPE_ESC = new String[]{"&quot;", "&apos;"};
        RICH_TEXT_TAGS = new String[]{"p", "br", "a", "ul", "li", "ol", "dl", "dt", "dd", "strong", "em", "u", "b", "i", "strike", "sub", "sup", "code", "table", "thead", "tbody", "tr", "th", "td"};
        RICH_TEXT_BASIC_ESCAPE = new String[][]{{"&copy;", "&copy;"}, {"&nbsp;", "&nbsp;"}, {"&amp;", "&amp;"}, {"&lt;", "&lt;"}, {"&gt;", "&gt;"}, {"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}};
        int maxLen = 0;
        RICH_TEXT_TAG_START = new ArrayList<String>();
        for (String tag : RICH_TEXT_TAGS) {
            RICH_TEXT_TAG_START.add("<" + tag + " ");
            length = tag.length() + 2;
            if (maxLen >= length) continue;
            maxLen = length;
        }
        RICH_TEXT_TAG_CLOSED = new ArrayList<String>();
        for (String tag : RICH_TEXT_TAGS) {
            RICH_TEXT_TAG_CLOSED.add("<" + tag + ">");
            RICH_TEXT_TAG_CLOSED.add("<" + tag + "/>");
            RICH_TEXT_TAG_CLOSED.add("</" + tag + ">");
            length = tag.length() + 3;
            if (maxLen >= length) continue;
            maxLen = length;
        }
        RICH_TEXT_TAG_MAX_LEN = maxLen;
        ESCAPE_RICH_TEXT = new AggregateTranslator(new CharSequenceTranslator[]{new RichTextTagsFilter(), new LookupTranslator((CharSequence[][])EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.HTML40_EXTENDED_ESCAPE())});
    }

    public static class RichTextTagsFilter
    extends LookupTranslator {
        protected boolean isInTagStart = false;

        public RichTextTagsFilter() {
            super((CharSequence[][])RICH_TEXT_BASIC_ESCAPE);
        }

        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (this.isInTagStart) {
                char token = input.charAt(index);
                out.write(token);
                if (token == '>') {
                    this.isInTagStart = false;
                }
                return 1;
            }
            String subSeq = input.subSequence(index, index + Math.min(RICH_TEXT_TAG_MAX_LEN, input.length() - index)).toString().toLowerCase();
            for (String pattern : RICH_TEXT_TAG_START) {
                if (!subSeq.startsWith(pattern)) continue;
                out.write(pattern);
                this.isInTagStart = true;
                return pattern.length();
            }
            for (String pattern : RICH_TEXT_TAG_CLOSED) {
                if (!subSeq.startsWith(pattern)) continue;
                out.write(pattern);
                return pattern.length();
            }
            return super.translate(input, index, out);
        }
    }
}

