/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.handle;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.core.util.LinkUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class ClientlibRef {
    public static final String PREFIX_CATEGORY = "category:";
    public final String rule;
    public final boolean optional;
    public final Pattern pattern;
    public final String path;
    public final String category;
    public final String externalUri;
    public final Clientlib.Type type;
    public final Map<String, String> properties;

    public ClientlibRef(Clientlib.Type type, String theRule, boolean optional, Map<String, String> properties) {
        this.type = type;
        this.rule = theRule.trim();
        this.optional = optional;
        boolean isCategory = this.rule.startsWith(PREFIX_CATEGORY);
        boolean isUri = !isCategory && LinkUtil.isExternalUrl(this.rule);
        this.externalUri = isUri ? this.rule : null;
        this.pattern = !isUri && !isCategory ? this.ruleToPattern(this.rule) : null;
        this.path = !isUri && !isCategory ? this.ruleToPath(this.rule) : null;
        this.category = isCategory ? this.rule.substring(PREFIX_CATEGORY.length()) : null;
        this.properties = Collections.unmodifiableMap(properties != null ? new HashMap<String, String>(properties) : new HashMap());
    }

    public static ClientlibRef forCategory(Clientlib.Type type, String category, boolean optional, Map<String, String> properties) {
        return new ClientlibRef(type, PREFIX_CATEGORY + category, optional, properties);
    }

    public boolean isCategory() {
        return null != this.category;
    }

    public boolean isExternalUri() {
        return null != this.externalUri;
    }

    public boolean getExternalUri() {
        return null != this.externalUri;
    }

    public boolean isSatisfiedby(ClientlibLink link) {
        if (!this.type.equals((Object)link.type)) {
            return false;
        }
        if (this.isCategory() ? !link.isCategory() || !this.category.equals(link.path) : (this.isExternalUri() ? !link.isExternalUri() || !this.externalUri.equals(link.path) : link.isCategory() || link.isExternalUri() || !this.pattern.matcher(link.path).matches())) {
            return false;
        }
        return this.properties.equals(link.properties);
    }

    public boolean isSatisfiedby(Collection<ClientlibLink> links) {
        for (ClientlibLink link : links) {
            if (!this.isSatisfiedby(link)) continue;
            return true;
        }
        return false;
    }

    protected Pattern ruleToPattern(String rule) {
        rule = rule.replaceAll("(\\([^:]+)\\*(:[^)]+\\))", "$1[^/]*$2");
        rule = rule.replaceAll("\\(([^:]+):[^)]+\\)", "($1)");
        rule = rule.replaceFirst("([.-]min)?(\\.[^./]+)?$", "(.min)?$2");
        rule = rule.replaceAll("\\.", "\\\\.");
        rule = "^" + (!rule.startsWith("/") ? ".*/" : "") + rule + "$";
        return Pattern.compile(rule);
    }

    protected String ruleToPath(String rule) {
        if (rule.startsWith(PREFIX_CATEGORY)) {
            return rule;
        }
        return rule.replaceAll("\\([^:]+:([^)]+)\\)", "$1");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append((Object)this.type).append(':').append(this.rule);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            builder.append(";").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientlibRef)) {
            return false;
        }
        ClientlibRef that = (ClientlibRef)o;
        if (!Objects.equals(this.rule, that.rule)) {
            return false;
        }
        if (!Objects.equals(this.category, that.category)) {
            return false;
        }
        if (!Objects.equals(this.externalUri, that.externalUri)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = this.rule != null ? this.rule.hashCode() : 0;
        result = 92821 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 92821 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

