/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.concurrent;

import com.composum.sling.core.concurrent.SequencerService;
import com.composum.sling.core.util.ResourceUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobExecutor<Result>
implements JobExecutor,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJobExecutor.class);
    private final Lock lock = new ReentrantLock(true);
    public static final String JOB_REFRENCE_PROPERTY = "reference";
    public static final String JOB_OUTFILE_PROPERTY = "outfile";
    public static final String JOB_USERID_PROPERTY = "userid";
    public static final String AUDIT_ROOT_PATH = "/var/audit/jobs/";
    public static final Map<String, Object> CRUD_AUDIT_FOLDER_PROPS;

    @NotNull
    protected abstract ResourceResolverFactory getResolverFactory();

    @NotNull
    protected abstract SequencerService<SequencerService.Token> getSequencer();

    @NotNull
    protected abstract DynamicClassLoaderManager getDynamicClassLoaderManager();

    protected abstract String getJobTopic();

    protected abstract String getAuditBasePath();

    protected abstract boolean jobExecutionEnabled(Job var1);

    protected abstract Callable<Result> createCallable(Job var1, JobExecutionContext var2, ResourceResolver var3, PrintWriter var4) throws Exception;

    /*
     * Exception decompiling
     */
    public final JobExecutionResult process(Job job, JobExecutionContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 4[TRYBLOCK]], but top level block is 75[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void jobExecutionFinished(Job job, JobExecutionContext context, Resource auditResource) throws IOException {
    }

    private String buildAuditPath(Job job) {
        String reference = (String)job.getProperty(JOB_REFRENCE_PROPERTY, String.class);
        Calendar eventJobStartedTime = (Calendar)job.getProperty("event.job.started.time", Calendar.class);
        return this.buildAuditPathIntern(reference, eventJobStartedTime);
    }

    protected String buildAuditPathIntern(String reference, Calendar eventJobStartedTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
        return this.getAuditBasePath() + reference + "/" + sdf.format(eventJobStartedTime.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Resource giveParent(ResourceResolver resolver, String path) {
        if ("/".equals(path)) {
            return resolver.getResource("/");
        }
        Resource resource = null;
        SequencerService.Token token = this.getSequencer().acquire(path);
        try {
            resource = resolver.getResource(path);
            if (resource == null) {
                String[] separated = ResourceUtil.splitPathAndName(path);
                Resource parent = this.giveParent(resolver, separated[0]);
                try {
                    resource = resolver.create(parent, separated[1], CRUD_AUDIT_FOLDER_PROPS);
                    resolver.commit();
                }
                catch (PersistenceException pex) {
                    LOG.error("AbstractJobExecutor giveParent('" + path + "'): " + pex.toString());
                }
            }
        }
        finally {
            this.getSequencer().release(token);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        String topic;
        if ((event.getTopic().equals("org/apache/sling/event/notification/job/FINISHED") || event.getTopic().equals("org/apache/sling/event/notification/job/FAILED") || event.getTopic().equals("org/apache/sling/event/notification/job/CANCELLED")) && (topic = (String)event.getProperty("event.job.topic")).equals(this.getJobTopic())) {
            String script = (String)event.getProperty(JOB_REFRENCE_PROPERTY);
            Calendar eventJobStartedTime = (Calendar)event.getProperty("event.job.started.time");
            String auditPath = this.buildAuditPathIntern(script, eventJobStartedTime);
            try (ResourceResolver adminResolver = null;){
                long executionTime;
                Calendar finishedDate;
                adminResolver = this.getResolverFactory().getAdministrativeResourceResolver(null);
                Resource auditResource = adminResolver.getResource(auditPath);
                ModifiableValueMap map = (ModifiableValueMap)auditResource.adaptTo(ModifiableValueMap.class);
                if (event.containsProperty("slingevent:resultMessage")) {
                    map.put((Object)"slingevent:resultMessage", event.getProperty("slingevent:resultMessage"));
                }
                if (event.containsProperty("slingevent:finishedDate")) {
                    finishedDate = (Calendar)event.getProperty("slingevent:finishedDate");
                    map.put((Object)"slingevent:finishedDate", (Object)finishedDate);
                    executionTime = finishedDate.getTimeInMillis() - eventJobStartedTime.getTimeInMillis();
                    map.put((Object)"executionTime", (Object)executionTime);
                } else {
                    finishedDate = GregorianCalendar.getInstance();
                    map.put((Object)"slingevent:finishedDate", (Object)finishedDate);
                    executionTime = finishedDate.getTimeInMillis() - eventJobStartedTime.getTimeInMillis();
                    map.put((Object)"executionTime", (Object)executionTime);
                }
                if (event.containsProperty("slingevent:finishedState")) {
                    map.put((Object)"slingevent:finishedState", event.getProperty("slingevent:finishedState"));
                } else {
                    switch (event.getTopic()) {
                        case "org/apache/sling/event/notification/job/FINISHED": {
                            map.put((Object)"slingevent:finishedState", (Object)Job.JobState.SUCCEEDED.name());
                            break;
                        }
                        case "org/apache/sling/event/notification/job/CANCELLED": {
                            if ("execution stopped".equals(event.getProperty("slingevent:resultMessage"))) {
                                map.put((Object)"slingevent:finishedState", (Object)Job.JobState.STOPPED.name());
                                break;
                            }
                            map.put((Object)"slingevent:finishedState", (Object)Job.JobState.ERROR.name());
                            break;
                        }
                        case "org/apache/sling/event/notification/job/FAILED": {
                            map.put((Object)"slingevent:finishedState", (Object)Job.JobState.GIVEN_UP.name());
                        }
                    }
                }
                adminResolver.commit();
            }
        }
    }

    protected <T> T getProperty(Job job, String name, T defaultValue) {
        Object value = job.getProperty(name);
        return (T)(value != null ? value : defaultValue);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jcr:primaryType", "sling:Folder");
        CRUD_AUDIT_FOLDER_PROPS = Collections.unmodifiableMap(map);
    }

    protected abstract class UserContextCallable
    implements Callable<Result> {
        protected final Job job;
        protected final JobExecutionContext context;
        protected final ResourceResolver serviceResolver;
        protected final PrintWriter out;
        protected final Session session;

        public UserContextCallable(Job job, JobExecutionContext context, ResourceResolver serviceResolver, PrintWriter out) throws RepositoryException, LoginException {
            this.job = job;
            this.context = context;
            this.serviceResolver = serviceResolver;
            this.out = out;
            String userId = (String)job.getProperty(AbstractJobExecutor.JOB_USERID_PROPERTY, String.class);
            Session serviceSession = (Session)serviceResolver.adaptTo(Session.class);
            this.session = serviceSession.impersonate((Credentials)new SimpleCredentials(userId, new char[0]));
            HashMap<String, Session> authInfo = new HashMap<String, Session>();
            authInfo.put("user.jcr.session", this.session);
        }

        public void close() {
            this.session.logout();
        }
    }
}

