/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.concurrent;

import com.composum.sling.core.concurrent.JobFacade;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.jetbrains.annotations.Nullable;

public class JobUtil {
    @Nullable
    public static JobFacade getJobById(JobManager jobManager, ResourceResolver resolver, String jobId) {
        Job job = jobManager.getJobById(jobId);
        if (job == null) {
            Iterator resources = resolver.findResources("/jcr:root/var/audit/jobs//*[slingevent:eventId='" + jobId + "']", "xpath");
            if (resources.hasNext()) {
                Resource audit = (Resource)resources.next();
                return new JobFacade.AuditJob(audit);
            }
            return null;
        }
        return new JobFacade.EventJob(job);
    }

    public static Collection<JobFacade> getAuditJobs(JobManager.QueryType state, ResourceResolver resolver) {
        ArrayList<JobFacade> result = new ArrayList<JobFacade>();
        Iterator resources = resolver.findResources("/jcr:root/var/audit/jobs//*[@slingevent:eventId]", "xpath");
        while (resources.hasNext()) {
            JobFacade.AuditJob job = new JobFacade.AuditJob((Resource)resources.next());
            Job.JobState jobState = job.getJobState();
            if (state != JobManager.QueryType.ALL && state != JobManager.QueryType.HISTORY && !state.name().equals(jobState.name())) continue;
            result.add(job);
        }
        return result;
    }

    public static String buildOutfileName(Map<String, Object> properties) {
        String outfile = (String)properties.get("outfile");
        if (StringUtils.isBlank((CharSequence)outfile)) {
            String outfilePrefix = (String)properties.get("outfileprefix");
            String tmpdir = System.getProperty("java.io.tmpdir");
            boolean endsWithSeparator = tmpdir.charAt(tmpdir.length() - 1) == File.separatorChar;
            outfile = tmpdir + (endsWithSeparator ? "" : File.separator) + (StringUtils.isBlank((CharSequence)outfilePrefix) ? "slingjob" : outfilePrefix) + "_" + System.currentTimeMillis() + ".out";
            properties.put("outfile", outfile);
        }
        return outfile;
    }

    public static class JobComparator
    implements Comparator<JobFacade> {
        @Override
        public int compare(JobFacade o1, JobFacade o2) {
            Calendar j1s = o1.getProcessingStarted();
            Calendar j2s = o2.getProcessingStarted();
            return j1s.compareTo(j2s);
        }
    }
}

