/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.filter;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.NodeTypeFilters;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.jcr.ResourceFilterMapping;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.SlingResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ResourceFilter {
    public static final Pattern SIMPLE_ARRAY_PATTERN = Pattern.compile("^([+-])\\[(.*)]$");
    public static final ResourceFilter ALL = new AllFilter();
    public static final ResourceFilter FOLDER = new FolderFilter();

    public boolean accept(@Nullable Resource var1);

    public boolean isRestriction();

    public void toString(@NotNull StringBuilder var1);

    public static class ContentNodeFilter
    extends AbstractResourceFilter {
        private static final Logger LOG = LoggerFactory.getLogger(ContentNodeFilter.class);
        private static final Pattern ARGUMENT_PATTERN = Pattern.compile("([-+]),(.+)=jcr:content=>(.+)");
        private final ResourceFilter applicableFilter;
        private final ResourceFilter contentNodeFilter;
        private final boolean restriction;

        public ContentNodeFilter(boolean restriction, @NotNull ResourceFilter applicableFilter, @NotNull ResourceFilter contentNodeFilter) {
            this.restriction = restriction;
            this.applicableFilter = Objects.requireNonNull(applicableFilter);
            this.contentNodeFilter = Objects.requireNonNull(contentNodeFilter);
        }

        public ContentNodeFilter(@NotNull String filterData) {
            Matcher m = ARGUMENT_PATTERN.matcher(filterData);
            if (!m.matches()) {
                throw new IllegalArgumentException("Cannot parse arguments from \"" + filterData + "\"");
            }
            this.restriction = "-".equals(m.group(1));
            this.applicableFilter = ResourceFilterMapping.fromString(m.group(2));
            this.contentNodeFilter = ResourceFilterMapping.fromString(m.group(3));
        }

        @Override
        public boolean accept(Resource resource) {
            boolean result;
            Resource contentNode;
            boolean applicable = this.applicableFilter.accept(resource);
            Resource resource2 = contentNode = applicable && resource != null ? resource.getChild("jcr:content") : null;
            if (this.restriction) {
                result = !applicable || this.contentNodeFilter.accept(contentNode);
            } else {
                boolean bl = result = applicable && this.contentNodeFilter.accept(contentNode);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("accept {} = {} , applicable {}", new Object[]{SlingResourceUtil.getPath(resource), result, applicable});
            }
            return result;
        }

        public ResourceFilter getApplicableFilter() {
            return this.applicableFilter;
        }

        public ResourceFilter getContentNodeFilter() {
            return this.contentNodeFilter;
        }

        @Override
        public boolean isRestriction() {
            return this.restriction;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("ContentNode(");
            builder.append(this.restriction ? "-," : "+,");
            this.applicableFilter.toString(builder);
            builder.append("=jcr:content=>");
            this.contentNodeFilter.toString(builder);
            builder.append(")");
        }
    }

    public static class FilterSet
    extends AbstractResourceFilter {
        protected final Rule rule;
        protected final List<ResourceFilter> set;
        protected transient Boolean restriction;

        public FilterSet(Rule rule, ResourceFilter ... filters) {
            this.rule = rule;
            this.set = new ArrayList<ResourceFilter>();
            Collections.addAll(this.set, filters);
        }

        public FilterSet(Rule rule, List<ResourceFilter> filters) {
            this.rule = rule;
            this.set = filters;
        }

        public FilterSet(Rule rule, String ... filters) {
            this.rule = rule;
            this.set = new ArrayList<ResourceFilter>();
            for (String string : filters) {
                ResourceFilter filter = ResourceFilterMapping.fromString(string);
                if (ALL.equals(filter)) continue;
                this.set.add(filter);
            }
        }

        public Rule getRule() {
            return this.rule;
        }

        public List<ResourceFilter> getSet() {
            return this.set;
        }

        public boolean isIntermediate(Resource resource) {
            return this.rule == Rule.tree && this.set.size() > 0 && !this.set.get(0).accept(resource);
        }

        @Override
        public boolean accept(Resource resource) {
            switch (this.rule) {
                case tree: 
                case or: {
                    for (ResourceFilter filter : this.set) {
                        if (!filter.accept(resource)) continue;
                        return true;
                    }
                    return this.set.size() == 0;
                }
                case and: {
                    for (ResourceFilter filter : this.set) {
                        if (filter.accept(resource)) continue;
                        return false;
                    }
                    return this.set.size() > 0;
                }
                case none: {
                    for (ResourceFilter filter : this.set) {
                        if (!filter.accept(resource)) continue;
                        return false;
                    }
                    return true;
                }
                case first: {
                    for (ResourceFilter filter : this.set) {
                        if (filter.accept(resource) && !filter.isRestriction()) {
                            return true;
                        }
                        if (filter.accept(resource) || !filter.isRestriction()) continue;
                        return false;
                    }
                    return false;
                }
                case last: {
                    for (int i = this.set.size() - 1; i >= 0; --i) {
                        ResourceFilter filter = this.set.get(i);
                        if (filter.accept(resource) && !filter.isRestriction()) {
                            return true;
                        }
                        if (filter.accept(resource) || !filter.isRestriction()) continue;
                        return false;
                    }
                    return false;
                }
            }
            return this.isRestriction();
        }

        @Override
        public boolean isRestriction() {
            if (this.restriction == null) {
                block0 : switch (this.rule) {
                    case or: 
                    case last: {
                        this.restriction = true;
                        for (ResourceFilter filter : this.set) {
                            if (filter.isRestriction()) continue;
                            this.restriction = false;
                            break block0;
                        }
                        break;
                    }
                    case and: 
                    case first: {
                        this.restriction = false;
                        for (ResourceFilter filter : this.set) {
                            if (!filter.isRestriction()) continue;
                            this.restriction = true;
                            break block0;
                        }
                        break;
                    }
                    case none: {
                        this.restriction = true;
                        for (ResourceFilter filter : this.set) {
                            if (!filter.isRestriction()) continue;
                            this.restriction = false;
                            break block0;
                        }
                        break;
                    }
                    case tree: {
                        this.restriction = this.set.size() <= 0 || this.set.get(0).isRestriction();
                    }
                }
            }
            return this.restriction;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append(this.rule.name());
            builder.append("{");
            int i = 0;
            while (i < this.set.size()) {
                this.set.get(i).toString(builder);
                if (++i >= this.set.size()) continue;
                builder.append(',');
            }
            builder.append("}");
        }

        public static enum Rule {
            and,
            or,
            first,
            last,
            tree,
            none;


            public FilterSet of(ResourceFilter ... filters) {
                if (this.equals((Object)and) || this.equals((Object)or)) {
                    ArrayList<ResourceFilter> flattenedFilters = new ArrayList<ResourceFilter>();
                    for (ResourceFilter filter : filters) {
                        if (filter instanceof FilterSet && ((FilterSet)filter).rule.equals((Object)this)) {
                            flattenedFilters.addAll(((FilterSet)filter).getSet());
                            continue;
                        }
                        flattenedFilters.add(filter);
                    }
                    return new FilterSet(this, flattenedFilters);
                }
                return new FilterSet(this, filters);
            }
        }
    }

    public static class MimeTypeFilter
    extends PatternFilter {
        public MimeTypeFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            if (resource != null) {
                ResourceHandle handle = ResourceHandle.use(resource);
                String mimeType = handle.getProperty("jcr:mimeType");
                if (StringUtils.isNotBlank((CharSequence)mimeType)) {
                    return this.filter.accept(mimeType);
                }
                Resource content = handle.getChild("jcr:content");
                return this.accept(content);
            }
            return false;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("MimeType(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class ResourceTypeFilter
    extends PatternFilter {
        public ResourceTypeFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            if (resource != null) {
                String type = resource.getResourceType();
                if (StringUtils.isNotBlank((CharSequence)type)) {
                    return this.accept(type);
                }
                Resource content = resource.getChild("jcr:content");
                return this.accept(content);
            }
            return false;
        }

        protected boolean accept(String resourceType) {
            return StringUtils.isNotBlank((CharSequence)resourceType) && this.filter.accept(resourceType);
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("ResourceType(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class NodeTypeFilter
    extends PatternFilter {
        public NodeTypeFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            Node node;
            if (resource != null && (node = (Node)resource.adaptTo(Node.class)) != null) {
                try {
                    NodeType[] mixinTypes;
                    NodeType primaryNodeType = node.getPrimaryNodeType();
                    if (this.filter.isRestriction() != this.filter.accept(primaryNodeType.getName())) {
                        return !this.filter.isRestriction();
                    }
                    for (NodeType primarySuperType : primaryNodeType.getSupertypes()) {
                        if (this.filter.isRestriction() == this.filter.accept(primarySuperType.getName())) continue;
                        return !this.filter.isRestriction();
                    }
                    for (NodeType mixinType : mixinTypes = node.getMixinNodeTypes()) {
                        if (this.filter.isRestriction() != this.filter.accept(mixinType.getName())) {
                            return !this.filter.isRestriction();
                        }
                        for (NodeType mixinSuperType : mixinType.getSupertypes()) {
                            if (this.filter.isRestriction() == this.filter.accept(mixinSuperType.getName())) continue;
                            return !this.filter.isRestriction();
                        }
                    }
                    return this.filter.isRestriction();
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("NodeType(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class PrimaryTypeFilter
    extends PatternFilter {
        public PrimaryTypeFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            String primaryType = ResourceUtil.getPrimaryType(resource);
            if (StringUtils.isNotBlank((CharSequence)primaryType)) {
                return this.filter.accept(primaryType);
            }
            return false;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("PrimaryType(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class PathFilter
    extends PatternFilter {
        public PathFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            return resource != null && this.filter.accept(resource.getPath());
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("Path(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static class NameFilter
    extends PatternFilter {
        public NameFilter(StringFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Resource resource) {
            return resource != null && this.filter.accept(resource.getName());
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("Name(");
            super.toString(builder);
            builder.append(")");
        }
    }

    public static abstract class PatternFilter
    extends AbstractResourceFilter {
        protected StringFilter filter;

        public StringFilter getFilter() {
            return this.filter;
        }

        @Override
        public boolean isRestriction() {
            return this.filter.isRestriction();
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            this.filter.toString(builder);
        }
    }

    public static class TypeFilter
    extends AbstractResourceFilter {
        private static final Logger LOG = LoggerFactory.getLogger(TypeFilter.class);
        @NotNull
        protected List<String> typeNames;
        protected boolean restriction = false;

        @NotNull
        public List<String> getTypeNames() {
            return this.typeNames;
        }

        public TypeFilter(String names) {
            Matcher matcher = SIMPLE_ARRAY_PATTERN.matcher(names);
            if (matcher.matches()) {
                this.restriction = "-".equals(matcher.group(1));
                names = matcher.group(2);
            }
            this.typeNames = Arrays.asList(StringUtils.split((String)names, (String)","));
        }

        public TypeFilter(@Nullable List<String> names, boolean restriction) {
            this.typeNames = names != null ? Collections.unmodifiableList(new ArrayList<String>(names)) : Collections.emptyList();
            this.restriction = restriction;
        }

        @Override
        public boolean accept(Resource resource) {
            if (resource == null) {
                return this.restriction;
            }
            for (String type : this.typeNames) {
                if (type.startsWith("node:")) {
                    if (!NodeTypeFilters.accept(resource, type)) continue;
                    return !this.restriction;
                }
                if (!StringUtils.contains((CharSequence)type, (CharSequence)"/")) {
                    try {
                        Node node = (Node)resource.adaptTo(Node.class);
                        if (node != null && node.isNodeType(type)) {
                            return !this.restriction;
                        }
                    }
                    catch (RepositoryException e) {
                        LOG.error("Error checking node type for " + resource.getPath(), (Throwable)e);
                    }
                }
                if (!resource.isResourceType(type)) continue;
                return !this.restriction;
            }
            return this.restriction;
        }

        @Override
        public boolean isRestriction() {
            return this.restriction;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("Type(");
            this.typeNamesToString(builder);
            builder.append(")");
        }

        public void typeNamesToString(StringBuilder builder) {
            builder.append(this.restriction ? (char)'-' : '+');
            builder.append('[');
            builder.append(StringUtils.join(this.typeNames, (String)","));
            builder.append(']');
        }
    }

    public static class FolderFilter
    extends PrimaryTypeFilter {
        public FolderFilter() {
            super(new StringFilter.WhiteList("^(sling|nt):.*[Ff]older$"));
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("Folder()");
        }
    }

    public static final class AllFilter
    extends AbstractResourceFilter {
        @Override
        public boolean accept(Resource resource) {
            return resource != null;
        }

        @Override
        public boolean isRestriction() {
            return true;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("All()");
        }
    }

    public static abstract class AbstractResourceFilter
    implements ResourceFilter {
        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf);
            return buf.toString();
        }
    }
}

