/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.mapping.jcr;

import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.jcr.ResourceFilterMapping;
import com.composum.sling.core.mapping.jcr.StringFilterMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

public class ObjectMapping {
    public static final ObjectFilter OBJECT_FILTER = new ObjectFilter();
    protected static final ResourceFilter RESOURCE_FILTER_FILTER = new ResourceFilter.ResourceTypeFilter(new StringFilter.WhiteList("^composum/nodes/core/filter/resources$"));
    protected static final ResourceFilter STRING_FILTER_FILTER = new ResourceFilter.ResourceTypeFilter(new StringFilter.WhiteList("^composum/nodes/core/filter/strings$"));
    protected static final ResourceFilterStrategy RESOURCE_FILTER_STRATEGY = new ResourceFilterStrategy();
    protected static final StringFilterStrategy STRING_FILTER_STRATEGY = new StringFilterStrategy();
    protected static final List<ResourceFilter> FROM_RESOURCE_FILTERS;
    protected static final List<MappingStrategy> FROM_RESOURCE_STRATEGIES;
    protected static final Map<Class<?>, MappingStrategy> TO_RESOURCE_STRATEGIES;

    public static Object fromResource(Resource resource) throws Exception {
        MappingStrategy strategy;
        Object object = null;
        if (resource != null && (strategy = ObjectMapping.getStrategy(resource)) != null) {
            object = strategy.fromResource(resource);
        }
        return object;
    }

    public static void toResource(Resource resource, Object object) throws RepositoryException {
        MappingStrategy strategy;
        if (resource != null && object != null && (strategy = ObjectMapping.getStrategy(object.getClass())) != null) {
            strategy.toResource(resource, object);
        }
    }

    public static MappingStrategy getStrategy(Resource resource) {
        for (int i = 0; i < FROM_RESOURCE_FILTERS.size(); ++i) {
            if (!FROM_RESOURCE_FILTERS.get(i).accept(resource)) continue;
            return FROM_RESOURCE_STRATEGIES.get(i);
        }
        return null;
    }

    public static MappingStrategy getStrategy(Class<?> objectType) {
        return TO_RESOURCE_STRATEGIES.get(objectType);
    }

    static {
        TO_RESOURCE_STRATEGIES = new HashMap();
        TO_RESOURCE_STRATEGIES.put(ResourceFilter.FilterSet.class, RESOURCE_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(ResourceFilter.ResourceTypeFilter.class, RESOURCE_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(ResourceFilter.NodeTypeFilter.class, RESOURCE_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(ResourceFilter.PrimaryTypeFilter.class, RESOURCE_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(ResourceFilter.PathFilter.class, RESOURCE_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(ResourceFilter.NameFilter.class, RESOURCE_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(ResourceFilter.FolderFilter.class, RESOURCE_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(ResourceFilter.AllFilter.class, RESOURCE_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(StringFilter.FilterSet.class, STRING_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(StringFilter.WhiteList.class, STRING_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(StringFilter.BlackList.class, STRING_FILTER_STRATEGY);
        TO_RESOURCE_STRATEGIES.put(StringFilter.All.class, STRING_FILTER_STRATEGY);
        FROM_RESOURCE_FILTERS = new ArrayList<ResourceFilter>();
        FROM_RESOURCE_STRATEGIES = new ArrayList<MappingStrategy>();
        FROM_RESOURCE_FILTERS.add(RESOURCE_FILTER_FILTER);
        FROM_RESOURCE_STRATEGIES.add(RESOURCE_FILTER_STRATEGY);
        FROM_RESOURCE_FILTERS.add(STRING_FILTER_FILTER);
        FROM_RESOURCE_STRATEGIES.add(STRING_FILTER_STRATEGY);
    }

    public static interface MappingStrategy<T> {
        public T fromResource(Resource var1) throws Exception;

        public void toResource(Resource var1, T var2) throws RepositoryException;
    }

    public static class StringFilterStrategy
    implements MappingStrategy<StringFilter> {
        @Override
        public StringFilter fromResource(Resource resource) throws Exception {
            return StringFilterMapping.fromResource(resource);
        }

        @Override
        public void toResource(Resource resource, StringFilter filter) throws RepositoryException {
            StringFilterMapping.toResource(resource, filter);
        }
    }

    public static class ResourceFilterStrategy
    implements MappingStrategy<ResourceFilter> {
        @Override
        public ResourceFilter fromResource(Resource resource) throws Exception {
            return ResourceFilterMapping.fromResource(resource);
        }

        @Override
        public void toResource(Resource resource, ResourceFilter filter) throws RepositoryException {
            ResourceFilterMapping.toResource(resource, filter);
        }
    }

    public static class ObjectFilter
    extends ResourceFilter.AbstractResourceFilter {
        @Override
        public boolean accept(Resource resource) {
            return ObjectMapping.getStrategy(resource) != null;
        }

        @Override
        public boolean isRestriction() {
            return false;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("Object(...)");
        }
    }
}

