/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.mapping.jcr;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.util.ResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFilterMapping {
    private static final Logger LOG = LoggerFactory.getLogger(StringFilterMapping.class);
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_RULE = "rule";
    public static final String PROPERTY_PATTERNS = "patterns";
    public static final String NODE_NAME_ENTRY = "entry";
    public static final String STRING_FILTER_TYPE = "composum/nodes/core/filter/strings";
    public static final Pattern FILTER_SET_PATTERN = Pattern.compile("^(and|or|first|last)\\{(.+)\\}$");
    public static final Pattern STRING_PATTERN = Pattern.compile("^(\\+|-|All)('(.*)')?$");
    public static final String DEFAULT_FILTER_TYPE = "+";
    public static final String ALL_FILTER_TYPE = "All";
    protected static final Map<Class<? extends StringFilter>, MappingStrategy> STRATEGY_MAP = new HashMap<Class<? extends StringFilter>, MappingStrategy>();
    protected static final MappingStrategy DEFAULT_STRATEGY;
    public static final Pattern SIMPLIFY_TYPE_PATTERN;
    public static final Pattern IS_SIMPLIFIED_TYPE_PATTERN;

    public static StringFilter fromString(String rules) {
        StringFilter filter;
        block16: {
            filter = StringFilter.ALL;
            Matcher matcher = FILTER_SET_PATTERN.matcher(rules);
            if (matcher.matches()) {
                String type = matcher.group(1);
                String values = matcher.group(2);
                try {
                    StringFilter.FilterSet.Rule rule = StringFilter.FilterSet.Rule.valueOf(type);
                    ArrayList<StringFilter> filters = new ArrayList<StringFilter>();
                    String nextRule = "";
                    for (String item : StringUtils.split((String)values, (char)',')) {
                        if (StringUtils.isBlank((CharSequence)(nextRule = nextRule + item)) || STRING_PATTERN.matcher(nextRule).matches() || FILTER_SET_PATTERN.matcher(nextRule).matches()) {
                            filters.add(StringFilterMapping.fromString(nextRule));
                            nextRule = "";
                            continue;
                        }
                        nextRule = nextRule + ",";
                    }
                    filter = new StringFilter.FilterSet(rule, filters);
                }
                catch (Exception ex) {
                    LOG.error("invalid filter rule: '" + rules + "' (" + ex.toString() + ")");
                }
            } else {
                matcher = STRING_PATTERN.matcher(rules);
                if (matcher.matches()) {
                    String type = matcher.group(1);
                    if (StringUtils.isBlank((CharSequence)type)) {
                        type = DEFAULT_FILTER_TYPE;
                    }
                    String values = matcher.group(3);
                    try {
                        StringFilter.FilterSet.Rule rule = StringFilter.FilterSet.Rule.valueOf(type);
                        ArrayList<StringFilter> filters = new ArrayList<StringFilter>();
                        String nextRule = "";
                        for (String item : StringUtils.split((String)values, (char)',')) {
                            if (STRING_PATTERN.matcher(nextRule = nextRule + item).matches() || StringUtils.isBlank((CharSequence)nextRule)) {
                                filters.add(StringFilterMapping.fromString(nextRule));
                                nextRule = "";
                                continue;
                            }
                            nextRule = nextRule + ",";
                        }
                        filter = new StringFilter.FilterSet(rule, filters);
                    }
                    catch (IllegalArgumentException iaex) {
                        if (ALL_FILTER_TYPE.equals(type)) {
                            filter = StringFilter.ALL;
                            break block16;
                        }
                        if ("-".equals(type)) {
                            filter = new StringFilter.BlackList(values);
                            break block16;
                        }
                        filter = new StringFilter.WhiteList(values);
                    }
                } else if (StringUtils.isNotBlank((CharSequence)rules)) {
                    LOG.error("invalid filter rule: '" + rules + "'");
                }
            }
        }
        return filter;
    }

    public static StringFilter fromResource(Resource resource) throws Exception {
        StringFilter filter = null;
        if (resource != null) {
            ResourceHandle handle = ResourceHandle.use(resource);
            String typeName = handle.getProperty(PROPERTY_TYPE);
            Class<? extends StringFilter> type = StringFilterMapping.getType(typeName);
            MappingStrategy strategy = StringFilterMapping.getStrategy(type);
            filter = strategy.fromResource(resource);
        }
        return filter;
    }

    public static void toResource(Resource resource, StringFilter filter) throws RepositoryException {
        if (resource != null) {
            MappingStrategy strategy = StringFilterMapping.getStrategy(filter.getClass());
            strategy.toResource(resource, filter);
        }
    }

    public static MappingStrategy getStrategy(Class<? extends StringFilter> type) {
        MappingStrategy strategy = STRATEGY_MAP.get(type);
        return strategy != null ? strategy : DEFAULT_STRATEGY;
    }

    public static Class<? extends StringFilter> getType(String typeName) throws Exception {
        if (IS_SIMPLIFIED_TYPE_PATTERN.matcher(typeName).matches()) {
            typeName = StringFilter.class.getName() + "$" + typeName;
        }
        Class<?> type = Class.forName(typeName);
        return type;
    }

    public static String getTypeName(StringFilter value) {
        String typeName = value.getClass().getName();
        Matcher simplifyTypeMatcher = SIMPLIFY_TYPE_PATTERN.matcher(typeName);
        if (simplifyTypeMatcher.matches()) {
            typeName = simplifyTypeMatcher.group(1);
        }
        return typeName;
    }

    static {
        STRATEGY_MAP.put(StringFilter.FilterSet.class, new FilterSetStrategy());
        STRATEGY_MAP.put(StringFilter.WhiteList.class, new PatternFilterStrategy());
        STRATEGY_MAP.put(StringFilter.BlackList.class, new PatternFilterStrategy());
        STRATEGY_MAP.put(StringFilter.All.class, new AllFilterStrategy());
        DEFAULT_STRATEGY = new GeneralStrategy();
        SIMPLIFY_TYPE_PATTERN = Pattern.compile("^" + StringFilter.class.getName() + ".([A-Za-z]+)$");
        IS_SIMPLIFIED_TYPE_PATTERN = Pattern.compile("^[A-Za-z]+$");
    }

    public static class FilterSetStrategy
    extends GeneralStrategy {
        @Override
        protected StringFilter createInstance(ResourceHandle resource, Class<? extends StringFilter> type) throws Exception {
            StringFilter.FilterSet.Rule rule = StringFilter.FilterSet.Rule.valueOf(resource.getProperty(StringFilterMapping.PROPERTY_RULE, (String)null));
            List<ResourceHandle> filterResources = resource.getChildrenByResourceType(StringFilterMapping.STRING_FILTER_TYPE);
            ArrayList<StringFilter> filterList = new ArrayList<StringFilter>();
            for (ResourceHandle filterRes : filterResources) {
                StringFilter filter = StringFilterMapping.fromResource((Resource)filterRes);
                filterList.add(filter);
            }
            StringFilter filter = type.getConstructor(StringFilter.FilterSet.Rule.class, List.class).newInstance(new Object[]{rule, filterList});
            return filter;
        }

        @Override
        public void toResource(Resource resource, StringFilter filter) throws RepositoryException {
            super.toResource(resource, filter);
            StringFilter.FilterSet filterSet = (StringFilter.FilterSet)filter;
            ResourceHandle handle = ResourceHandle.use(resource);
            StringFilter.FilterSet.Rule rule = filterSet.getRule();
            handle.setProperty(StringFilterMapping.PROPERTY_RULE, rule.name());
            List<StringFilter> set = filterSet.getSet();
            for (int i = 0; i < set.size(); ++i) {
                ResourceHandle entry = ResourceHandle.use(ResourceUtil.getOrCreateChild(resource, "entry-" + i, "nt:unstructured"));
                StringFilterMapping.toResource((Resource)entry, set.get(i));
            }
        }
    }

    public static class PatternFilterStrategy
    extends GeneralStrategy {
        @Override
        protected StringFilter createInstance(ResourceHandle resource, Class<? extends StringFilter> type) throws Exception {
            String[] patternStrings = resource.getProperty(StringFilterMapping.PROPERTY_PATTERNS, String[].class);
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String pattern : patternStrings) {
                patterns.add(Pattern.compile(pattern));
            }
            StringFilter filter = type.getConstructor(List.class).newInstance(patterns);
            return filter;
        }

        @Override
        public void toResource(Resource resource, StringFilter filter) throws RepositoryException {
            super.toResource(resource, filter);
            ResourceHandle handle = ResourceHandle.use(resource);
            List<Pattern> patternList = ((StringFilter.PatternList)filter).getPatterns();
            ArrayList<String> valueList = new ArrayList<String>();
            for (Pattern pattern : patternList) {
                valueList.add(pattern.pattern());
            }
            handle.setProperty(StringFilterMapping.PROPERTY_PATTERNS, valueList);
        }
    }

    public static class AllFilterStrategy
    extends GeneralStrategy {
        @Override
        protected StringFilter createInstance(ResourceHandle resource, Class<? extends StringFilter> type) throws Exception {
            return StringFilter.ALL;
        }
    }

    public static class GeneralStrategy
    implements MappingStrategy {
        protected StringFilter createInstance(ResourceHandle resource, Class<? extends StringFilter> type) throws Exception {
            StringFilter filter = type.newInstance();
            return filter;
        }

        @Override
        public StringFilter fromResource(Resource resource) throws Exception {
            ResourceHandle handle = ResourceHandle.use(resource);
            String typeName = handle.getProperty(StringFilterMapping.PROPERTY_TYPE, (String)null);
            Class<? extends StringFilter> type = StringFilterMapping.getType(typeName);
            StringFilter filter = this.createInstance(handle, type);
            return filter;
        }

        @Override
        public void toResource(Resource resource, StringFilter filter) throws RepositoryException {
            ResourceHandle handle = ResourceHandle.use(resource);
            handle.setProperty("sling:resourceType", StringFilterMapping.STRING_FILTER_TYPE);
            handle.setProperty(StringFilterMapping.PROPERTY_TYPE, StringFilterMapping.getTypeName(filter));
        }
    }

    public static interface MappingStrategy {
        public StringFilter fromResource(Resource var1) throws Exception;

        public void toResource(Resource var1, StringFilter var2) throws RepositoryException;
    }
}

