/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.proxy;

import com.composum.sling.core.proxy.GenericProxyConfig;
import com.composum.sling.core.proxy.GenericProxyReader;
import com.composum.sling.core.proxy.GenericProxyService;
import com.composum.sling.core.util.ValueEmbeddingReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.http.HttpService;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

@Component(service={GenericProxyService.class}, scope=ServiceScope.PROTOTYPE)
@Designate(ocd=GenericProxyConfig.class, factory=true)
public class GenericProxyRequest
implements GenericProxyService {
    private static final Logger LOG = LoggerFactory.getLogger(GenericProxyRequest.class);
    public static final Pattern XML_CONTENT_URL = Pattern.compile("^.*/[^/]+\\.(html|xml)(\\?.*)?$");
    public static final Pattern XML_CONTENT_TYPE = Pattern.compile("^text/(html|xml)(;.*)?$");
    protected GenericProxyConfig config;
    protected Pattern targetPattern;
    protected BundleContext bundleContext;

    @Activate
    @Modified
    protected void activate(ComponentContext context, GenericProxyConfig config) {
        String rule;
        this.bundleContext = context.getBundleContext();
        this.config = config;
        if (config.enabled() && StringUtils.isNotBlank((CharSequence)(rule = config.targetPattern()))) {
            this.targetPattern = Pattern.compile(rule.startsWith("/") ? "^" + rule : rule);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.config.name();
    }

    @Override
    public boolean doProxy(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull String targetUrl) throws IOException {
        Matcher matcher;
        if (this.config.enabled() && (matcher = this.targetPattern.matcher(targetUrl)).find()) {
            try {
                boolean allowed = false;
                String referencePath = this.config.referencePath();
                if (StringUtils.isNotBlank((CharSequence)referencePath)) {
                    ResourceResolver resolver = request.getResourceResolver();
                    if (referencePath.startsWith("/")) {
                        allowed = resolver.getResource(referencePath) != null;
                    } else {
                        for (String root : resolver.getSearchPath()) {
                            boolean bl = allowed = resolver.getResource(root + referencePath) != null;
                            if (allowed) break;
                        }
                    }
                }
                if (!allowed) {
                    return false;
                }
                this.doRequest(request, response, targetUrl, matcher);
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(500);
            }
            return true;
        }
        return false;
    }

    protected void doRequest(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull String targetRef, @NotNull Matcher matcher) throws Exception {
        String targetUrl = this.getTargetUrl(request, targetRef, matcher);
        if (StringUtils.isNotBlank((CharSequence)targetUrl)) {
            CloseableHttpClient client = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(targetUrl);
            httpGet.addHeader("Cookie", request.getHeader("Cookie"));
            LOG.info("proxy request '{}'", (Object)httpGet.getRequestLine());
            try (CloseableHttpResponse targetResponse = client.execute((HttpUriRequest)httpGet);){
                HttpEntity entity = targetResponse.getEntity();
                if (entity != null) {
                    this.doResponse(request, response, targetUrl, entity);
                }
                LOG.warn("response is NULL ({})", (Object)targetUrl);
            }
        } else {
            LOG.info("no target URL: NOP ({})", (Object)targetRef);
        }
    }

    protected void doResponse(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull String targetUrl, @NotNull HttpEntity entity) throws IOException {
        block34: {
            try (InputStream inputStream = entity.getContent();){
                String contentType = this.getContentType(targetUrl, entity);
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    response.setContentType(contentType);
                }
                if (contentType != null && XML_CONTENT_TYPE.matcher(contentType).matches()) {
                    SAXTransformerFactory stf = null;
                    XMLFilter xmlFilter = null;
                    String[] xsltChainPaths = this.config.XSLT_chain_paths();
                    if (xsltChainPaths.length > 0) {
                        stf = (SAXTransformerFactory)TransformerFactory.newInstance();
                        xmlFilter = this.getXsltFilter(stf, request.getResourceResolver(), xsltChainPaths);
                    }
                    if (xmlFilter != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("XSLT transformation ({})...", xmlFilter);
                        }
                        try (Reader entityReader = this.getContentReader(targetUrl, inputStream);){
                            Transformer transformer = stf.newTransformer();
                            SAXSource transformSource = new SAXSource(xmlFilter, new InputSource(entityReader));
                            transformer.transform(transformSource, new StreamResult(response.getWriter()));
                            break block34;
                        }
                        catch (Exception ex) {
                            LOG.error(ex.getMessage(), (Throwable)ex);
                        }
                        break block34;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("pumping HTML/XML content...");
                    }
                    try (Reader entityReader = this.getContentReader(targetUrl, inputStream);){
                        IOUtils.copy((Reader)entityReader, (Writer)response.getWriter());
                        break block34;
                    }
                    catch (Exception ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                    }
                    break block34;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("pumping non XML content...");
                }
                response.setContentLength((int)entity.getContentLength());
                try (InputStreamReader entityReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    IOUtils.copy((Reader)entityReader, (Writer)response.getWriter());
                }
            }
        }
    }

    @Nullable
    protected String getContentType(@NotNull String targetUrl, @NotNull HttpEntity entity) {
        Header type = entity.getContentType();
        if (type != null) {
            Header encoding = entity.getContentEncoding();
            return encoding != null ? type.getValue() + ";charset=" + encoding.getValue() : type.getValue();
        }
        Matcher matcher = XML_CONTENT_URL.matcher(targetUrl);
        return matcher.matches() ? "text/" + matcher.group(0) + ";charset=utf-8" : null;
    }

    @NotNull
    protected Reader getContentReader(@NotNull String targetUrl, @NotNull InputStream entityContent) {
        Reader reader;
        String[] toRename = this.config.tags_to_rename();
        String[] toStrip = this.config.tags_to_strip();
        String[] toDrop = this.config.tags_to_drop();
        Reader reader2 = reader = toRename.length > 0 || toStrip.length > 0 || toDrop.length > 0 ? new GenericProxyReader(entityContent, toRename, toStrip, toDrop) : new InputStreamReader(entityContent, StandardCharsets.UTF_8);
        if (LOG.isDebugEnabled()) {
            LOG.debug("using reader '{}' ({})", (Object)reader, (Object)targetUrl);
        }
        return reader;
    }

    @Nullable
    protected String getTargetUrl(@NotNull SlingHttpServletRequest request, @NotNull String targetRef, @NotNull Matcher matcher) {
        String targetUrl = this.config.targetUrl();
        if (StringUtils.isNotBlank((CharSequence)targetUrl)) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            this.addHttpValues(properties);
            properties.put("ctx", request.getContextPath());
            properties.put("url", targetRef);
            for (int i = 0; i < matcher.groupCount(); ++i) {
                properties.put(Integer.toString(i), matcher.group(i));
            }
            ValueEmbeddingReader reader = new ValueEmbeddingReader(new StringReader(targetUrl), properties);
            try {
                targetUrl = IOUtils.toString((Reader)reader);
            }
            catch (IOException ex) {
                LOG.error(ex.toString());
                targetUrl = null;
            }
        } else {
            targetUrl = targetRef.startsWith("/") ? request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + targetRef : targetRef;
        }
        return targetUrl;
    }

    protected void addHttpValues(@NotNull Map<String, Object> values) {
        ServiceReference service = this.bundleContext.getServiceReference(HttpService.class);
        String endpoint = Arrays.asList((String[])service.getProperty("osgi.http.endpoint")).get(0);
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        values.put("http.endpoint", endpoint);
        values.put("http.port", Integer.parseInt(service.getProperty("org.osgi.service.http.port").toString()));
    }

    @Nullable
    protected XMLFilter getXsltFilter(@NotNull SAXTransformerFactory stf, @NotNull ResourceResolver resolver, @NotNull String[] xsltChainPaths) {
        XMLFilter xmlFilter = null;
        try {
            for (String xsltPath : xsltChainPaths) {
                XMLFilter next = GenericProxyRequest.getXmlFilter(stf, resolver.getResource(xsltPath));
                if (next == null) continue;
                if (xmlFilter == null) {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    spf.setNamespaceAware(true);
                    spf.setValidating(false);
                    SAXParser parser = spf.newSAXParser();
                    XMLReader reader = parser.getXMLReader();
                    next.setParent(reader);
                } else {
                    next.setParent(xmlFilter);
                }
                xmlFilter = next;
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return xmlFilter;
    }

    public static XMLFilter getXmlFilter(@NotNull SAXTransformerFactory stf, @Nullable Resource xsltResource) {
        XMLFilter filter = null;
        InputStream inputStream = GenericProxyRequest.getFileContent(xsltResource);
        if (inputStream != null) {
            try {
                filter = stf.newXMLFilter(new StreamSource(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
            }
            catch (TransformerConfigurationException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return filter;
    }

    @Nullable
    public static InputStream getFileContent(@Nullable Resource resource) {
        InputStream inputStream = null;
        if ((resource = GenericProxyRequest.getFileResource(resource)) != null) {
            ValueMap values = resource.getValueMap();
            inputStream = (InputStream)values.get("jcr:data", InputStream.class);
        }
        return inputStream;
    }

    @Nullable
    public static Resource getFileResource(@Nullable Resource resource) {
        return resource != null && resource.isResourceType("nt:file") ? resource.getChild("jcr:content") : resource;
    }
}

