/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.resource;

import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.resource.ResourceNodeIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticQueryResult
extends SyntheticResource {
    private static final Logger LOG = LoggerFactory.getLogger(SyntheticQueryResult.class);
    protected final QueryResult queryResult;
    protected final ModifiableValueMap valueMap;
    protected final ResourceFilter filter;

    public SyntheticQueryResult(ResourceResolver resolver, String path, QueryResult queryResult) {
        this(resolver, path, queryResult, ResourceFilter.ALL);
    }

    public SyntheticQueryResult(ResourceResolver resolver, String path, QueryResult queryResult, ResourceFilter filter) {
        this(resolver, path, queryResult, filter, "sling:Folder");
    }

    public SyntheticQueryResult(ResourceResolver resolver, String path, QueryResult queryResult, ResourceFilter filter, String resourceType) {
        super(resolver, path, resourceType);
        this.queryResult = queryResult;
        this.filter = filter;
        this.valueMap = new ModifiableValueMapDecorator(new HashMap());
        this.putValue("sling:resourceType", resourceType);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (ValueMap.class.isAssignableFrom(type)) {
            return type.cast(this.valueMap);
        }
        return (AdapterType)super.adaptTo(type);
    }

    public void putValue(String path, Object value) {
        this.valueMap.put((Object)path, value);
    }

    @NotNull
    public Iterator<Resource> listChildren() {
        try {
            return new ResourceNodeIterator(this.getResourceResolver(), this.queryResult.getNodes(), this.filter);
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return Collections.emptyIterator();
        }
    }
}

