/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.service.impl;

import com.composum.sling.core.service.ServiceRestrictions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ServiceRestrictions.class}, property={"service.description=Composum Service Restrictions", "sling.filter.scope=REQUEST"}, immediate=true)
@Designate(ocd=Config.class)
public class ServiceRestrictionsImpl
implements ServiceRestrictions {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRestrictionsImpl.class);
    private final Map<ServiceRestrictions.Key, ServiceRestrictions.Restriction> restrictions = Collections.synchronizedMap(new HashMap());
    private final Map<ServiceRestrictions.Permission, Set<String>> userOptions = Collections.synchronizedMap(new HashMap());
    private BundleContext bundleContext;
    private Config config;
    private final Map<Pattern, ServiceRestrictions.Key> restrictedPaths = new LinkedHashMap<Pattern, ServiceRestrictions.Key>();

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Config config) {
        this.bundleContext = bundleContext;
        this.config = config;
        this.restrictions.clear();
        for (String rule : config.restrictions()) {
            this.addRestriction(rule);
        }
        this.userOptions.clear();
        for (String rule : StringUtils.split((String)config.userOption(), (String)",")) {
            String[] permAuth = StringUtils.split((String)rule, (String)":", (int)2);
            try {
                ServiceRestrictions.Permission permission = ServiceRestrictions.Permission.valueOf(permAuth[0]);
                Set authorizables = this.userOptions.computeIfAbsent(permission, k -> new TreeSet());
                authorizables.add(permAuth.length > 1 ? permAuth[1] : "");
            }
            catch (IllegalArgumentException ex) {
                LOG.error(ex.toString());
            }
        }
    }

    @Override
    public boolean isUserOptionAllowed(@NotNull SlingHttpServletRequest request, @NotNull ServiceRestrictions.Permission permission) {
        String userId = request.getResourceResolver().getUserID();
        Authorizable authorizable = null;
        for (ServiceRestrictions.Permission option : this.userOptions.keySet()) {
            if (option.compareTo(permission) < 0) continue;
            for (String name : this.userOptions.get((Object)option)) {
                if (StringUtils.isBlank((CharSequence)name)) {
                    return true;
                }
                if (!StringUtils.isNotBlank((CharSequence)userId)) continue;
                if (userId.equals(name)) {
                    return true;
                }
                if (authorizable == null) {
                    authorizable = this.getAuthorizable(request);
                }
                try {
                    Iterator groups;
                    if (authorizable == null || (groups = authorizable.memberOf()) == null) continue;
                    while (groups.hasNext()) {
                        if (!((Group)groups.next()).getID().equals(name)) continue;
                        return true;
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return false;
    }

    @Override
    public ServiceRestrictions.Permission getDefaultPermisson() {
        return this.config.defaultPermission();
    }

    protected void addRestriction(@NotNull String rule) {
        String[] keyValue = StringUtils.split((String)rule, (String)"=", (int)2);
        if (keyValue.length == 2) {
            ServiceRestrictions.Key key = new ServiceRestrictions.Key(keyValue[0]);
            ServiceRestrictions.Restriction restriction = new ServiceRestrictions.Restriction(keyValue[1]);
            this.restrictions.put(key, restriction);
        }
    }

    @NotNull
    protected ServiceRestrictions.Restriction getRestriction(@NotNull ServiceRestrictions.Key key) {
        ServiceRestrictions.Restriction restriction = this.restrictions.get(key);
        if (restriction == null) {
            String id;
            while (restriction == null && !(key = new ServiceRestrictions.Key((id = key.toString()).substring(0, id.lastIndexOf(47) + 1))).isEmpty()) {
                restriction = this.restrictions.get(key);
            }
            this.restrictions.put(key, restriction != null ? restriction : (restriction = new ServiceRestrictions.Restriction()));
        }
        return restriction;
    }

    @Override
    public boolean isPermissible(@Nullable SlingHttpServletRequest request, @Nullable ServiceRestrictions.Key key, @NotNull ServiceRestrictions.Permission needed) {
        if (this.config.enabled()) {
            Object temporary;
            HttpSession session;
            ServiceRestrictions.Permission permission = this.getPermission(key);
            if (request != null && (session = request.getSession(false)) != null && (temporary = session.getAttribute(SA_PERMISSION)) instanceof ServiceRestrictions.Permission && this.isUserOptionAllowed(request, (ServiceRestrictions.Permission)((Object)temporary))) {
                permission = (ServiceRestrictions.Permission)((Object)temporary);
            }
            return permission.matches(needed);
        }
        return true;
    }

    @Override
    @NotNull
    public ServiceRestrictions.Permission getPermission(@Nullable ServiceRestrictions.Key key) {
        if (this.config.enabled()) {
            ServiceRestrictions.Restriction restriction = key != null ? this.getRestriction(key) : null;
            return restriction != null && restriction.permission != null ? restriction.permission : this.config.defaultPermission();
        }
        return ServiceRestrictions.Permission.write;
    }

    @Override
    @Nullable
    public String getRestrictions(@Nullable ServiceRestrictions.Key key) {
        if (this.config.enabled() && key != null) {
            ServiceRestrictions.Restriction restriction = this.getRestriction(key);
            return restriction.restrictions;
        }
        return null;
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull SlingHttpServletRequest request) {
        Session session;
        String userId = request.getResourceResolver().getUserID();
        if (StringUtils.isNotBlank((CharSequence)userId) && (session = (Session)request.getResourceResolver().adaptTo(Session.class)) != null) {
            try {
                UserManager userManager;
                UserManager userManager2 = userManager = session instanceof JackrabbitSession ? ((JackrabbitSession)session).getUserManager() : null;
                if (userManager != null) {
                    return userManager.getAuthorizable(userId);
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public boolean checkAuthorizables(@NotNull SlingHttpServletRequest request, @Nullable String restrictions) {
        if (StringUtils.isNotBlank((CharSequence)restrictions) && restrictions.startsWith("authorizable:")) {
            Authorizable authorizable = this.getAuthorizable(request);
            if (authorizable instanceof User) {
                try {
                    String name = authorizable.getID();
                    for (String id : StringUtils.split((String)restrictions.substring("authorizable:".length()), (String)",")) {
                        if (authorizable.getID().equals(id)) {
                            return true;
                        }
                        Iterator groups = authorizable.memberOf();
                        if (groups == null) continue;
                        while (groups.hasNext()) {
                            if (!((Group)groups.next()).getID().equals(id)) continue;
                            return true;
                        }
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return false;
        }
        return true;
    }

    @ObjectClassDefinition(name="Composum Service Restrictions Configuration")
    public static @interface Config {
        @AttributeDefinition(description="the general on/off switch for the restrictions (default: true)")
        public boolean enabled() default true;

        @AttributeDefinition(description="the default permission if no restriction specified for a feature (default: write)")
        public ServiceRestrictions.Permission defaultPermission() default ServiceRestrictions.Permission.write;

        @AttributeDefinition(description="the permission limit for the individual choice in the users session (default: 'write:admin')")
        public String userOption() default "write:admin";

        @AttributeDefinition(description="the set of service restrictions")
        public String[] restrictions();
    }
}

