/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsoleServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConsoleServlet.class);
    protected BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected abstract String getServletPath(BeanContext var1);

    protected abstract Pattern getPathPattern(BeanContext var1);

    protected abstract String getResourceType(BeanContext var1);

    protected String getConsolePath(BeanContext context) {
        return null;
    }

    public ServiceRestrictions.Key getServiceKey() {
        Restricted restricted = ((Object)((Object)this)).getClass().getAnnotation(Restricted.class);
        return restricted != null ? new ServiceRestrictions.Key(restricted.key()) : null;
    }

    protected String getRequestPath(SlingHttpServletRequest request) {
        RequestPathInfo reqPathInfo = request.getRequestPathInfo();
        String suffix = XSS.filter(reqPathInfo.getSuffix());
        if (StringUtils.isBlank((CharSequence)suffix)) {
            suffix = "/";
        }
        return suffix;
    }

    protected BeanContext createContext(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        return new BeanContext.Servlet(this.getServletContext(), this.bundleContext, request, response);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(true);
        BeanContext context = this.createContext(request, response);
        String pathInfo = request.getPathInfo();
        Matcher matcher = this.getPathPattern(context).matcher(pathInfo);
        if (matcher.matches()) {
            if (this.checkConsoleAccess(context)) {
                RequestDispatcherOptions options = new RequestDispatcherOptions();
                this.prepareForward(context, options);
                Resource resource = request.getResource();
                RequestDispatcher dispatcher = request.getRequestDispatcher(resource, options);
                LOG.debug("Forwarding to {} with {}", (Object)resource.getPath(), (Object)options);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(403);
            }
        } else if (pathInfo.equals(this.getServletPath(context))) {
            response.sendRedirect(LinkUtil.getUrl(request, pathInfo + ".html"));
        } else {
            response.sendError(400);
        }
    }

    protected void prepareForward(BeanContext context, RequestDispatcherOptions options) {
        String path = this.getRequestPath(context.getRequest());
        if (StringUtils.isNotBlank((CharSequence)path)) {
            options.setReplaceSuffix(path);
        }
        String resourceType = this.getResourceType(context);
        options.setForceResourceType(resourceType);
    }

    protected boolean checkConsoleAccess(BeanContext context) {
        String consolePath = this.getConsolePath(context);
        if (StringUtils.isNotBlank((CharSequence)consolePath)) {
            Resource resource = context.getResolver().getResource(consolePath);
            if (resource == null) {
                LOG.info("Access to {} denied for {}", (Object)consolePath, (Object)context.getResolver().getUserID());
            }
            if (resource == null) {
                return false;
            }
        }
        return context.getService(ServiceRestrictions.class).isPermissible(context.getRequest(), this.getServiceKey(), ServiceRestrictions.Permission.read);
    }
}

