/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.service.impl.ServiceRestrictionsImpl;
import com.composum.sling.core.servlet.Status;
import com.composum.sling.core.util.RequestUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpSession;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Service Restrictions Servlet", "sling.servlet.paths=/bin/cpm/core/restrictions", "sling.servlet.extensions=json", "sling.servlet.methods=GET"})
public class RestrictionsServlet
extends SlingAllMethodsServlet
implements RestrictedService {
    private static final Logger LOG = LoggerFactory.getLogger(RestrictionsServlet.class);
    public static final String SERVICE_KEY = "core/commons/restrictions";
    public static final String SERVLET_PATH = "/bin/cpm/core/restrictions";
    @Reference
    private ServiceRestrictions restrictions;

    @Override
    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key(SERVICE_KEY);
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Status status = new Status(request, response);
        ServiceRestrictions.Key key = new ServiceRestrictions.Key(RequestUtil.getParameter(request, "key", request.getRequestPathInfo().getSuffix()));
        ServiceRestrictions.Permission check = RequestUtil.getParameter(request, "check", RequestUtil.getSelector(request, ServiceRestrictions.Permission.read));
        Map<String, Object> data = status.data("result");
        data.put("service", key.toString());
        data.put("check", (Object)check);
        data.put("permissible", this.restrictions.isPermissible(request, key, check));
        data.put("permission", (Object)this.restrictions.getPermission(key));
        data.put("restrictions", this.restrictions.getRestrictions(key));
        status.sendJson();
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Status status = new Status(request, response);
        HttpSession session = request.getSession(true);
        ServiceRestrictions.Permission user = null;
        ServiceRestrictions.Permission system = this.restrictions.getDefaultPermisson();
        user = RequestUtil.getParameter(request, "permission", RequestUtil.getSelector(request, ServiceRestrictions.Permission.none));
        if (user == ServiceRestrictions.Permission.none) {
            try {
                user = (ServiceRestrictions.Permission)((Object)session.getAttribute(ServiceRestrictionsImpl.SA_PERMISSION));
            }
            catch (ClassCastException ignore) {
                user = null;
            }
            if (user == null) {
                user = system == ServiceRestrictions.Permission.write ? ServiceRestrictions.Permission.read : ServiceRestrictions.Permission.write;
            } else {
                ServiceRestrictions.Permission permission = user = user == ServiceRestrictions.Permission.write ? null : ServiceRestrictions.Permission.write;
            }
            if (!(user == null || user != system && this.restrictions.isUserOptionAllowed(request, user))) {
                user = null;
            }
        }
        if (user != null) {
            session.setAttribute(ServiceRestrictionsImpl.SA_PERMISSION, (Object)user);
        } else {
            session.removeAttribute(ServiceRestrictionsImpl.SA_PERMISSION);
        }
        Map<String, Object> data = status.data("result");
        data.put("user", (Object)user);
        data.put("system", (Object)system);
        status.sendJson();
    }
}

