/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.core.util.XSS;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="core/commons/repository")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes System Servlet", "sling.servlet.paths=/bin/cpm/core/system", "sling.servlet.methods=GET", "sling.servlet.methods=PUT", "sling.auth.requirements=/bin/cpm/core/system"})
public class SystemServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SystemServlet.class);
    public static final String SERVICE_KEY = "core/commons/repository";
    public static final String SERVLET_PATH = "/bin/cpm/core/system";
    public static final String NODE_TYPES_PATH = "/jcr:system/jcr:nodeTypes";
    public static final String PROP_IS_MIXIN = "jcr:isMixin";
    public static final String ALL_QUERY_KEY = "-- all --";
    @Reference
    private ServiceRestrictions restrictions;
    @Reference
    private CoreConfiguration coreConfig;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet(Extension.json);
    public static final String[] PROPERTY_TYPES = new String[]{"String", "Boolean", "Long", "Date", "Binary", "Decimal", "Double", "Name", "Path", "URI", "Reference", "WeakReference"};
    protected ResourceFilter PRIMARY_TYPE_FILTER = new PrimaryTypesFilter();
    protected LRUMap PRIMARY_TYPE_CACHE = new LRUMap();
    protected ResourceFilter MIXIN_TYPE_FILTER = new MixinTypesFilter();
    protected LRUMap MIXIN_TYPE_CACHE = new LRUMap();

    @Override
    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key(SERVICE_KEY);
    }

    @NotNull
    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.propertyTypes, new GetPropertyTypes());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.primaryTypes, new GetPrimaryTypes());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.mixinTypes, new GetMixinTypes());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.typeahead, new JsonTypeahead());
    }

    public class JsonTypeahead
    implements ServletOperation {
        @Override
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws ServletException, IOException {
            final String query = RequestUtil.getParameter(request, "query", "").toLowerCase();
            StringFilter filter = StringUtils.isBlank((CharSequence)query) ? StringFilter.ALL : new StringFilter(){

                @Override
                public boolean accept(String value) {
                    return value.toLowerCase().contains(query);
                }

                @Override
                public boolean isRestriction() {
                    return false;
                }

                @Override
                public void toString(StringBuilder builder) {
                }
            };
            JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
            response.setStatus(200);
            jsonWriter.beginArray();
            if (resource != null && ResourceUtil.isFile((Resource)resource)) {
                try {
                    Binary binary = ResourceUtil.getBinaryData((Resource)resource);
                    InputStream stream = binary.getStream();
                    InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    String ext = StringUtils.substringAfterLast((String)resource.getName(), (String)".");
                    switch (ext.toLowerCase()) {
                        case "json": {
                            JsonReader jsonReader = new JsonReader(reader);
                            jsonReader.beginArray();
                            while (jsonReader.peek() != JsonToken.END_ARRAY) {
                                String value = jsonReader.nextString();
                                if (!StringUtils.isNotBlank((CharSequence)value) || !filter.accept(value)) continue;
                                jsonWriter.value(value);
                            }
                            jsonReader.endArray();
                            break;
                        }
                        default: {
                            LineIterator iterator = IOUtils.lineIterator((Reader)reader);
                            while (iterator.hasNext()) {
                                String value = iterator.nextLine();
                                if (!StringUtils.isNotBlank((CharSequence)value) || !filter.accept(value = value.trim())) continue;
                                jsonWriter.value(value);
                            }
                            break;
                        }
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
            jsonWriter.endArray();
        }
    }

    public class GetNodeTypes
    implements ServletOperation {
        private final ResourceFilter typeFilter;
        private final LRUMap queryCache;

        public GetNodeTypes(ResourceFilter nameFilter, LRUMap cache) {
            this.typeFilter = nameFilter;
            this.queryCache = cache;
        }

        @Override
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws ServletException, IOException {
            String query = XSS.filter(request.getParameter("query"));
            ResourceResolver resolver = request.getResourceResolver();
            List<String> nodeTypes = (List<String>)this.queryCache.get((Object)(query == null ? SystemServlet.ALL_QUERY_KEY : query));
            if (nodeTypes == null) {
                nodeTypes = this.getNodeTypes(resolver, query != null ? query.toLowerCase() : null);
                this.queryCache.put((Object)(query == null ? SystemServlet.ALL_QUERY_KEY : query), nodeTypes);
            }
            JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
            response.setStatus(200);
            JsonUtil.writeJsonArray(jsonWriter, nodeTypes.iterator());
        }

        public List<String> getNodeTypes(ResourceResolver resolver, String query) {
            ArrayList<String> nodeTypes = new ArrayList<String>();
            Resource typesResource = resolver.getResource(SystemServlet.NODE_TYPES_PATH);
            if (typesResource != null) {
                for (Resource type : typesResource.getChildren()) {
                    String name = type.getName();
                    if (!this.typeFilter.accept(type) || query != null && !name.toLowerCase().contains(query)) continue;
                    nodeTypes.add(name);
                }
            }
            Collections.sort(nodeTypes);
            return nodeTypes;
        }
    }

    public class GetMixinTypes
    extends GetNodeTypes {
        public GetMixinTypes() {
            super(SystemServlet.this.MIXIN_TYPE_FILTER, SystemServlet.this.MIXIN_TYPE_CACHE);
        }
    }

    public class GetPrimaryTypes
    extends GetNodeTypes {
        public GetPrimaryTypes() {
            super(SystemServlet.this.PRIMARY_TYPE_FILTER, SystemServlet.this.PRIMARY_TYPE_CACHE);
        }
    }

    public static class PrimaryTypesFilter
    extends MixinTypesFilter {
        @Override
        public boolean accept(Resource resource) {
            return !super.accept(resource);
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("PrimaryTypes");
        }
    }

    public static class MixinTypesFilter
    extends ResourceFilter.AbstractResourceFilter {
        @Override
        public boolean accept(Resource resource) {
            ResourceHandle handle = ResourceHandle.use(resource);
            return handle.getProperty(SystemServlet.PROP_IS_MIXIN, false);
        }

        @Override
        public boolean isRestriction() {
            return false;
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            builder.append("MixinTypes");
        }
    }

    public class GetPropertyTypes
    implements ServletOperation {
        @Override
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws ServletException, IOException {
            JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
            response.setStatus(200);
            JsonUtil.writeJsonArray(jsonWriter, PROPERTY_TYPES);
        }
    }

    public static enum Operation {
        propertyTypes,
        primaryTypes,
        mixinTypes,
        typeahead;

    }

    public static enum Extension {
        json;

    }
}

