/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import java.io.Serializable;
import java.util.Calendar;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.servlets.HttpConstants;
import org.jetbrains.annotations.NotNull;

public class HttpUtil
extends HttpConstants {
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String VALUE_NO_CACHE = "no-cache";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_VARY = "Vary";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";

    public static boolean notModifiedSince(long ifModifiedSince, Calendar lastModified) {
        return lastModified != null && HttpUtil.notModifiedSince(ifModifiedSince, lastModified.getTimeInMillis());
    }

    public static boolean notModifiedSince(long ifModifiedSince, Long lastModified) {
        if (ifModifiedSince != -1L && lastModified != null) {
            long lastModifiedTime = lastModified / 1000L * 1000L;
            return lastModifiedTime <= (ifModifiedSince = ifModifiedSince / 1000L * 1000L);
        }
        return false;
    }

    @Deprecated
    public static boolean isModifiedSince(long ifModifiedSince, Calendar lastModified) {
        return !HttpUtil.notModifiedSince(ifModifiedSince, lastModified);
    }

    @Deprecated
    public static boolean isModifiedSince(long ifModifiedSince, Long lastModified) {
        if (ifModifiedSince != -1L && lastModified != null) {
            long lastModifiedTime = lastModified / 1000L * 1000L;
            return lastModifiedTime > (ifModifiedSince = ifModifiedSince / 1000L * 1000L);
        }
        return true;
    }

    @NotNull
    public static <Type extends CachableInstance> Type getInstance(@NotNull SlingHttpServletRequest request, @NotNull String attributeKey, @NotNull InstanceFactory<Type> factory) {
        String cacheControlHeader;
        HttpSession session = request.getSession(true);
        Class<Type> type = factory.getType();
        CachableInstance instance = null;
        try {
            Object object = session.getAttribute(attributeKey);
            if (type.isInstance(object)) {
                instance = (CachableInstance)type.cast(object);
            }
        }
        catch (ClassCastException object) {
            // empty catch block
        }
        if (instance != null && (System.currentTimeMillis() - instance.getCreated() > 1800000L || StringUtils.isNotBlank((CharSequence)(cacheControlHeader = request.getHeader(HEADER_CACHE_CONTROL))) && cacheControlHeader.contains(VALUE_NO_CACHE))) {
            instance = null;
        }
        if (instance == null) {
            instance = factory.newInstance(request);
            session.setAttribute(attributeKey, (Object)instance);
        }
        return (Type)instance;
    }

    public static interface InstanceFactory<Type extends CachableInstance> {
        public Class<Type> getType();

        public Type newInstance(SlingHttpServletRequest var1);
    }

    public static interface CachableInstance
    extends Serializable {
        public long getCreated();
    }
}

