/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.util.LinkMapper;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.SlingUrl;
import com.composum.sling.core.util.UrlCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.tika.mime.MimeType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LinkUtil.class);
    public static final String EXT_HTML = ".html";
    public static final String PROP_TARGET = "sling:target";
    public static final String PROP_REDIRECT = "sling:redirect";
    public static final String FORWARDED_PROTO = "X-Forwarded-Proto";
    public static final String FORWARDED_PROTO_HTTPS = "https";
    public static final String FORWARDED_SSL_HEADER = "X-Forwarded-SSL";
    public static final String FORWARDED_SSL_ON = "on";
    public static final String URL_PATTERN_STRING = "^(?:(https?):)?//([^/]+)(:\\d+)?(/.*)?$";
    public static final Pattern URL_PATTERN = Pattern.compile("^(?:(https?):)?//([^/]+)(:\\d+)?(/.*)?$", 2);
    public static final String SPECIAL_URL_STRING = "^(?:(mailto|tel):)(.+)$";
    public static final Pattern SPECIAL_URL_PATTERN = Pattern.compile("^(?:(mailto|tel):)(.+)$", 2);
    protected static final Pattern UNESCAPED_PATHSEGMENT = Pattern.compile("(?<=^|/)((?<prefix>[^/:_]+):|_(?<uprefix>[^/]+)_)");
    protected static final Pattern ESCAPED_PATHSEGMENT = Pattern.compile("(?<=^|/)(_(?<prefix>[^/:_]+)_|__(?<uprefix>[^/]+)_)");

    public static String getUrl(SlingHttpServletRequest request, String url) {
        return LinkUtil.getUrl(request, url, null, null);
    }

    public static String getMappedUrl(SlingHttpServletRequest request, String url) {
        return LinkUtil.getUrl(request, url, null, null, LinkMapper.RESOLVER);
    }

    public static String getUnmappedUrl(SlingHttpServletRequest request, String url) {
        return LinkUtil.getUrl(request, url, null, null, LinkMapper.CONTEXT);
    }

    public static String getUrl(SlingHttpServletRequest request, String url, String extension) {
        return LinkUtil.getUrl(request, url, null, extension);
    }

    public static String getUrl(SlingHttpServletRequest request, String url, String selectors, String extension) {
        LinkMapper mapper = (LinkMapper)request.getAttribute(LinkMapper.LINK_MAPPER_REQUEST_ATTRIBUTE);
        return LinkUtil.getUrl(request, url, selectors, extension, mapper != null ? mapper : LinkMapper.RESOLVER);
    }

    public static String getUrl(SlingHttpServletRequest request, String url, String selectors, String extension, LinkMapper mapper) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        String result = url;
        if (!LinkUtil.isExternalUrl(result)) {
            ResourceResolver resolver = request.getResourceResolver();
            ResourceHandle resource = ResourceHandle.use(resolver.getResource(result));
            if (resource.isValid()) {
                try {
                    String redirect = LinkUtil.getFinalTarget((Resource)resource);
                    if (StringUtils.isNotBlank((CharSequence)redirect)) {
                        return LinkUtil.getUrl(request, redirect, selectors, extension, mapper);
                    }
                }
                catch (RedirectLoopException rlex) {
                    LOG.error(rlex.toString());
                }
                extension = LinkUtil.getExtension(resource, extension);
            }
            SlingUrl slingUrl = new SlingUrl(request, mapper).fromUrl(url);
            if (StringUtils.isNotBlank((CharSequence)selectors)) {
                slingUrl.selectors(selectors);
            }
            if (StringUtils.isNotBlank((CharSequence)extension)) {
                slingUrl.extension(extension);
            }
            result = slingUrl.getUrl();
        }
        LOG.debug("Mapped '{}' to '{}'", (Object)url, (Object)result);
        return result;
    }

    public static String getAbsoluteUrl(SlingHttpServletRequest request, String url) {
        if (!LinkUtil.isExternalUrl(url) && url.startsWith("/")) {
            String scheme = request.getScheme().toLowerCase();
            url = scheme + "://" + LinkUtil.getAuthority(request) + url;
        }
        return url;
    }

    public static String getAuthority(SlingHttpServletRequest request) {
        String host = request.getServerName();
        int port = request.getServerPort();
        return port > 0 && port != LinkUtil.getDefaultPort(request) ? host + ":" + port : host;
    }

    public static int getDefaultPort(SlingHttpServletRequest request) {
        return request.isSecure() || LinkUtil.isForwaredSSL((HttpServletRequest)request) ? 443 : 80;
    }

    public static boolean isForwaredSSL(HttpServletRequest request) {
        return FORWARDED_SSL_ON.equalsIgnoreCase(request.getHeader(FORWARDED_SSL_HEADER)) || FORWARDED_PROTO.equalsIgnoreCase(request.getHeader(FORWARDED_PROTO_HTTPS));
    }

    protected static String adjustMappedUrl(SlingHttpServletRequest request, String url) {
        Pattern defaultPortPattern = Pattern.compile(URL_PATTERN_STRING.replaceFirst("\\(:\\\\d\\+\\)\\?", ":" + LinkUtil.getDefaultPort(request)));
        Matcher matcher = defaultPortPattern.matcher(url);
        if (matcher.matches()) {
            url = null == matcher.group(1) ? "//" + matcher.group(2) : matcher.group(1) + "://" + matcher.group(2);
            String uri = matcher.group(3);
            url = StringUtils.isNotBlank((CharSequence)uri) ? url + uri : url + "/";
        }
        return url;
    }

    public static boolean isExternalUrl(String url) {
        return URL_PATTERN.matcher(url).matches() || SPECIAL_URL_PATTERN.matcher(url).matches();
    }

    public static Resource resolveUrl(SlingHttpServletRequest request, String url) {
        return request.getResourceResolver().getResource(url);
    }

    public static String getFinalTarget(Resource resource) throws RedirectLoopException {
        ResourceHandle handle = ResourceHandle.use(resource);
        return LinkUtil.getFinalTarget(handle, new ArrayList<String>());
    }

    protected static String getFinalTarget(ResourceHandle resource, List<String> trace) throws RedirectLoopException {
        String finalTarget = null;
        if (resource.isValid()) {
            ResourceHandle contentResource;
            String path = resource.getPath();
            if (trace.contains(path)) {
                throw new RedirectLoopException(trace, path);
            }
            String redirect = resource.getProperty(PROP_TARGET);
            if (StringUtils.isBlank((CharSequence)redirect)) {
                redirect = resource.getProperty(PROP_REDIRECT);
            }
            if (StringUtils.isBlank((CharSequence)redirect) && resource != (contentResource = resource.getContentResource()) && StringUtils.isBlank((CharSequence)(redirect = contentResource.getProperty(PROP_TARGET)))) {
                redirect = contentResource.getProperty(PROP_REDIRECT);
            }
            if (StringUtils.isNotBlank((CharSequence)redirect)) {
                String target;
                ResourceResolver resolver;
                Resource targetResource;
                trace.add(path);
                finalTarget = redirect;
                if (!URL_PATTERN.matcher(finalTarget).matches() && (targetResource = (resolver = resource.getResourceResolver()).getResource(finalTarget)) != null && StringUtils.isNotBlank((CharSequence)(target = LinkUtil.getFinalTarget(ResourceHandle.use(targetResource), trace)))) {
                    finalTarget = target;
                }
            }
        }
        return finalTarget;
    }

    public static String getExtension(ResourceHandle resource, String extension) {
        return LinkUtil.getExtension(resource, extension, false);
    }

    @NotNull
    public static String getExtension(ResourceHandle resource, String extension, boolean detectMimeTypeExtension) {
        String name;
        if (StringUtils.isBlank((CharSequence)extension) && detectMimeTypeExtension && resource.isFile()) {
            MimeType mimeType = MimeTypeUtil.getMimeType((Resource)resource);
            if (mimeType != null) {
                extension = mimeType.getExtension();
            } else {
                String name2 = resource.getName();
                int lastDot = name2.lastIndexOf(46);
                if (lastDot > 0) {
                    extension = name2.substring(lastDot + 1);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)extension) && (name = resource.getName()).toLowerCase().endsWith(extension.toLowerCase())) {
            extension = "";
        }
        if (extension == null && !resource.isFile()) {
            String resourceType = resource.getResourceType();
            String primaryType = resource.getPrimaryType();
            if (primaryType != null && !primaryType.equals(resourceType)) {
                extension = EXT_HTML;
            } else {
                ResourceHandle content = resource.getContentResource();
                if (content.isValid() && !ResourceUtil.isNonExistingResource((Resource)content)) {
                    resourceType = content.getResourceType();
                    primaryType = content.getPrimaryType();
                    if (primaryType != null && !primaryType.equals(resourceType)) {
                        extension = EXT_HTML;
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)extension) && !extension.startsWith(".")) {
            extension = "." + extension;
        }
        return extension != null ? extension : "";
    }

    public static String encodeUrl(SlingHttpServletRequest request, String url) {
        return new SlingUrl(request).fromUrl(url).getUrl();
    }

    public static String encodePath(String path) {
        if (path != null) {
            path = LinkUtil.namespacePrefixEscape(path);
            path = UrlCodec.PATH.encode(path);
        }
        return path;
    }

    public static String decodePath(String path) {
        if (path != null) {
            path = (path = LinkUtil.decode(path)) != null ? LinkUtil.namespacePrefixUnescape(path) : path;
        }
        return path;
    }

    public static String namespacePrefixEscape(String path) {
        String result = path;
        if (path != null && (path.contains(":") || path.contains("_"))) {
            StringBuffer buf = new StringBuffer();
            Matcher matcher = UNESCAPED_PATHSEGMENT.matcher(path);
            while (matcher.find()) {
                matcher.appendReplacement(buf, "");
                String prefix = matcher.group("prefix");
                if (prefix != null) {
                    buf.append("_").append(prefix).append("_");
                    continue;
                }
                buf.append("__").append(matcher.group("uprefix")).append("_");
            }
            matcher.appendTail(buf);
            result = buf.toString();
        }
        return result;
    }

    public static String namespacePrefixUnescape(String path) {
        String result = path;
        if (path != null && path.contains("_")) {
            StringBuffer buf = new StringBuffer();
            Matcher matcher = ESCAPED_PATHSEGMENT.matcher(path);
            while (matcher.find()) {
                matcher.appendReplacement(buf, "");
                String prefix = matcher.group("prefix");
                if (prefix != null) {
                    buf.append(prefix).append(":");
                    continue;
                }
                buf.append("_").append(matcher.group("uprefix")).append("_");
            }
            matcher.appendTail(buf);
            result = buf.toString();
        }
        return result;
    }

    public static String encode(String value) {
        return UrlCodec.PATH.encode(value);
    }

    public static String decode(String value) {
        return UrlCodec.URLSAFE.decode(value);
    }

    public static String decodeInQuery(String value) {
        return UrlCodec.QUERYPART.decode(value);
    }

    public static class RedirectLoopException
    extends Exception {
        public final List<String> trace;
        public final String target;

        public RedirectLoopException(List<String> trace, String target) {
            super("redirect loop detected in '" + trace.get(trace.size() - 1) + "' which redirects to '" + target + "'");
            this.trace = trace;
            this.target = target;
        }
    }
}

