/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SetPropertyStrategy {
    public javax.jcr.Property setProperty(Node var1, String var2, Value var3, int var4) throws RepositoryException;

    public javax.jcr.Property setProperty(Node var1, String var2, Value[] var3, int var4) throws RepositoryException;

    public static class MixinTypes
    implements SetPropertyStrategy {
        private static final Logger LOG = LoggerFactory.getLogger(MixinTypes.class);

        @Override
        public javax.jcr.Property setProperty(Node node, String name, Value value, int type) throws RepositoryException {
            throw new RepositoryException("invalid single value for multi value mixin types");
        }

        @Override
        public javax.jcr.Property setProperty(Node node, String name, Value[] values, int type) throws RepositoryException {
            if (type != 7) {
                LOG.warn("mixin types must be of property type NAME, was '" + PropertyType.nameFromValue((int)type) + "'");
            }
            ArrayList<String> valueList = new ArrayList<String>();
            if (values != null) {
                for (Value val : values) {
                    String string = val.getString();
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    valueList.add(string);
                }
            }
            NodeType[] mixins = node.getMixinNodeTypes();
            for (NodeType nodeType : mixins) {
                String key = nodeType.getName();
                if (valueList.contains(key)) {
                    valueList.remove(key);
                    continue;
                }
                node.removeMixin(key);
            }
            for (String key : valueList) {
                node.addMixin(key);
            }
            return null;
        }
    }

    public static class PrimaryType
    implements SetPropertyStrategy {
        private static final Logger LOG = LoggerFactory.getLogger(PrimaryType.class);

        @Override
        public javax.jcr.Property setProperty(Node node, String name, Value value, int type) throws RepositoryException {
            if (type != 7) {
                LOG.warn("primary type must be of property type NAME, was '" + PropertyType.nameFromValue((int)type) + "'");
            }
            node.setPrimaryType(value.getString());
            return null;
        }

        @Override
        public javax.jcr.Property setProperty(Node node, String name, Value[] values, int type) throws RepositoryException {
            throw new RepositoryException("invalid multi value for primary type");
        }
    }

    public static class Property
    implements SetPropertyStrategy {
        @Override
        public javax.jcr.Property setProperty(Node node, String name, Value value, int type) throws RepositoryException {
            return node.setProperty(name, value, type);
        }

        @Override
        public javax.jcr.Property setProperty(Node node, String name, Value[] values, int type) throws RepositoryException {
            return node.setProperty(name, values, type);
        }
    }
}

