/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TagFilteringReader
extends FilterReader {
    public static final String[] DEFAULT_TO_RENAME = new String[]{"html:div class=\"proxy-html-content\""};
    public static final String[] DEFAULT_TO_STRIP = new String[]{"body"};
    public static final String[] DEFAULT_TO_DROP = new String[]{"head", "style", "script", "link"};
    private Debug debug = Debug.none;
    protected final Map<String, String> toRename;
    protected final List<String> toStrip;
    protected final List<String> toDrop;
    protected Stack<TagFilter> openTags = new Stack();
    protected char[] buffer = null;
    protected int bufferPos;

    public TagFilteringReader(@NotNull Reader in, @NotNull String[] toRename, @NotNull String[] toStrip, @NotNull String[] toDrop) {
        super(in);
        this.toRename = new HashMap<String, String>();
        for (String rule : toRename) {
            if (!StringUtils.isNotBlank((CharSequence)rule)) continue;
            String[] split = StringUtils.split((String)rule, (String)":", (int)2);
            this.toRename.put(split[0], split[1]);
        }
        this.toStrip = Arrays.asList(toStrip);
        this.toDrop = Arrays.asList(toDrop);
    }

    public TagFilteringReader(@NotNull InputStream in, @NotNull String[] toRename, @NotNull String[] toStrip, @NotNull String[] toDrop) {
        this(new InputStreamReader(in, StandardCharsets.UTF_8), toRename, toStrip, toDrop);
    }

    public TagFilteringReader(@NotNull InputStream in) {
        this(in, DEFAULT_TO_RENAME, DEFAULT_TO_STRIP, DEFAULT_TO_DROP);
    }

    public TagFilteringReader(@NotNull Reader in) {
        this(in, DEFAULT_TO_RENAME, DEFAULT_TO_STRIP, DEFAULT_TO_DROP);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count;
        for (count = 0; count < len; ++count) {
            int token = this.read();
            if (token < 0) {
                return count > 0 ? count : -1;
            }
            cbuf[off + count] = (char)token;
        }
        return count;
    }

    @Override
    public int read() throws IOException {
        int token = this.openTags.isEmpty() ? this.scan() : this.openTags.peek().body();
        return token;
    }

    protected int scan() throws IOException {
        int token;
        if (this.buffer != null) {
            token = this.buffer[this.bufferPos];
            ++this.bufferPos;
            if (this.bufferPos >= this.buffer.length) {
                this.buffer = null;
            }
        } else {
            token = this.next();
            if (token >= 0 && token == 60) {
                token = this.next();
                if (token >= 0) {
                    StringBuilder tagName = new StringBuilder();
                    if (token == 47) {
                        while ((token = this.next()) >= 0) {
                            if (token == 62) {
                                TagFilter filter;
                                if (!this.openTags.isEmpty() && (filter = this.openTags.peek()).tagName().equals(tagName.toString().toLowerCase())) {
                                    this.openTags.pop();
                                    return filter.end();
                                }
                                if (this.openTags.size() > 1 && (filter = (TagFilter)this.openTags.get(this.openTags.size() - 2)).tagName().equals(tagName.toString().toLowerCase())) {
                                    this.openTags.pop();
                                    this.openTags.pop();
                                    return filter.end();
                                }
                                tagName.insert(0, '/');
                                tagName.append((char)token);
                                return this.buffer(tagName);
                            }
                            tagName.append((char)token);
                        }
                        tagName.insert(0, '/');
                    } else {
                        do {
                            if (token == 32 || token == 62 || token == 47) {
                                TagFilter filter = this.getFilter(tagName.toString().toLowerCase());
                                if (filter != null) {
                                    this.openTags.push(filter);
                                    return filter.start(token);
                                }
                                tagName.append((char)token);
                                return this.buffer(tagName);
                            }
                            tagName.append((char)token);
                        } while ((token = this.next()) >= 0);
                    }
                    return this.buffer(tagName);
                }
                token = 60;
            }
        }
        return token;
    }

    protected int next() throws IOException {
        int token = this.in.read();
        if (this.debug == Debug.read) {
            System.out.print((char)token);
        }
        return token;
    }

    protected int trim() throws IOException {
        int token;
        while (Character.isWhitespace(token = this.read())) {
        }
        return token;
    }

    protected int buffer(StringBuilder tagName) {
        this.buffer = tagName.toString().toCharArray();
        this.bufferPos = 0;
        return 60;
    }

    protected TagFilter getFilter(String tagName) {
        TagFilter current;
        TagFilter tagFilter = current = this.openTags.isEmpty() ? null : this.openTags.peek();
        if (current instanceof DropTagFilter) {
            return new DropTagFilter(tagName);
        }
        if (this.toRename.containsKey(tagName)) {
            return new RenameTagFilter(tagName, this.toRename.get(tagName));
        }
        if (this.toStrip.contains(tagName)) {
            return new StripTagFilter(tagName);
        }
        if (this.toDrop.contains(tagName)) {
            return new DropTagFilter(tagName);
        }
        return null;
    }

    protected class DropTagFilter
    extends TagFilterBase {
        protected DropTagFilter(String tagName) {
            super(tagName);
        }

        @Override
        public int body() throws IOException {
            int token;
            while ((token = TagFilteringReader.this.scan()) >= 0 && !TagFilteringReader.this.openTags.isEmpty() && TagFilteringReader.this.openTags.peek() == this) {
                if (TagFilteringReader.this.debug != Debug.drop) continue;
                System.err.println((char)token);
            }
            return token;
        }

        @Override
        public void debug(Character hint) {
            if (TagFilteringReader.this.debug == Debug.drop) {
                System.out.println("[" + (hint != null ? hint : "") + this.tagName + "]");
            }
        }
    }

    protected class StripTagFilter
    extends TagFilterBase {
        protected StripTagFilter(String tagName) {
            super(tagName);
        }

        @Override
        public int body() throws IOException {
            int token = TagFilteringReader.this.scan();
            if (TagFilteringReader.this.debug == Debug.strip) {
                System.out.println((char)token);
            }
            return token;
        }

        @Override
        public void debug(Character hint) {
            if (TagFilteringReader.this.debug == Debug.strip) {
                System.out.println("<" + (hint != null ? hint : "") + this.tagName + ">");
            }
        }
    }

    protected class RenameTagFilter
    extends StripTagFilter {
        protected final String newTagName;
        protected final String attributes;

        protected RenameTagFilter(String tagName, String newTagName) {
            super(tagName);
            this.newTagName = StringUtils.substringBefore((String)newTagName, (String)" ");
            this.attributes = StringUtils.substringAfter((String)newTagName, (String)" ");
        }

        @Override
        public int start(int token) {
            StringBuilder tagName = new StringBuilder(this.newTagName);
            if (StringUtils.isNotBlank((CharSequence)this.attributes)) {
                tagName.append(" ").append(this.attributes);
            }
            tagName.append((char)token);
            return TagFilteringReader.this.buffer(tagName);
        }

        @Override
        public int end() {
            StringBuilder tagName = new StringBuilder("/");
            tagName.append(this.newTagName).append('>');
            this.debug(Character.valueOf('/'));
            return TagFilteringReader.this.buffer(tagName);
        }

        @Override
        public void debug(Character hint) {
            if (TagFilteringReader.this.debug == Debug.strip) {
                System.out.println("<" + (hint != null ? hint : "") + this.tagName + ":" + this.newTagName + ">");
            }
        }
    }

    protected abstract class TagFilterBase
    implements TagFilter {
        protected final String tagName;

        protected TagFilterBase(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public String tagName() {
            return this.tagName;
        }

        @Override
        public int start(int token) throws IOException {
            Integer last = null;
            while (token != 62) {
                last = token;
                token = TagFilteringReader.this.scan();
            }
            if (last != null && last == 47) {
                TagFilteringReader.this.openTags.pop();
                this.debug(Character.valueOf('#'));
            } else {
                this.debug(null);
            }
            return TagFilteringReader.this.read();
        }

        @Override
        public int end() throws IOException {
            this.debug(Character.valueOf('/'));
            return TagFilteringReader.this.read();
        }
    }

    static interface TagFilter {
        public String tagName();

        public int start(int var1) throws IOException;

        public int body() throws IOException;

        public int end() throws IOException;

        public void debug(Character var1);
    }

    private static enum Debug {
        none,
        read,
        strip,
        drop;

    }
}

