/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.SlingBean;
import com.composum.sling.core.bean.BeanFactory;
import com.composum.sling.core.bean.SlingBeanFactory;
import com.composum.sling.core.util.SlingResourceUtil;
import com.composum.sling.cpnl.CpnlBodyTagSupport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTag
extends CpnlBodyTagSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentTag.class);
    protected String variable;
    protected String type;
    protected Integer varScope;
    protected Boolean replace;
    protected Boolean close;
    protected String attrPath;
    protected Resource attrResource;
    protected transient SlingBean component;
    protected transient boolean componentWasClosed;
    private transient Class<? extends SlingBean> componentType;
    private static final Map<Class<? extends SlingBean>, Field[]> fieldCache = new ConcurrentHashMap<Class<? extends SlingBean>, Field[]>();
    protected ArrayList<Map<String, Object>> replacedAttributes;
    public static final Map<String, Integer> SCOPES = new HashMap<String, Integer>();

    @Override
    protected void clear() {
        this.closeComponent();
        this.attrResource = null;
        this.attrPath = null;
        this.variable = null;
        this.type = null;
        this.varScope = null;
        this.replace = null;
        this.component = null;
        this.componentWasClosed = false;
        this.replacedAttributes = null;
        this.componentType = null;
        this.close = null;
        super.clear();
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        if (this.getVar() != null) {
            try {
                if (this.available() == null || this.getReplace().booleanValue()) {
                    this.component = this.createComponent();
                    this.componentWasClosed = false;
                    this.setAttribute(this.getVar(), this.component, this.getVarScope());
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error("Class not found: " + this.type, (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                LOG.error("Could not access: " + this.type, (Throwable)ex);
            }
            catch (InstantiationException ex) {
                LOG.error("Could not instantiate: " + this.type, (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Could not adapt to: " + this.type, (Throwable)ex);
            }
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        this.restoreAttributes();
        this.closeComponent();
        this.clear();
        super.doEndTag();
        return 6;
    }

    protected void closeComponent() {
        if (!this.componentWasClosed && !Boolean.FALSE.equals(this.getClose()) && this.component instanceof AutoCloseable) {
            try {
                this.componentWasClosed = true;
                ((AutoCloseable)((Object)this.component)).close();
            }
            catch (Exception e) {
                LOG.error("Problem closing component of type {}", (Object)this.getType(), (Object)e);
            }
        }
    }

    public void setId(String id) {
        this.setVar(id);
    }

    public void setVar(String id) {
        this.variable = id;
    }

    public String getVar() {
        return this.variable;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setScope(String key) {
        this.varScope = null;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.varScope = SCOPES.get(key.toLowerCase());
            if (this.varScope == null) {
                LOG.error("Invalid scope {} when rendering {}", (Object)key, (Object)SlingResourceUtil.getPath(this.resource));
            }
        }
    }

    public void setVarScope(Integer value) {
        this.varScope = value;
    }

    public Integer getVarScope() {
        return this.varScope != null ? this.varScope : 1;
    }

    public void setReplace(Boolean flag) {
        this.replace = flag;
    }

    public Boolean getReplace() {
        return this.replace != null ? this.replace : this.getVarScope() == 1;
    }

    public void setPath(String path) {
        this.attrPath = path;
    }

    public void setResource(Resource resource) {
        this.attrResource = resource;
    }

    public void setClose(Boolean close) {
        this.close = close;
    }

    public Boolean getClose() {
        return this.close;
    }

    protected Class<? extends SlingBean> getComponentType() throws ClassNotFoundException {
        if (this.componentType == null) {
            Object value;
            String type = this.getType();
            if (StringUtils.isNotBlank((CharSequence)type)) {
                this.componentType = this.context.getType(type);
            } else if (this.getVar() != null && (value = this.pageContext.getAttribute(this.getVar(), this.getVarScope().intValue())) instanceof SlingBean) {
                this.componentType = value.getClass();
            }
        }
        return this.componentType;
    }

    protected Object available() throws ClassNotFoundException {
        Class<? extends SlingBean> type;
        Object value;
        Object result = null;
        if (this.getVar() != null && (value = this.pageContext.getAttribute(this.getVar(), this.getVarScope().intValue())) instanceof SlingBean && ((type = this.getComponentType()) == null || type.isAssignableFrom(value.getClass()))) {
            result = value;
        }
        return result;
    }

    protected SlingBean createComponent() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        SlingBean component = null;
        Class<? extends SlingBean> type = this.getComponentType();
        if (type != null) {
            SlingBeanFactory factory;
            BeanFactory factoryRule = type.getAnnotation(BeanFactory.class);
            Resource modelResource = this.getModelResource(this.context);
            if (factoryRule != null && (factory = this.context.getService(factoryRule.serviceClass())) != null) {
                return factory.createBean(this.context, modelResource, type);
            }
            BeanContext baseContext = this.context.withResource(modelResource);
            component = baseContext.adaptTo(type);
            if (component == null) {
                throw new IllegalArgumentException("Could not adapt " + modelResource + " to " + type);
            }
            this.injectServices(component);
            this.additionalInitialization(component);
        }
        return component;
    }

    public Resource getModelResource(BeanContext context) {
        ResourceResolver resolver;
        Resource resource;
        if (this.attrResource != null) {
            return this.attrResource;
        }
        if (StringUtils.isNotBlank((CharSequence)this.attrPath) && (resource = (resolver = context.getResolver()).getResource(this.attrPath)) != null) {
            return resource;
        }
        return context.getResource();
    }

    protected void additionalInitialization(SlingBean component) {
    }

    protected void injectServices(SlingBean component) throws IllegalAccessException {
        Field[] declaredFields;
        if (fieldCache.containsKey(component.getClass())) {
            declaredFields = fieldCache.get(component.getClass());
        } else {
            declaredFields = component.getClass().getDeclaredFields();
            fieldCache.put(component.getClass(), declaredFields);
        }
        for (Field field : declaredFields) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (null != field.get(component)) continue;
            String filter = null;
            if (field.isAnnotationPresent(Named.class)) {
                Named name = field.getAnnotation(Named.class);
                filter = "(service.pid=" + name.value() + ")";
            }
            Class<?> typeOfField = field.getType();
            Object o = this.retrieveFirstServiceOfType(typeOfField, filter);
            field.set(component, o);
        }
    }

    protected <T> T retrieveFirstServiceOfType(Class<T> serviceType, String filter) {
        T[] services = null;
        try {
            services = this.context.getServices(serviceType, filter);
        }
        catch (InvalidSyntaxException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return services == null ? null : (T)services[0];
    }

    protected Map<String, Object> getReplacedAttributes(int scope) {
        if (this.replacedAttributes == null) {
            this.replacedAttributes = new ArrayList();
        }
        while (this.replacedAttributes.size() <= scope) {
            this.replacedAttributes.add(new HashMap());
        }
        return this.replacedAttributes.get(scope);
    }

    protected void setAttribute(String key, Object value, int scope) {
        Map<String, Object> replacedInScope = this.getReplacedAttributes(scope);
        if (!replacedInScope.containsKey(key)) {
            Object current = this.pageContext.getAttribute(key, scope);
            replacedInScope.put(key, current);
        }
        this.pageContext.setAttribute(key, value, scope);
    }

    protected void restoreAttributes() {
        if (this.replacedAttributes != null) {
            for (int scope = 0; scope < this.replacedAttributes.size(); ++scope) {
                Map<String, Object> replaced = this.replacedAttributes.get(scope);
                for (Map.Entry<String, Object> entry : replaced.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value != null) {
                        this.pageContext.setAttribute(key, value, scope);
                        continue;
                    }
                    this.pageContext.removeAttribute(key, scope);
                }
            }
        }
    }

    static {
        SCOPES.put("page", 1);
        SCOPES.put("request", 2);
        SCOPES.put("session", 3);
    }
}

