/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.browser;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.RequestHandle;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.util.LinkMapper;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.nodes.browser.Browser;
import com.composum.sling.nodes.browser.BrowserViews;
import com.composum.sling.nodes.console.ConsoleServletBean;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.tika.mime.MimeType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/repository/resources")
public class GenericView
extends ConsoleServletBean {
    private static final Logger LOG = LoggerFactory.getLogger(GenericView.class);
    protected BrowserViews.View browserView;
    private transient List<BrowserViews.View.Tab> viewTabs;
    private transient BrowserViews.View.Toolbar viewToolbar;
    private transient BrowserViews.View.Content viewContent;
    private transient String mappedUrl;
    private transient String unmappedUrl;
    private transient String viewType;
    private transient String fileType;
    private transient String mimeType;
    private transient Boolean isRenderable;
    private transient ResourceHandle fileResource;

    public GenericView(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public GenericView(BeanContext context) {
        super(context);
    }

    public GenericView() {
    }

    @Override
    public void initialize(BeanContext context, Resource resource) {
        super.initialize(context, resource);
        this.browserView = BrowserViews.getView(context, resource);
    }

    @NotNull
    public String getId() {
        return this.browserView.getId();
    }

    @NotNull
    public String getMappedUrl() {
        if (this.mappedUrl == null) {
            RequestHandle request = this.getRequest();
            this.mappedUrl = LinkUtil.getUrl((SlingHttpServletRequest)request, (String)this.getPath(), null, (String)"", (LinkMapper)LinkMapper.RESOLVER);
        }
        return this.mappedUrl;
    }

    @NotNull
    public String getUnmappedUrl() {
        if (this.unmappedUrl == null) {
            RequestHandle request = this.getRequest();
            this.unmappedUrl = LinkUtil.getUrl((SlingHttpServletRequest)request, (String)this.getPath(), null, (String)"", (LinkMapper)LinkMapper.CONTEXT);
        }
        return this.unmappedUrl;
    }

    @NotNull
    public String getViewResourceType() {
        String resourceType = this.browserView.getViewResourceType();
        return StringUtils.isNotBlank((CharSequence)resourceType) ? resourceType : "composum/nodes/browser/view/generic";
    }

    @NotNull
    public String getTabResourceType() {
        return this.browserView.getTabResourceType();
    }

    @NotNull
    public List<BrowserViews.View.Tab> getViewTabs() {
        if (this.viewTabs == null) {
            this.viewTabs = this.browserView.getTabs(this.context, (Resource)this.getResource());
        }
        return this.viewTabs;
    }

    @NotNull
    public BrowserViews.View.Toolbar getToolbar() {
        if (this.viewToolbar == null) {
            this.viewToolbar = this.browserView.getToolbar(this.context, (Resource)this.getResource());
        }
        return this.viewToolbar;
    }

    @NotNull
    public BrowserViews.View.Content getContent() {
        if (this.viewContent == null) {
            this.viewContent = this.browserView.getContent(this.context, (Resource)this.getResource());
        }
        return this.viewContent;
    }

    @NotNull
    public String getViewType() {
        if (this.viewType == null) {
            this.viewType = this.isImage() ? "image" : (this.isVideo() ? "video" : (Browser.isFile(this.getFileResource()) ? "file" : "something"));
        }
        return this.viewType;
    }

    @NotNull
    public String getFileType() {
        if (this.fileType == null) {
            StringBuilder type = new StringBuilder();
            if (Browser.isFile(this.getFileResource())) {
                type.append("file-").append(StringUtils.substringBefore((String)this.getMimeType(), (String)"/"));
                String extension = ResourceUtil.getNameExtension((Resource)this.getResource());
                if (StringUtils.isNotBlank((CharSequence)extension)) {
                    type.append("-").append(extension);
                }
            }
            this.fileType = type.toString();
        }
        return this.fileType;
    }

    @NotNull
    public String getFilePath() {
        return this.getFileResource().getPath();
    }

    @NotNull
    public ResourceHandle getFileResource() {
        if (this.fileResource == null) {
            Resource original;
            ResourceHandle resource = this.getResource();
            if ("jcr:content".equals(resource.getName())) {
                resource = Objects.requireNonNull(resource.getParent());
            }
            this.fileResource = (original = resource.getChild("jcr:content/renditions/original")) != null ? ResourceHandle.use((Resource)original) : resource;
        }
        return this.fileResource;
    }

    public boolean isRenderable() {
        if (this.isRenderable == null) {
            this.isRenderable = Browser.isRenderable(this.getFileResource(), ResourceUtil.getNameExtension((Resource)this.getResource()));
        }
        return this.isRenderable;
    }

    @NotNull
    public String getFileIcon() {
        return Browser.getFileIcon(this.getFileResource());
    }

    @NotNull
    public String getMimeTypeCss() {
        String mimeType = this.getMimeType();
        return StringUtils.isNotBlank((CharSequence)mimeType) ? mimeType.substring(mimeType.indexOf(47) + 1).replaceAll("[+]", " ") : "";
    }

    @NotNull
    public String getMimeType() {
        if (this.mimeType == null) {
            MimeType mType = MimeTypeUtil.getMimeType((Resource)this.getFileResource());
            this.mimeType = mType != null ? mType.toString() : "";
        }
        return this.mimeType;
    }

    public boolean isImage() {
        return this.getMimeType().startsWith("image/");
    }

    public boolean isVideo() {
        return this.getMimeType().startsWith("video/");
    }
}

