/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.browser.impl;

import com.composum.sling.nodes.browser.MergeMountpointService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MergeMountpointService.class})
public class MergeMountpointServiceImpl
implements MergeMountpointService {
    private static final Logger LOG = LoggerFactory.getLogger(MergeMountpointServiceImpl.class);
    private BundleContext bundleContext;
    private volatile String overrideMountPoint;
    private volatile String overlayMountPoint;

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.overlayMountPoint = null;
        this.overrideMountPoint = null;
        for (ServiceReference sr : bundleContext.getServiceReferences(ResourceProvider.class, "(provider.name=Merging)")) {
            String root = (String)sr.getProperty("provider.root");
            if (StringUtils.contains((CharSequence)root, (CharSequence)"overlay")) {
                this.overlayMountPoint = root;
                continue;
            }
            if (!StringUtils.contains((CharSequence)root, (CharSequence)"override")) continue;
            this.overrideMountPoint = root;
        }
    }

    private void init(ResourceResolver resolver) {
        if (this.overlayMountPoint != null) {
            return;
        }
        try {
            List mountpoints = this.bundleContext.getServiceReferences(ResourceProvider.class, "(provider.name=Merging)").stream().map(sr -> (String)sr.getProperty("provider.root")).collect(Collectors.toList());
            this.overrideMountPoint = mountpoints.stream().filter(m -> this.isOverrideMountpoint((String)m, resolver)).findFirst().orElse("/mnt/override");
            mountpoints.remove(this.overrideMountPoint);
            this.overlayMountPoint = mountpoints.isEmpty() ? "/mnt/overlay" : (String)mountpoints.get(0);
        }
        catch (InvalidSyntaxException e) {
            LOG.error("" + (Object)((Object)e), (Throwable)e);
        }
    }

    private boolean isOverrideMountpoint(String mountpoint, ResourceResolver resolver) {
        boolean hasMissingEntry = Arrays.asList(resolver.getSearchPath()).stream().map(p -> resolver.getResource(mountpoint + p)).filter(Objects::isNull).findAny().isPresent();
        return !hasMissingEntry;
    }

    @Override
    public String overrideMergeMountPoint(ResourceResolver resolver) {
        this.init(resolver);
        return StringUtils.defaultString((String)this.overrideMountPoint, (String)"/mnt/override");
    }

    @Override
    public String overlayMergeMountPoint(ResourceResolver resolver) {
        this.init(resolver);
        return StringUtils.defaultString((String)this.overlayMountPoint, (String)"/mnt/overlay");
    }
}

