/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.components;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.PathReferencesService;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.console.ConsoleServletBean;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

@Restricted(key="nodes/repository/resources")
public class ReferencesModel
extends ConsoleServletBean {
    private transient Map<String, PathReferencesService.Hit> references;
    private transient PathReferencesService.Options options;
    protected String queryString = "";
    protected String message = "";

    public ReferencesModel(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public ReferencesModel(BeanContext context) {
        super(context);
    }

    public ReferencesModel() {
    }

    @NotNull
    public ResourceHandle getResource() {
        Resource resource = null;
        SlingHttpServletRequest request = this.context.getRequest();
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String suffix = pathInfo.getSuffix();
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            resource = request.getResourceResolver().getResource(suffix);
        }
        return resource != null ? ResourceHandle.use(resource) : super.getResource();
    }

    public boolean isHasHits() {
        return !this.getReferences().isEmpty();
    }

    @NotNull
    public Iterable<PathReferencesService.Hit> getHits() {
        return this.getReferences().values();
    }

    @NotNull
    public Map<String, PathReferencesService.Hit> getReferences() {
        if (this.references == null) {
            this.references = new TreeMap<String, PathReferencesService.Hit>();
            try {
                PathReferencesService service = (PathReferencesService)this.context.getService(PathReferencesService.class);
                if (service != null) {
                    this.options = this.getOptions();
                    SlingHttpServletRequest request = this.context.getRequest();
                    String searchRoot = XSS.filter((String)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"root", (String)"/content"));
                    PathReferencesService.HitIterator found = service.findReferences(this.context.getResolver(), this.options, searchRoot, this.getPath());
                    Throwable exception = found.getThrowable();
                    if (exception != null) {
                        this.message = exception.getMessage();
                    }
                    this.queryString = found.getQueryString();
                    while (found.hasNext()) {
                        PathReferencesService.Hit hit = (PathReferencesService.Hit)found.next();
                        this.references.put(hit.getResource().getPath(), hit);
                    }
                }
            }
            catch (Exception ex) {
                this.message = ex.getMessage();
            }
        }
        return this.references;
    }

    public PathReferencesService.Options getOptions() {
        SlingHttpServletRequest request = this.context.getRequest();
        if (this.options == null) {
            this.options = new PathReferencesService.Options().basePath(XSS.filter((String)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"base", (String)""))).primaryType(XSS.filter((String)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"nt", (String)""))).resourceName(XSS.filter((String)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"rn", (String)""))).resourceType(XSS.filter((String)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"rt", (String)""))).contentPath(XSS.filter((String)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"cp", (String)""))).propertyName(XSS.filter((String)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"pn", (String)""))).useAbsolutePath(RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"abs", (Boolean)true).booleanValue()).useRelativePath(RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"rel", (Boolean)false).booleanValue()).useTextSearch(RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"text", (Boolean)false).booleanValue()).includeChildren(RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"ic", (Boolean)false).booleanValue()).childrenOnly(RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"co", (Boolean)false).booleanValue()).findRichText(RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"rich", (Boolean)false).booleanValue());
        }
        return this.options;
    }

    public String getOptionsJson() {
        PathReferencesService.Options options = this.getOptions();
        StringWriter buffer = new StringWriter();
        try {
            JsonWriter writer = new JsonWriter((Writer)buffer);
            writer.setIndent("    ");
            writer.setHtmlSafe(true);
            writer.beginObject();
            writer.name("useAbsolutePath").value(options.isUseAbsolutePath());
            writer.name("useRelativePath").value(options.isUseRelativePath());
            writer.name("basePath").value(options.getBasePath());
            writer.name("findRichText").value(options.isFindRichText());
            writer.name("useTextSearch").value(options.isUseTextSearch());
            writer.name("includeChildren").value(options.isIncludeChildren());
            writer.name("childrenOnly").value(options.isChildrenOnly());
            writer.name("primaryType").value(options.getPrimaryType());
            writer.name("resourceName").value(options.getResourceName());
            writer.name("contentPath").value(options.getContentPath());
            writer.name("propertyName").value(options.getPropertyName());
            writer.endObject();
            writer.flush();
        }
        catch (IOException ex) {
            this.message = ex.getMessage();
        }
        return buffer.toString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getMessage() {
        return this.message;
    }
}

