/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.console;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.nodes.console.ConsolePage;
import com.composum.sling.nodes.console.Consoles;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/console/view")
public class ConsoleModel
extends ConsolePage {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleModel.class);
    protected Consoles.Console console;
    private transient LinkModel link;

    public ConsoleModel(BeanContext context, Consoles.Console console) {
        this.console = console;
        this.initialize(context);
    }

    public ConsoleModel(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public ConsoleModel(BeanContext context) {
        super(context);
    }

    public ConsoleModel() {
    }

    @Override
    public void initialize(BeanContext context, Resource resource) {
        super.initialize(context, resource);
        if (this.console == null) {
            Consoles consoles = Consoles.getInstance(context);
            this.console = consoles.getConsole((String)resource.getValueMap().get("consoleId", (Object)resource.getName()));
        }
    }

    @NotNull
    public String getId() {
        return this.console != null ? this.console.getId() : this.getName();
    }

    @NotNull
    public String getName() {
        return this.console != null ? this.console.getName() : super.getName();
    }

    @NotNull
    public String getPath() {
        return this.console != null ? this.console.getPath() : super.getPath();
    }

    @NotNull
    public String getLabel() {
        return this.console != null ? this.console.getLabel() : this.getName();
    }

    public boolean isSupportsPermissions() {
        return this.console != null && this.console.supportsPermissions();
    }

    @NotNull
    public String getDescription() {
        return this.console != null ? this.console.getDescription() : "";
    }

    @NotNull
    public String getContentSrc() {
        return this.console != null ? this.console.getContentSrc() : "";
    }

    @NotNull
    public String getUrl() {
        return this.console != null ? this.console.getUrl(this.context.getRequest()) : "#";
    }

    @NotNull
    public String getStaticUrl() {
        return this.console != null ? this.console.getStaticUrl(this.context.getRequest()) : "#";
    }

    @NotNull
    public LinkModel getLink() {
        if (this.link == null) {
            this.link = new LinkModel(this.console != null ? this.console.getLink() : null);
        }
        return this.link;
    }

    @NotNull
    public String getLinkAttributes() {
        return this.console != null ? this.console.getLinkAttributes(this.context.getRequest()) : "";
    }

    public boolean isMenu() {
        return this.console != null && this.console.isMenu();
    }

    public boolean isValidMenu() {
        return this.isMenu() && this.getMenuItems().size() > 0;
    }

    @NotNull
    public Collection<ConsoleModel> getMenuItems() {
        return this.console != null ? this.console.getMenuItems(this.context) : Collections.emptyList();
    }

    @NotNull
    public String toString() {
        return this.console != null ? this.console.toString(this.context) : "";
    }

    @NotNull
    public String getDataSet() {
        return Base64.encodeBase64String((byte[])Consoles.getInstance(this.context).toString(this.context).getBytes(StandardCharsets.UTF_8));
    }

    public class LinkModel {
        private final Consoles.Console.Link link;

        public LinkModel(Consoles.Console.Link link) {
            this.link = link;
        }

        public boolean isValid() {
            return this.link != null && StringUtils.isNotBlank((CharSequence)this.getUrl());
        }

        public String getIcon() {
            return this.link != null ? this.link.getIcon() : "";
        }

        public String getTitle() {
            return this.link != null ? this.link.getTitle() : "";
        }

        public String getUrl() {
            return this.link != null ? this.link.getUrl(ConsoleModel.this.context.getRequest()) : "";
        }

        public String getTarget() {
            return this.link != null ? this.link.getTarget() : "";
        }
    }
}

