/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.console;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.util.HttpUtil;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.console.Condition;
import com.composum.sling.nodes.console.ConsoleModel;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consoles
implements HttpUtil.CachableInstance {
    private static final Logger LOG = LoggerFactory.getLogger(Consoles.class);
    public static final String CATEGORIES = "categories";
    public static final String ORDER = "order";
    public static final int ORDER_DEFAULT = 50;
    public static final String PN_CONSOLE_ID = "consoleId";
    public static final String PN_PARENT_ID = "parentId";
    public static final String PN_SLING_REDIRECT = "sling:redirect";
    public static final String PN_DYN_REDIRECT = "dynamicRedirect";
    public static final String PN_PATH_CONDITION = "pathCondition";
    public static final String PN_PERM_SUPPORT = "permissionsSupport";
    public static final String PN_DESCRIPTION = "description";
    public static final String PN_MENU = "menu";
    public static final String PN_ICON = "icon";
    public static final String PN_URL = "url";
    public static final String PN_TARGET = "target";
    public static final String PN_PRECONDITION = "precondition";
    public static final String PN_CONTENT_SRC = "contentSrc";
    public static final String CONTENT_QUERY_BASE = "/jcr:root";
    public static final String CONTENT_QUERY_RULE = "/content[@sling:resourceType='composum/nodes/console/page']";
    public static final String SA_INSTANCE = Consoles.class.getName() + "#instance";
    private final BeanContext beanContext;
    private final CoreConfiguration coreConfig;
    private final TreeMap<String, Console> consoleSet;
    private final Set<Console> toplevel;
    private final long created;

    @NotNull
    public static Consoles getInstance(final @NotNull BeanContext context) {
        SlingHttpServletRequest request = Objects.requireNonNull(context.getRequest());
        return (Consoles)HttpUtil.getInstance((SlingHttpServletRequest)request, (String)SA_INSTANCE, (HttpUtil.InstanceFactory)new HttpUtil.InstanceFactory<Consoles>(){

            public Class<Consoles> getType() {
                return Consoles.class;
            }

            public Consoles newInstance(SlingHttpServletRequest request) {
                return new Consoles(context);
            }
        });
    }

    public Consoles(@NotNull BeanContext context) {
        this.beanContext = context;
        this.coreConfig = (CoreConfiguration)this.beanContext.getService(CoreConfiguration.class);
        this.consoleSet = new TreeMap();
        ResourceResolver resolver = context.getResolver();
        for (String path : resolver.getSearchPath()) {
            this.findConsoles(context, CONTENT_QUERY_BASE + path + CONTENT_QUERY_RULE);
        }
        for (Map.Entry entry : this.consoleSet.entrySet()) {
            Console parent;
            Console console = (Console)entry.getValue();
            String parentId = console.getParentId();
            if (!StringUtils.isNotBlank((CharSequence)parentId) || (parent = this.getConsole(parentId)) == null) continue;
            parent.addConsole(console);
        }
        this.toplevel = new TreeSet<Console>();
        for (Map.Entry entry : this.consoleSet.entrySet()) {
            Console console = (Console)entry.getValue();
            if (console.getParent() != null || console.isMenu() && !console.isValidMenu()) continue;
            this.toplevel.add(console);
        }
        for (Map.Entry entry : new TreeMap<String, Console>((SortedMap<String, Console>)this.consoleSet).entrySet()) {
            String id;
            String key = (String)entry.getKey();
            Console console = (Console)entry.getValue();
            if (!console.isMenu() || key.equals(id = console.getId())) continue;
            this.consoleSet.remove(key);
            this.consoleSet.put(id, console);
        }
        this.created = System.currentTimeMillis();
    }

    public long getCreated() {
        return this.created;
    }

    @NotNull
    public Collection<ConsoleModel> getConsoles(@NotNull BeanContext context) {
        ArrayList<ConsoleModel> result = new ArrayList<ConsoleModel>();
        for (Console console : this.toplevel) {
            result.add(new ConsoleModel(context, console));
        }
        return result;
    }

    @Nullable
    public ConsoleModel getConsole(@NotNull BeanContext context, @NotNull String name) {
        Console console = this.getConsole(name);
        return console != null ? new ConsoleModel(context, console) : null;
    }

    @Nullable
    public Console getConsole(@NotNull String name) {
        return this.consoleSet.get(name);
    }

    protected void findConsoles(@NotNull BeanContext context, @NotNull String query) {
        SlingHttpServletRequest request = Objects.requireNonNull(context.getRequest());
        NodesConfiguration configuration = Objects.requireNonNull((NodesConfiguration)context.getService(NodesConfiguration.class));
        String[] categories = configuration.getConsoleCategories();
        ConsoleFilter consoleFilter = new ConsoleFilter(context, categories);
        ResourceResolver resolver = context.getResolver();
        Iterator consoleContentResources = resolver.findResources(query, "xpath");
        while (consoleContentResources.hasNext()) {
            Resource consoleContent = (Resource)consoleContentResources.next();
            for (Resource resource : consoleContent.getChildren()) {
                if (!consoleFilter.accept(resource)) continue;
                Console console = new Console(consoleFilter, ResourceHandle.use((Resource)resource));
                this.consoleSet.putIfAbsent(console.getId(), console);
            }
        }
    }

    @NotNull
    public String toString(@NotNull BeanContext context) {
        StringWriter buffer = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)buffer);
        try {
            writer.beginObject();
            for (Map.Entry<String, Console> entry : this.consoleSet.entrySet()) {
                writer.name(entry.getKey()).jsonValue(entry.getValue().toString(context));
            }
            writer.endObject();
            writer.flush();
        }
        catch (IOException ioex) {
            LOG.error(ioex.toString());
        }
        return buffer.toString();
    }

    public class Console
    implements Comparable<Console>,
    Serializable {
        private final String id;
        private final String name;
        private final String path;
        private final String title;
        private final String slingRedirect;
        private final String pathCondition;
        private final boolean dynamicRedirect;
        private final boolean permissionsSupport;
        private final String description;
        private final String target;
        private final String contentSrc;
        private final int order;
        private final Link link;
        private Console parent = null;
        private final String parentId;
        private final boolean isMenu;
        private final boolean isDeclaredMenu;
        private final Map<String, Console> menuItems;

        public Console(@NotNull ConsoleFilter filter, ResourceHandle handle) {
            this(filter, handle, (Boolean)handle.getProperty(Consoles.PN_MENU, (Object)Boolean.FALSE));
        }

        public Console(@NotNull ConsoleFilter filter, ResourceHandle handle, boolean isMenu) {
            Resource child;
            this.id = (String)handle.getProperty(Consoles.PN_CONSOLE_ID, String.class);
            this.name = handle.getName();
            this.path = handle.getPath();
            this.title = handle.getTitle();
            this.slingRedirect = (String)handle.getProperty(Consoles.PN_SLING_REDIRECT, String.class);
            this.pathCondition = (String)handle.getProperty(Consoles.PN_PATH_CONDITION, String.class);
            this.dynamicRedirect = (Boolean)handle.getProperty(Consoles.PN_DYN_REDIRECT, (Object)Boolean.FALSE);
            this.permissionsSupport = (Boolean)handle.getProperty(Consoles.PN_PERM_SUPPORT, (Object)Boolean.FALSE);
            this.description = (String)handle.getProperty(Consoles.PN_DESCRIPTION, (Object)"");
            this.target = (String)handle.getProperty(Consoles.PN_TARGET, (Object)"");
            this.contentSrc = (String)handle.getProperty(Consoles.PN_CONTENT_SRC, (Object)"");
            this.order = (Integer)handle.getProperty(Consoles.ORDER, (Object)50);
            this.parentId = (String)handle.getProperty(Consoles.PN_PARENT_ID, String.class);
            this.isMenu = isMenu;
            this.isDeclaredMenu = (Boolean)handle.getProperty(Consoles.PN_MENU, (Object)Boolean.FALSE);
            this.menuItems = new TreeMap<String, Console>();
            if (isMenu) {
                this.buildMenu(filter, handle);
            }
            this.link = (child = handle.getChild("link")) != null ? new Link(ResourceHandle.use((Resource)child)) : null;
        }

        public boolean isDynamicRedirect() {
            return this.dynamicRedirect;
        }

        public boolean supportsPermissions() {
            return this.permissionsSupport;
        }

        @NotNull
        public String getLabel() {
            return this.title;
        }

        @NotNull
        public String getId() {
            return StringUtils.isNotBlank((CharSequence)this.id) ? this.id : (this.parent != null ? this.parent.getId() + "-" + this.getName() : this.getName());
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        @NotNull
        public String getDescription() {
            return StringUtils.isNotBlank((CharSequence)this.description) ? (this.description.startsWith("/") ? this.description : Consoles.this.coreConfig.getComposumBase() + this.description) : "";
        }

        @NotNull
        public String getContentSrc() {
            return StringUtils.isNotBlank((CharSequence)this.contentSrc) ? (this.contentSrc.startsWith("/") ? this.contentSrc : Consoles.this.coreConfig.getComposumBase() + this.contentSrc) : "";
        }

        @NotNull
        protected String embedSuffix(@NotNull SlingHttpServletRequest request, @NotNull String value) {
            String suffix;
            if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)(suffix = XSS.filter((String)request.getRequestPathInfo().getSuffix())))) {
                value = StringUtils.replace((String)value, (String)"${path}", (String)suffix);
                value = StringUtils.replace((String)value, (String)"$%7Bpath%7D", (String)suffix);
            }
            return value;
        }

        @NotNull
        public String getRedirectUrl(@NotNull SlingHttpServletRequest request) {
            String url;
            String string = url = StringUtils.isNotBlank((CharSequence)this.slingRedirect) ? this.slingRedirect : this.getPath();
            return this.isDynamicRedirect() ? url : (StringUtils.isNotBlank((CharSequence)url) ? this.embedSuffix(request, LinkUtil.getUnmappedUrl((SlingHttpServletRequest)request, (String)url)) : "");
        }

        @NotNull
        public String getUrl(@NotNull SlingHttpServletRequest request) {
            String url = this.isDynamicRedirect() ? "" : this.embedSuffix(request, LinkUtil.getUnmappedUrl((SlingHttpServletRequest)request, (String)this.getPath()));
            return StringUtils.isNotBlank((CharSequence)url) ? url : "#";
        }

        public String getStaticUrl(@NotNull SlingHttpServletRequest request) {
            String url = StringUtils.isNotBlank((CharSequence)this.slingRedirect) ? this.slingRedirect : this.getPath();
            return url.replaceAll("\\$\\{.+}", "");
        }

        @NotNull
        public String getLinkAttributes(@NotNull SlingHttpServletRequest request) {
            String value;
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.target)) {
                builder.append(" target=\"").append(this.target).append("\"");
            }
            if (this.isDynamicRedirect() && StringUtils.isNotBlank((CharSequence)(value = this.getRedirectUrl(request)))) {
                builder.append(" data-redirect=\"").append(value).append("\"");
                if (StringUtils.isNotBlank((CharSequence)this.pathCondition)) {
                    builder.append(" data-path-condition=\"").append(this.pathCondition).append("\"");
                }
            }
            return builder.toString();
        }

        @Nullable
        public Link getLink() {
            return this.link;
        }

        @Override
        public int compareTo(Console other) {
            CompareToBuilder builder = new CompareToBuilder();
            builder.append(this.order, other.order);
            builder.append((Object)this.getPath(), (Object)other.getPath());
            return builder.toComparison();
        }

        @Nullable
        public String getParentId() {
            return this.parentId;
        }

        @Nullable
        public Console getParent() {
            return this.parent;
        }

        public boolean isMenu() {
            return this.isMenu;
        }

        public boolean isDeclaredMenu() {
            return this.isDeclaredMenu;
        }

        public boolean isValidMenu() {
            return !this.menuItems.isEmpty();
        }

        @NotNull
        public Collection<ConsoleModel> getMenuItems(@NotNull BeanContext context) {
            ArrayList<ConsoleModel> result = new ArrayList<ConsoleModel>();
            for (Console console : this.menuItems.values()) {
                if (console.isDeclaredMenu() && !console.isValidMenu()) continue;
                result.add(new ConsoleModel(context, console));
            }
            return result;
        }

        protected void addConsole(@NotNull Console console) {
            this.menuItems.put(String.format("%04d", console.order) + "#" + console.getName(), console);
            console.parent = this;
        }

        protected void buildMenu(@NotNull ConsoleFilter filter, @NotNull ResourceHandle handle) {
            for (Resource child : handle.getChildren()) {
                if (!filter.accept(child)) continue;
                Console console = new Console(filter, ResourceHandle.use((Resource)child), true);
                Consoles.this.consoleSet.put(console.getName(), console);
                this.addConsole(console);
            }
        }

        @NotNull
        public String toString(@NotNull BeanContext context) {
            StringWriter buffer = new StringWriter();
            JsonWriter writer = new JsonWriter((Writer)buffer);
            try {
                Console parent = this.getParent();
                writer.beginObject();
                if (parent != null) {
                    writer.name("parent").value(parent.getId());
                }
                writer.name("id").value(this.getId());
                writer.name(Consoles.PN_URL).value(this.getUrl(context.getRequest()));
                writer.endObject();
                writer.flush();
            }
            catch (IOException ioex) {
                LOG.error(ioex.toString());
            }
            return buffer.toString();
        }

        public class Link {
            private final String icon;
            private final String title;
            private final String url;
            private final String target;

            public Link(ResourceHandle handle) {
                this.title = handle.getTitle();
                this.icon = (String)handle.getProperty(Consoles.PN_ICON, (Object)"external-link");
                this.url = (String)handle.getProperty(Consoles.PN_URL, (Object)"");
                this.target = (String)handle.getProperty(Consoles.PN_TARGET, (Object)"_self");
            }

            public String getIcon() {
                return this.icon;
            }

            public String getTitle() {
                return this.title;
            }

            public String getUrl(@NotNull SlingHttpServletRequest request) {
                return this.url;
            }

            public String getTarget() {
                return this.target;
            }
        }
    }

    public class ConsoleFilter
    extends ResourceFilter.AbstractResourceFilter {
        private final BeanContext context;
        private final List<String> selectors;

        public ConsoleFilter(BeanContext context, String ... selectors) {
            this.context = context;
            this.selectors = Arrays.asList(selectors);
        }

        public boolean accept(@Nullable Resource resource) {
            if (resource != null) {
                String[] categories;
                ValueMap values = resource.getValueMap();
                for (String category : categories = (String[])values.get(Consoles.CATEGORIES, (Object)new String[0])) {
                    String[] precondition;
                    if (!this.selectors.contains(category)) continue;
                    for (String condition : precondition = (String[])values.get(Consoles.PN_PRECONDITION, (Object)new String[0])) {
                        Condition filter = Condition.DEFAULT.getCondition(condition);
                        if (filter == null || filter.accept(this.context, resource)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isRestriction() {
            return true;
        }

        public void toString(@NotNull StringBuilder builder) {
            builder.append("console(").append(StringUtils.join(this.selectors, (char)',')).append(")");
        }
    }
}

