/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.consoleplugin;

import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"service.description=Composum Nodes Threaddump Webconsole Plugin : Prints stacktraces for all threads", "felix.webconsole.label=threaddump", "felix.webconsole.title=Threaddump", "felix.webconsole.category=Composum", "felix.webconsole.css=threaddump/slingconsole/composum/nodes/console/threaddumpplugin.css"})
public class ThreaddumpConsolePlugin
extends HttpServlet {
    protected static final String LOC_CSS = "slingconsole/composum/nodes/console/threaddumpplugin.css";
    public static final String PARAM_STATE = "state";
    public static final String PARAM_NAMEREGEX = "nameregex";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().endsWith(LOC_CSS)) {
            response.setContentType("text/css");
            InputStream cssResource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/slingconsole/composum/nodes/console/threaddumpplugin.css");
            IOUtils.copy((InputStream)Objects.requireNonNull(cssResource, "CSS resource missing: /slingconsole/composum/nodes/console/threaddumpplugin.css"), (OutputStream)response.getOutputStream());
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.print("<html><body><h2>Thread dump</h2>");
        new ThreaddumpRunner(writer, request).print();
        writer.println("</body></html>");
    }

    protected class ThreaddumpRunner {
        protected final PrintWriter writer;
        protected final HttpServletRequest request;
        protected Set<Thread.State> stati = Collections.singleton(Thread.State.RUNNABLE);
        protected String nameRegexStr = "";
        protected Pattern nameRegex = Pattern.compile(this.nameRegexStr);
        protected ThreadMXBean threadMXBean;

        public ThreaddumpRunner(PrintWriter writer, HttpServletRequest request) {
            this.writer = writer;
            this.request = request;
            String[] statiArray = XSS.filter((String[])request.getParameterValues(ThreaddumpConsolePlugin.PARAM_STATE));
            if (statiArray != null && statiArray.length > 0) {
                this.stati = new HashSet<Thread.State>();
                for (String stateStr : statiArray) {
                    Thread.State state = Thread.State.valueOf(stateStr);
                    this.stati.add(state);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)XSS.filter((String)request.getParameter(ThreaddumpConsolePlugin.PARAM_NAMEREGEX)))) {
                this.nameRegexStr = XSS.filter((String)request.getParameter(ThreaddumpConsolePlugin.PARAM_NAMEREGEX));
                try {
                    this.nameRegex = Pattern.compile(this.nameRegexStr);
                }
                catch (PatternSyntaxException e) {
                    writer.println("<p><strong>Regex syntax error: " + e + "</strong></p>");
                }
            }
            try {
                ThreadMXBean theThreadMXBean = ManagementFactory.getThreadMXBean();
                this.threadMXBean = theThreadMXBean != null && theThreadMXBean.isThreadCpuTimeSupported() && theThreadMXBean.isThreadCpuTimeEnabled() ? theThreadMXBean : null;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public void print() {
            this.printForm();
            this.writer.println("<p>Since many threads share the same stacktrace, threads with the same stacktrace are grouped together.</p><br>");
            this.printThreads();
        }

        protected void printThreads() {
            this.writer.println("<ul>");
            Map<Thread, StackTraceElement[]> traceMap = Thread.getAllStackTraces();
            List traces = traceMap.entrySet().stream().map(e -> Pair.of((Object)((Thread)e.getKey()), (Object)this.stackTrace((StackTraceElement[])e.getValue()))).filter(e -> this.nameRegex.matcher(((Thread)e.getLeft()).getName()).find()).filter(e -> this.stati.contains((Object)((Thread)e.getLeft()).getState())).collect(Collectors.toList());
            Collections.sort(traces, Comparator.comparing(e -> ((Thread)e.getLeft()).getName()));
            TreeMap<String, List<Pair>> tracesGrouped = new TreeMap<String, List<Pair>>(traces.stream().collect(Collectors.groupingBy(e -> (String)e.getRight())));
            List tracesGroupedByStacktrace = tracesGrouped.entrySet().stream().map(e -> new StacktraceWithThreads((String)e.getKey(), this.extractThreads((List)e.getValue()))).collect(Collectors.toList());
            Collections.sort(tracesGroupedByStacktrace, Comparator.comparing(e -> e.threads.get(0).getName()));
            Collections.sort(tracesGroupedByStacktrace, Comparator.comparing(e -> Float.valueOf(e.cumulativeCpuTime)).reversed());
            for (StacktraceWithThreads traceAndThreads : tracesGroupedByStacktrace) {
                this.writer.println("<li>");
                for (Thread t : traceAndThreads.threads) {
                    this.writer.print(t.getId());
                    this.writer.print(" (" + (Object)((Object)t.getState()));
                    if (this.threadMXBean != null) {
                        this.writer.print(", cpu " + (float)this.threadMXBean.getThreadCpuTime(t.getId()) / 1.0E9f + " s");
                    }
                    this.writer.print(")");
                    this.writer.print(" : ");
                    this.writer.print(t.getName());
                    this.writer.println("<br/>");
                }
                if (traceAndThreads.cumulativeCpuTime > 0.0f && traceAndThreads.threads.size() > 1) {
                    this.writer.println("(" + traceAndThreads.cumulativeCpuTime + " s cumulative cpu time)</br>");
                }
                this.writer.println("<pre>");
                this.writer.println(traceAndThreads.trace);
                this.writer.println("</pre>");
                this.writer.println("</li>");
            }
            this.writer.println("</ul>");
        }

        protected double cumulativeCpuTime(List<Thread> threads) {
            double result = 0.0;
            if (this.threadMXBean != null) {
                for (Thread thread : threads) {
                    result += (double)this.threadMXBean.getThreadCpuTime(thread.getId());
                }
            }
            return result / 1.0E9;
        }

        private List<Thread> extractThreads(List<Pair<Thread, String>> threadTraces) {
            return threadTraces.stream().map(e -> (Thread)e.getLeft()).collect(Collectors.toList());
        }

        protected String stackTrace(StackTraceElement[] stackTraceElements) {
            StringBuffer buf = new StringBuffer();
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                buf.append("     at ").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")\n");
            }
            return buf.toString();
        }

        protected void printForm() {
            this.writer.println("<form action=\"" + this.request.getRequestURL() + "\" method=\"get\">");
            this.writer.println("Print only threads of stati ");
            for (Thread.State value : Thread.State.values()) {
                String checked = this.stati.contains((Object)value) ? "checked" : "";
                this.writer.println("  <input type=\"checkbox\" name=\"state\" value=\"" + value.name() + "\" " + checked + "> " + (Object)((Object)value));
            }
            this.writer.println(" with names matching regex <input type=\"text\" name=\"nameregex\" value=\"" + this.nameRegex + "\">");
            this.writer.println(" <input type=\"submit\">\n");
            this.writer.println("</form>");
        }

        protected class StacktraceWithThreads {
            String trace;
            final List<Thread> threads;
            float cumulativeCpuTime;

            public StacktraceWithThreads(String trace, List<Thread> threads) {
                this.trace = trace;
                List<Thread> theThreads = threads;
                Collections.sort(theThreads, Comparator.comparing(Thread::getName));
                if (ThreaddumpRunner.this.threadMXBean != null) {
                    theThreads = theThreads.stream().map(t -> Pair.of((Object)t, (Object)(-ThreaddumpRunner.this.threadMXBean.getThreadCpuTime(t.getId())))).sorted(Comparator.comparing(Pair::getRight)).map(Pair::getKey).collect(Collectors.toList());
                }
                this.threads = theThreads;
                this.cumulativeCpuTime = (float)ThreaddumpRunner.this.cumulativeCpuTime(threads);
            }
        }
    }
}

