/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.remote.RemoteClient;
import com.composum.sling.nodes.mount.remote.RemoteClientSetup;
import com.composum.sling.nodes.mount.remote.RemoteReader;
import com.composum.sling.nodes.mount.remote.RemoteResolver;
import com.composum.sling.nodes.mount.remote.RemoteWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="com.composum.sling.nodes.mount.remote.RemoteProvider", service={ResourceProvider.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=Composum Nodes Remote Resource Provider"})
@Designate(ocd=Config.class, factory=true)
public class RemoteProvider
extends ResourceProvider<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteProvider.class);
    @Reference
    protected RemoteClientSetup clientSetup;
    protected BundleContext bundleContext;
    private Config config;
    protected String localRoot;
    protected String[] searchPath;
    protected List<Pattern> ignoredPathPatterns;
    protected RemoteClient remoteClient;
    protected RemoteReader remoteReader;
    protected RemoteWriter remoteWriter;

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Config config) {
        this.bundleContext = bundleContext;
        this.config = config;
        this.localRoot = config.provider_root();
        this.searchPath = (String[])config.resolver_search_path().clone();
        for (int i = 0; i < this.searchPath.length; ++i) {
            this.searchPath[i] = this.searchPath[i].replaceAll("\\$\\{root}", this.localRoot);
        }
        this.ignoredPathPatterns = new ArrayList<Pattern>();
        for (String rule : config.ignored_patterns()) {
            this.ignoredPathPatterns.add(Pattern.compile(rule.replaceAll("\\$\\{root}", this.localRoot)));
        }
        this.remoteClient = new RemoteClient(this, config, Arrays.asList(config.client_configuration()));
        this.remoteReader = new RemoteReader(this);
        this.remoteWriter = new RemoteWriter(this);
    }

    @Deactivate
    protected void deactivate() {
        this.remoteWriter = null;
        this.remoteReader = null;
        this.remoteClient = null;
        this.ignoredPathPatterns = null;
        this.searchPath = null;
        this.localRoot = null;
        this.config = null;
        this.bundleContext = null;
    }

    public boolean isLocal(@NotNull String path) {
        return path.equals(this.localRoot) || path.startsWith(this.localRoot + "/");
    }

    protected String localPath(@NotNull String path) {
        String localRoot = this.getProviderRoot();
        if (!this.isLocal(path)) {
            path = localRoot + (path.startsWith("/") ? "" : "/") + path;
        }
        return path;
    }

    protected String remotePath(@NotNull String path) {
        String localRoot = this.getProviderRoot();
        if (this.isLocal(path)) {
            path = path.substring(localRoot.length());
        }
        return path;
    }

    protected boolean ignoreIt(@NotNull String path) {
        for (Pattern pattern : this.ignoredPathPatterns) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getProviderRoot() {
        return this.localRoot;
    }

    @Nullable
    public Resource getResource(@NotNull ResolveContext<Object> ctx, @NotNull String path, @NotNull ResourceContext resourceContext, @Nullable Resource parent) {
        if (this.ignoreIt(path) || !this.remoteClient.isValid()) {
            return null;
        }
        RemoteResolver remoteResolver = new RemoteResolver(this, ctx.getResourceResolver());
        return remoteResolver.getResource(path);
    }

    @Nullable
    public Iterator<Resource> listChildren(@NotNull ResolveContext<Object> ctx, @NotNull Resource parent) {
        return parent.listChildren();
    }

    @ObjectClassDefinition(name="Composum Nodes Remote Resource Provider")
    public static @interface Config {
        @AttributeDefinition(name="Provider Root", description="The mount point of the remote tree in the local resource hierarchy, e.g. /remote/somesystem . Using something below /mnt may or may not work.")
        public String provider_root();

        @AttributeDefinition(name="Resolver Search Path", description="The resolver search path used by the remote system mapped to the local tree; use ${root} as placeholder for the provider root path.")
        public String[] resolver_search_path() default {"${root}/apps/", "${root}/libs/"};

        @AttributeDefinition(name="Ignored Path Patterns", description="The set of path patterns in the local tree which should be ignored by this provider. ${root} is a placeholder for the provider root path. Please take care that this does not match the provider root itself, or it will be inactive.")
        public String[] ignored_patterns() default {"^/mnt(/.*)?$", "^${root}/mnt(/.*)?$", "^${root}/(api|bin|index|is|resource-status)$", "^${root}(/system/sling)?/login[^/]*$", "^${root}(/.*)?/[^/]+\\.servlet$"};

        @AttributeDefinition(name="Remote HTTP URL", description="The URL to access the remote system (the HTTP URL of the remote repository root), e.g. https://somesystem/.")
        public String remote_url();

        @AttributeDefinition(name="Username")
        public String login_username();

        @AttributeDefinition(name="Password", type=AttributeType.PASSWORD)
        public String login_password();

        @AttributeDefinition(name="Client Config", description="client builder service keys to extend the remote client builder")
        public String[] client_configuration();

        @AttributeDefinition(name="HTTP Request Headers", description="request headers to use: <name>=<value>")
        public String[] request_headers();

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "local: {provider.root}, remote: {remote.url}, extensions: {client.configuration}";
    }
}

