/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.ExtendedResolver;
import com.composum.sling.nodes.mount.remote.RemoteProvider;
import com.composum.sling.nodes.mount.remote.RemoteResource;
import com.composum.sling.nodes.mount.remote.RemoteWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.apache.sling.api.wrappers.ResourceResolverWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteResolver
extends ResourceResolverWrapper
implements ExtendedResolver {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteResolver.class);
    protected final LRUMap resourceCache = new LRUMap(200);
    protected final RemoteProvider provider;
    protected final ResourceResolver parentDelegate;
    protected RemoteWriter.ChangeSet changeSet = new RemoteWriter.ChangeSet();

    public RemoteResolver(@NotNull RemoteProvider provider, @NotNull ResourceResolver parentDelegate) {
        super(parentDelegate);
        this.provider = provider;
        this.parentDelegate = parentDelegate;
    }

    @Nullable
    protected ResourceResolver getParentDelegate() {
        return this.parentDelegate;
    }

    protected RemoteWriter.ChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Nullable
    protected Resource _resolve(@NotNull String path) {
        if (this.provider.ignoreIt(path)) {
            return null;
        }
        try {
            if (this.provider.localRoot.startsWith(path) && !path.equals(this.provider.localRoot)) {
                LOG.debug("delegating '{}' to default resolver...", (Object)path);
                return this.parentDelegate.getResource(path);
            }
            String localPath = this.provider.localPath(path);
            RemoteResource resource = (RemoteResource)((Object)this.resourceCache.get((Object)localPath));
            if (resource != null) {
                LOG.debug("from cache: '{}'", (Object)localPath);
                return resource;
            }
            if (!path.equals(localPath)) {
                LOG.warn("reading '{}' ({})...", (Object)localPath, (Object)path);
            } else {
                LOG.debug("reading '{}'...", (Object)localPath);
            }
            RemoteResource parent = null;
            String parentPath = this._parentPath(path);
            if (parentPath != null && this.provider.isLocal(parentPath)) {
                parent = (RemoteResource)this.getResource(parentPath);
            }
            if (parent != null) {
                resource = (RemoteResource)parent.getChild(this._pathName(path));
                if (resource != null) {
                    resource.children();
                }
            } else {
                resource = this.provider.remoteReader.loadResource(new RemoteResource(this, localPath), false);
            }
            if (resource == null) {
                resource = new RemoteResource.NonExisting(this, localPath);
            }
            this.resourceCache.put((Object)localPath, (Object)resource);
            return resource;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected RemoteResource _discard(RemoteResource resource) {
        Resource parent = resource.getParent();
        if (parent instanceof RemoteResource) {
            RemoteResource remoteParent = (RemoteResource)parent;
            if (remoteParent.children != null) {
                remoteParent.children.remove(resource.name);
            }
        }
        RemoteResource.NonExisting placeholder = new RemoteResource.NonExisting(this, resource.path);
        this.resourceCache.put((Object)resource.path, (Object)placeholder);
        return placeholder;
    }

    @Nullable
    RemoteResource _parent(String path) {
        String parentPath = this._parentPath(path);
        return parentPath != null && this.provider.isLocal(parentPath) ? (RemoteResource)((Object)this.resourceCache.get((Object)parentPath)) : null;
    }

    @Nullable
    protected String _parentPath(@NotNull String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash > 0) {
                return path.substring(0, lastSlash);
            }
            if (!"/".equals(path)) {
                return "/";
            }
        }
        return null;
    }

    @NotNull
    protected String _pathName(@NotNull String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            return path.substring(lastSlash + 1);
        }
        return path;
    }

    @Override
    @Nullable
    public String getResolverRootPath() {
        return this.provider.localRoot;
    }

    @NotNull
    public Resource resolve(@NotNull HttpServletRequest request, @NotNull String absPath) {
        return this.resolve(absPath);
    }

    @NotNull
    public Resource resolve(@NotNull String absPath) {
        Resource resource = this._resolve(absPath);
        return resource != null ? resource : new NonExistingResource(this.parentDelegate, this.provider.localPath(absPath));
    }

    @NotNull
    public Resource resolve(@NotNull HttpServletRequest request) {
        return this.resolve(request.getPathInfo());
    }

    @NotNull
    public String map(@NotNull String resourcePath) {
        return this.provider.remoteClient.getHttpUrl(this.provider.remotePath(resourcePath));
    }

    @Nullable
    public String map(@NotNull HttpServletRequest request, @NotNull String resourcePath) {
        return this.map(resourcePath);
    }

    @Nullable
    public Resource getResource(@NotNull String path) {
        Resource resource;
        RemoteResource parent = this._parent(path);
        if (parent != null) {
            resource = parent.getChild(this._pathName(path));
            if (resource instanceof RemoteResource) {
                ((RemoteResource)resource).children();
            }
        } else {
            resource = this._resolve(path);
        }
        return resource instanceof RemoteResource.NonExisting ? null : resource;
    }

    @Nullable
    public Resource getResource(Resource base, @NotNull String path) {
        return this.getResource(base.getPath() + "/" + path);
    }

    @NotNull
    public String[] getSearchPath() {
        return this.provider.searchPath;
    }

    @Nullable
    public Resource getParent(@NotNull Resource child) {
        String parentPath = this._parentPath(child.getPath());
        return parentPath != null ? this.getResource(parentPath) : null;
    }

    @NotNull
    public Iterator<Resource> listChildren(@NotNull Resource parent) {
        return parent.listChildren();
    }

    @NotNull
    public Iterable<Resource> getChildren(@NotNull Resource parent) {
        return parent.getChildren();
    }

    @NotNull
    public Iterator<Resource> findResources(@NotNull String query, String language) {
        return Collections.emptyIterator();
    }

    @NotNull
    public Iterator<Map<String, Object>> queryResources(@NotNull String query, String language) {
        return Collections.emptyIterator();
    }

    public boolean hasChildren(@NotNull Resource resource) {
        return resource.hasChildren();
    }

    @NotNull
    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        return new RemoteResolver(this.provider, this.parentDelegate);
    }

    public boolean isLive() {
        return this.parentDelegate.isLive();
    }

    public void close() {
    }

    @Nullable
    public String getUserID() {
        return this.parentDelegate.getUserID();
    }

    @NotNull
    public Iterator<String> getAttributeNames() {
        return Collections.emptyIterator();
    }

    @Nullable
    public Object getAttribute(@NotNull String name) {
        return null;
    }

    public void delete(@NotNull Resource resource) throws PersistenceException {
        if (resource instanceof RemoteResource) {
            this.changeSet.addDelete(this._discard((RemoteResource)resource));
        }
    }

    @NotNull
    public Resource create(@NotNull Resource parent, @NotNull String name, Map<String, Object> properties) throws PersistenceException {
        RemoteResource resource = new RemoteResource(this, parent.getPath() + "/" + name);
        resource.children = new LinkedHashMap<String, Resource>();
        resource.modifiedValues = new ModifiableValueMapDecorator(new HashMap<String, Object>(properties));
        this.changeSet.addCreate(resource);
        return resource;
    }

    public void revert() {
        this.changeSet.clear();
        this.resourceCache.clear();
    }

    public void commit() throws PersistenceException {
        try {
            this.provider.remoteWriter.commitChanges(this.changeSet);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new PersistenceException(ex.getMessage());
        }
        finally {
            this.changeSet.clear();
            this.resourceCache.clear();
        }
    }

    public boolean hasChanges() {
        return this.changeSet.size() > 0;
    }

    @Nullable
    public String getParentResourceType(Resource resource) {
        Resource parent = resource != null ? this.getParent(resource) : null;
        return parent != null ? parent.getResourceType() : null;
    }

    @Nullable
    public String getParentResourceType(String resourceType) {
        return null;
    }

    public boolean isResourceType(Resource resource, String resourceType) {
        return resource != null && resource.isResourceType(resourceType);
    }

    public void refresh() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource copy(String srcAbsPath, String destAbsPath) throws PersistenceException {
        void var3_8;
        Resource source = this.getResource(srcAbsPath);
        Resource destParent = this.getResource(destAbsPath);
        if (source instanceof RemoteResource && destParent instanceof RemoteResource) {
            String name = source.getName();
            if (destParent.getChild(name) != null) throw new PersistenceException(" a resource with the designated name exsits already at destination");
            RemoteResource remoteResource = new RemoteResource((RemoteResource)source, destParent.getPath() + "/" + name);
            this.changeSet.addCopy(remoteResource, source);
            return var3_8;
        } else {
            Resource resource = this.parentDelegate.copy(srcAbsPath, destAbsPath);
        }
        return var3_8;
    }

    public Resource move(String srcAbsPath, String destAbsPath) throws PersistenceException {
        return this.move(srcAbsPath, destAbsPath, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resource move(@NotNull String srcAbsPath, @NotNull String destParentAbsPath, @Nullable String destChildName, @Nullable String order) throws PersistenceException {
        void var5_11;
        Resource source = this.getResource(srcAbsPath);
        Resource destParent = this.getResource(destParentAbsPath);
        if (source instanceof RemoteResource && destParent instanceof RemoteResource) {
            String name;
            String string = name = StringUtils.isNotBlank((CharSequence)destChildName) ? destChildName : source.getName();
            if (destParent.getChild(name) != null && !StringUtils.isNotBlank((CharSequence)order)) throw new PersistenceException("a resource with the designated name exsits already at destination");
            RemoteResource remoteResource = new RemoteResource((RemoteResource)source, destParent.getPath() + "/" + name);
            this.changeSet.addMove(remoteResource, (Resource)(destParent.getChild(name) == null ? this._discard((RemoteResource)source) : source), order);
            return var5_11;
        } else if (this.parentDelegate instanceof ExtendedResolver) {
            Resource resource = ((ExtendedResolver)this.parentDelegate).move(srcAbsPath, destParentAbsPath, destChildName, order);
            return var5_11;
        } else {
            Resource resource = this.parentDelegate.move(srcAbsPath, destParentAbsPath);
        }
        return var5_11;
    }

    @Override
    public Resource upload(@NotNull String absPath, @NotNull InputStream content, @Nullable String filename, @Nullable String mimeType, @Nullable String charset) throws PersistenceException {
        Resource parent;
        Object resource = this.getResource(absPath);
        if (resource != null && resource.getName().equals("jcr:content") && "nt:resource".equals(resource.getValueMap().get((Object)"jcr:primaryType")) && (parent = resource.getParent()) != null && "nt:file".equals(parent.getValueMap().get((Object)"jcr:primaryType"))) {
            resource = parent;
        }
        if (resource instanceof RemoteResource || resource == null && this.provider.isLocal(absPath)) {
            if (resource == null) {
                resource = new RemoteResource(this, absPath);
            }
            this.changeSet.addUpload((RemoteResource)((Object)resource), content, filename, mimeType, charset);
        } else if (this.parentDelegate instanceof ExtendedResolver) {
            resource = ((ExtendedResolver)this.parentDelegate).upload(absPath, content, filename, mimeType, charset);
        } else {
            throw new PersistenceException("can't handle upload for resources out of the resolvers scope");
        }
        return resource;
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        if (type == Session.class) {
            return (AdapterType)this.parentDelegate.adaptTo(type);
        }
        return null;
    }
}

