/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.remote.RemoteProvider;
import com.composum.sling.nodes.mount.remote.RemoteReader;
import com.composum.sling.nodes.mount.remote.RemoteResource;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWriter {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteWriter.class);
    protected final RemoteProvider provider;
    public static final String POST_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final Set<String> VALUE_TYPES = new HashSet<String>(Arrays.asList("Boolean", "Date", "Decimal", "Double", "Long"));

    public RemoteWriter(@NotNull RemoteProvider provider) {
        this.provider = provider;
    }

    public boolean commitChanges(@NotNull ChangeSet changeSet) throws IOException {
        return changeSet.commit(this);
    }

    public boolean postForm(@NotNull ResourceChange change, @Nullable String path, @NotNull Parameters parameters) {
        boolean changesMade = false;
        if (parameters.size() > 0) {
            EntityBuilder entityBuilder = EntityBuilder.create();
            entityBuilder.setContentEncoding("UTF-8");
            entityBuilder.setParameters((List)parameters);
            this.postEntity(change, path, entityBuilder.build());
            changesMade = true;
        }
        return changesMade;
    }

    public boolean postMultipart(@NotNull ResourceChange change, @Nullable String path, @NotNull Map<String, ContentBody> parts, @NotNull Parameters parameters) {
        boolean changesMade = false;
        if (parts.size() > 0 || parameters.size() > 0) {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (Map.Entry<String, ContentBody> part : parts.entrySet()) {
                entityBuilder.addPart(part.getKey(), part.getValue());
            }
            for (NameValuePair param : parameters) {
                entityBuilder.addTextBody(param.getName(), param.getValue());
            }
            this.postEntity(change, path, entityBuilder.build());
            changesMade = true;
        }
        return changesMade;
    }

    public void postEntity(@NotNull ResourceChange change, @Nullable String path, @NotNull HttpEntity httpEntity) {
        try {
            String url = this.provider.remoteClient.getHttpUrl(path != null ? path : change.resource.path);
            HttpPost httpPost = this.provider.remoteClient.buildHttpPost(url);
            httpPost.setEntity(httpEntity);
            HttpResponse response = this.provider.remoteClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                LOG.debug((Object)((Object)change.getChangeType()) + ".POST({}): {}", (Object)httpPost.getURI(), (Object)statusCode);
            } else {
                LOG.warn((Object)((Object)change.getChangeType()) + ".POST({}): {}", (Object)httpPost.getURI(), (Object)statusCode);
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void buildForm(@NotNull RemoteResource resource, @NotNull Map<String, ContentBody> parts, @NotNull Parameters parameters) {
        ModifiableValueMap modified = resource.modifiedValues;
        if (modified != null) {
            String key;
            HashSet<String> scanned = new HashSet<String>();
            ValueMap origin = resource.getValueMap();
            for (Map.Entry entry : modified.entrySet()) {
                key = (String)entry.getKey();
                Object value = entry.getValue();
                Object read = origin.get((Object)key);
                if (value != null) {
                    if (!value.equals(read)) {
                        this.addFormValue(parts, parameters, key, value);
                    }
                } else if (read != null) {
                    parameters.add(key + "@Delete", "null");
                }
                scanned.add(key);
            }
            for (Map.Entry entry : origin.entrySet()) {
                key = (String)entry.getKey();
                if (scanned.contains(key)) continue;
                parameters.add(key + "@Delete", "removed");
            }
        }
    }

    protected void addFormValue(@NotNull Map<String, ContentBody> parts, @NotNull Parameters parameters, @NotNull String name, @NotNull Object value) {
        if (value instanceof InputStream) {
            if (!(value instanceof RemoteReader.RemoteBinary)) {
                parts.put(name, (ContentBody)new InputStreamBody((InputStream)value, name));
            }
        } else if (value instanceof Object[]) {
            String propertyType = null;
            for (Object item : (Object[])value) {
                ParameterValue itemValue = new ParameterValue(item);
                if (propertyType == null) {
                    propertyType = itemValue.propertyType;
                } else if (itemValue.propertyType != null && !propertyType.equals(itemValue.propertyType)) {
                    throw new IllegalArgumentException("various multi value entry types in '" + name + "' (" + propertyType + " / " + itemValue.propertyType + ")");
                }
                parameters.add(name, itemValue.value);
            }
            if (propertyType != null) {
                parameters.add(name + "@TypeHint", propertyType + "[]");
            }
        } else {
            ParameterValue parameterValue = new ParameterValue(value);
            parameters.add(name, parameterValue.value);
            if (VALUE_TYPES.contains(parameterValue.propertyType)) {
                parameters.add(name + "@TypeHint", parameterValue.propertyType);
            }
        }
    }

    protected class ParameterValue {
        @Nullable
        public final String propertyType;
        @Nullable
        public final String value;

        public ParameterValue(Object value) {
            Integer type = null;
            if (value != null) {
                String simpleName = value.getClass().getSimpleName();
                if (value instanceof String) {
                    type = 1;
                } else if (value instanceof Long || value instanceof Integer) {
                    type = 3;
                } else if (value instanceof Calendar || value instanceof Date) {
                    type = 5;
                    Date date = value instanceof Calendar ? ((Calendar)value).getTime() : (Date)value;
                    value = new SimpleDateFormat(RemoteWriter.POST_DATE_FORMAT).format(date);
                } else {
                    type = value instanceof Double || value instanceof Float ? Integer.valueOf(4) : (value instanceof BigDecimal ? Integer.valueOf(12) : Integer.valueOf(1));
                }
            }
            this.propertyType = type != null ? PropertyType.nameFromValue((int)type) : null;
            this.value = value != null ? value.toString() : null;
        }
    }

    public static class ResourceModify
    extends ResourceChange {
        public ResourceModify(@NotNull RemoteResource resource) {
            super(resource);
            if (LOG.isDebugEnabled()) {
                LOG.debug("modify({})...", (Object)resource.getPath());
            }
        }

        @Override
        @NotNull
        public ChangeType getChangeType() {
            return ChangeType.modify;
        }

        @Override
        protected boolean commit(@NotNull RemoteWriter writer) throws IOException {
            return this.commit(writer, new Parameters());
        }

        protected boolean commit(RemoteWriter writer, Parameters parameters) throws IOException {
            LinkedHashMap<String, ContentBody> parts = new LinkedHashMap<String, ContentBody>();
            writer.buildForm(this.resource, parts, parameters);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)((Object)this.getChangeType()) + "({}): parts:{}, parameters:{}", new Object[]{this.resource.getPath(), parts.size(), parameters});
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)((Object)this.getChangeType()) + "({}): parts:{}, parameters:{}", new Object[]{this.resource.getPath(), parts.size(), parameters.size()});
            }
            boolean changesMade = parts.size() > 0 ? writer.postMultipart(this, null, parts, parameters) : writer.postForm(this, null, parameters);
            return changesMade;
        }
    }

    public static class ResourceCreate
    extends ResourceModify {
        public ResourceCreate(@NotNull RemoteResource resource) {
            super(resource);
            if (LOG.isDebugEnabled()) {
                LOG.debug("create({})...", (Object)resource.getPath());
            }
        }

        @Override
        @NotNull
        public ChangeType getChangeType() {
            return ChangeType.create;
        }
    }

    public static class ResourceUpload
    extends ResourceChange {
        public static final String JCR_DATA_PROP = "jcr:content/jcr:data";
        public static final String FILENAME_PROP = "jcr:content/filename";
        public static final String MIME_TYPE_PROP = "jcr:content/jcr:mimeType";
        public static final String LAST_MOD_PROP = "jcr:content/jcr:lastModified";
        protected final InputStream content;
        protected final String filename;
        protected final String mimeType;
        protected final String charset;

        public ResourceUpload(@NotNull RemoteResource resource, @NotNull InputStream content, @Nullable String filename, @Nullable String mimeType, @Nullable String charset) {
            super(resource);
            this.content = content;
            this.filename = filename;
            this.mimeType = mimeType;
            this.charset = charset;
            if (LOG.isDebugEnabled()) {
                LOG.debug("upload({},{})...", (Object)resource.getPath(), (Object)filename);
            }
        }

        @Override
        @NotNull
        public ChangeType getChangeType() {
            return ChangeType.upload;
        }

        @Override
        protected boolean commit(@NotNull RemoteWriter writer) throws IOException {
            String parentPath = StringUtils.substringBeforeLast((String)this.resource.getPath(), (String)"/");
            LinkedHashMap<String, ContentBody> parts = new LinkedHashMap<String, ContentBody>();
            Parameters parameters = new Parameters();
            ContentType contentType = ContentType.create((String)this.mimeType, (String)(StringUtils.isNotBlank((CharSequence)this.charset) ? this.charset : null));
            parts.put(this.resource.getName(), (ContentBody)new InputStreamBody(this.content, contentType, StringUtils.isNotBlank((CharSequence)this.filename) ? this.filename : this.resource.getName()));
            if (LOG.isInfoEnabled()) {
                LOG.info("upload({})", (Object)this.resource.getPath());
            }
            return writer.postMultipart(this, parentPath, parts, parameters);
        }
    }

    public static class ResourceDelete
    extends ResourceChange {
        public ResourceDelete(@NotNull RemoteResource resource) {
            super(resource);
            if (LOG.isDebugEnabled()) {
                LOG.debug("delete({})...", (Object)resource.getPath());
            }
        }

        @Override
        @NotNull
        public ChangeType getChangeType() {
            return ChangeType.delete;
        }

        @Override
        protected boolean commit(RemoteWriter writer) {
            Parameters parameters = new Parameters();
            parameters.add(":operation", "delete");
            if (LOG.isInfoEnabled()) {
                LOG.info("delete({})", (Object)this.resource.getPath());
            }
            return writer.postForm(this, null, parameters);
        }
    }

    public static class ResourceMove
    extends ResourceChange {
        protected final Resource source;
        protected final String order;

        public ResourceMove(@NotNull RemoteResource resource, @NotNull Resource source, @Nullable String order) {
            super(resource);
            this.source = source;
            this.order = order;
            if (LOG.isDebugEnabled()) {
                LOG.debug("move({},{})...", (Object)source.getPath(), (Object)resource.getPath());
            }
        }

        @Override
        @NotNull
        public ChangeType getChangeType() {
            return ChangeType.copy;
        }

        @Override
        protected boolean commit(RemoteWriter writer) {
            Parameters parameters = new Parameters();
            if (StringUtils.substringBeforeLast((String)this.source.getPath(), (String)"/").equals(StringUtils.substringBeforeLast((String)this.resource.getPath(), (String)"/"))) {
                if (StringUtils.isBlank((CharSequence)this.order)) {
                    return false;
                }
            } else {
                parameters.add(":operation", "move");
                parameters.add(":dest", writer.provider.remotePath(this.resource.getPath()));
            }
            if (StringUtils.isNotBlank((CharSequence)this.order)) {
                parameters.add(":order", this.order);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("move({},{})", (Object)this.source.getPath(), (Object)this.resource.getPath());
            }
            return writer.postForm(this, this.source.getPath(), parameters);
        }
    }

    public static class ResourceCopy
    extends ResourceChange {
        protected final Resource source;

        public ResourceCopy(@NotNull RemoteResource resource, @NotNull Resource source) {
            super(resource);
            this.source = source;
            if (LOG.isDebugEnabled()) {
                LOG.debug("copy({},{})...", (Object)source.getPath(), (Object)resource.getPath());
            }
        }

        @Override
        @NotNull
        public ChangeType getChangeType() {
            return ChangeType.copy;
        }

        @Override
        protected boolean commit(RemoteWriter writer) {
            Parameters parameters = new Parameters();
            parameters.add(":operation", "copy");
            parameters.add(":dest", writer.provider.remotePath(this.resource.getPath()));
            if (LOG.isInfoEnabled()) {
                LOG.info("copy({},{})", (Object)this.source.getPath(), (Object)this.resource.getPath());
            }
            return writer.postForm(this, this.source.getPath(), parameters);
        }
    }

    public static class Parameters
    extends ArrayList<NameValuePair> {
        public void add(String name, String value) {
            this.add(new BasicNameValuePair(name, value));
        }
    }

    public static class ChangeSet
    extends LinkedHashMap<String, ResourceChange> {
        public void addModify(@NotNull RemoteResource resource) {
            String path = resource.getPath();
            ResourceChange change = (ResourceChange)this.get(path);
            if (change == null) {
                this.put(path, new ResourceModify(resource));
            } else if (change.resource != resource) {
                resource.modifiedValues = change.resource.modifiedValues;
            }
        }

        public void addCreate(@NotNull RemoteResource resource) {
            this.put(resource.getPath(), new ResourceCreate(resource));
        }

        public void addUpload(@NotNull RemoteResource resource, @NotNull InputStream content, @Nullable String filename, @Nullable String mimeType, @Nullable String charset) {
            this.put(resource.getPath(), new ResourceUpload(resource, content, filename, mimeType, charset));
        }

        public void addDelete(@NotNull RemoteResource resource) {
            this.put(resource.getPath(), new ResourceDelete(resource));
        }

        public void addCopy(@NotNull RemoteResource designated, @NotNull Resource source) {
            this.put(designated.getPath(), new ResourceCopy(designated, source));
        }

        public void addMove(@NotNull RemoteResource designated, @NotNull Resource source, @Nullable String order) {
            this.put(designated.getPath(), new ResourceMove(designated, source, order));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean commit(@NotNull RemoteWriter writer) throws IOException {
            boolean changesMade = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("commit({})...", (Object)this.size());
            }
            try {
                for (ResourceChange change : this.values()) {
                    changesMade = change.commit(writer) || changesMade;
                }
            }
            finally {
                this.clear();
            }
            return changesMade;
        }
    }

    public static abstract class ResourceChange {
        public final RemoteResource resource;

        protected ResourceChange(RemoteResource resource) {
            this.resource = resource;
        }

        @NotNull
        public abstract ChangeType getChangeType();

        protected abstract boolean commit(RemoteWriter var1) throws IOException;
    }

    static enum ChangeType {
        modify,
        create,
        upload,
        copy,
        move,
        delete;

    }
}

