/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.query;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import com.composum.sling.nodes.query.ConfigItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigSet<Item extends ConfigItem>
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigSet.class);
    public static final String SERVICE_KEY = "nodes/query/configuration";
    public static final String PROP_GROUP = "group";
    public static final String DEFAULT_GROUP = "General";
    private transient Map<String, List<Item>> items;

    public ConfigSet(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public ConfigSet(BeanContext context) {
        super(context);
    }

    public ConfigSet() {
    }

    protected abstract String getSetResourceType();

    protected abstract ResourceFilter getItemFilter();

    protected abstract Item createItem(Resource var1);

    public Set<Map.Entry<String, List<Item>>> getGroups() {
        return this.getItems().entrySet();
    }

    public Map<String, List<Item>> getItems() {
        if (this.items == null) {
            this.items = new TreeMap<String, List<Item>>();
            ResourceResolver resolver = this.getResolver();
            for (String path : resolver.getSearchPath()) {
                this.findItems(this.items, "/jcr:root" + path + "/*[@sling:resourceType='" + this.getSetResourceType() + "']");
            }
            for (List list : this.items.values()) {
                Collections.sort(list);
            }
        }
        return this.items;
    }

    protected void findItems(Map<String, List<Item>> consoles, String query) {
        ResourceResolver resolver = this.getResolver();
        ResourceFilter filter = this.getItemFilter();
        Iterator templateResources = resolver.findResources(query, "xpath");
        if (templateResources != null) {
            while (templateResources.hasNext()) {
                Resource templateContent = (Resource)templateResources.next();
                for (Resource item : templateContent.getChildren()) {
                    if (!filter.accept(item)) continue;
                    ResourceHandle handle = ResourceHandle.use((Resource)item);
                    String groupName = (String)handle.getProperty(PROP_GROUP, (Object)DEFAULT_GROUP);
                    List<Item> group = this.items.get(groupName);
                    if (group == null) {
                        group = new ArrayList<Item>();
                        this.items.put(groupName, group);
                    }
                    group.add(this.createItem((Resource)handle));
                }
            }
        }
    }
}

