/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.query;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.query.ConfigItem;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

@Restricted(key="nodes/query/configuration")
public class ExportCfg
extends ConfigItem {
    public static final String PROP_FILENAME = "filename";
    public static final String PROP_SELECTORS = "selectors";
    public static final String PROP_EXPORT_TYPE = "exportType";
    public static final String PROP_QUERY = "query";
    public static final String PROP_FILTER = "filter";
    public static final String PROP_SEPARATOR = "separator";
    public static final String PROP_PROPERTIES = "properties";

    public ExportCfg(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public ExportCfg(BeanContext context) {
        super(context);
    }

    public ExportCfg() {
    }

    public String getFilename() {
        return (String)this.getProperty(PROP_FILENAME, RequestUtil.getParameter((SlingHttpServletRequest)this.getRequest(), (String)PROP_FILENAME, (String)""));
    }

    public String getSelectors() {
        String selectors = (String)this.getProperty(PROP_SELECTORS, RequestUtil.getParameter((SlingHttpServletRequest)this.getRequest(), (String)PROP_SELECTORS, (String)""));
        if (StringUtils.isNotBlank((CharSequence)selectors) && !selectors.startsWith(".")) {
            selectors = "." + selectors;
        }
        return selectors;
    }

    public String getExportType() {
        return (String)this.getProperty(PROP_EXPORT_TYPE, "");
    }

    public String getQuery() {
        return Base64.encodeBase64String((byte[])XSS.filter((String)this.request.getParameter(PROP_QUERY)).getBytes(StandardCharsets.UTF_8));
    }

    public String getFilter() {
        return (String)this.getProperty(PROP_FILTER, RequestUtil.getParameter((SlingHttpServletRequest)this.getRequest(), (String)PROP_FILTER, (String)""));
    }

    public String getSeparator() {
        return (String)this.getProperty(PROP_SEPARATOR, RequestUtil.getParameter((SlingHttpServletRequest)this.getRequest(), (String)PROP_SEPARATOR, (String)((String)this.getProperty("character", ""))));
    }

    public String getProperties() {
        String propertySet;
        Object[] properties = (String[])this.getProperty(PROP_PROPERTIES, String[].class);
        if (properties == null && StringUtils.isNotBlank((CharSequence)(propertySet = XSS.filter((String)this.request.getParameter(PROP_PROPERTIES))))) {
            properties = StringUtils.split((String)propertySet, (char)',');
        }
        return properties != null ? StringUtils.join((Object[])properties, (char)',') : "";
    }
}

