/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.scene;

import com.composum.sling.core.ResourceHandle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneConfigurations
implements Serializable {
    public static final String SA_INSTANCE = SceneConfigurations.class.getName() + "#instance";
    public static final String RT_SCENE_CONFIG_SET = "composum/nodes/console/scene";
    public static final String ORDER = "order";
    public static final String PROP_ID = "id";
    public static final String PROP_KEY = "key";
    public static final String PROP_URI = "uri";
    public static final String PROP_DISABLED = "disabled";
    public static final String PROP_TEMPLATE = "template";
    public static final String PROP_SCENES_ROOT = "scenesRoot";
    public static final String PROP_PLACEHOLDER = "placeholder";
    public static final String QUERY_BASE = "/jcr:root";
    public static final String QUERY_RULE = "/*[@sling:resourceType='composum/nodes/console/scene']";
    private final TreeMap<String, Config> sceneConfigs = new TreeMap();

    @NotNull
    public static SceneConfigurations instance(@NotNull SlingHttpServletRequest request) {
        SceneConfigurations instance = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            try {
                instance = (SceneConfigurations)session.getAttribute(SA_INSTANCE);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (instance == null) {
            instance = new SceneConfigurations(request.getResourceResolver());
            if (session != null) {
                session.setAttribute(SA_INSTANCE, (Object)instance);
            }
        }
        return instance;
    }

    @Nullable
    public Config getSceneConfig(String name) {
        return this.sceneConfigs.get(name);
    }

    @NotNull
    public Collection<Config> getSceneConfigs() {
        return this.sceneConfigs.values();
    }

    public SceneConfigurations(@NotNull ResourceResolver resolver) {
        for (String path : resolver.getSearchPath()) {
            this.findSceneConfigs(this.sceneConfigs, resolver, QUERY_BASE + path + QUERY_RULE);
        }
        for (String key : new ArrayList<String>(this.sceneConfigs.keySet())) {
            if (!this.sceneConfigs.get(key).isDisabled()) continue;
            this.sceneConfigs.remove(key);
        }
    }

    protected void findSceneConfigs(@NotNull TreeMap<String, Config> pageConfigs, @NotNull ResourceResolver resolver, @NotNull String query) {
        Iterator pageConfigResources = resolver.findResources(query, "xpath");
        while (pageConfigResources.hasNext()) {
            Config pageConfig = new Config(ResourceHandle.use((Resource)((Resource)pageConfigResources.next())));
            if (pageConfigs.containsKey(pageConfig.getKey())) continue;
            pageConfigs.put(pageConfig.getKey(), pageConfig);
        }
    }

    public class Config
    implements Serializable {
        private final String path;
        private final String key;
        private final boolean disabled;
        private final String scenesRoot;
        private final String placeholder;
        private final Map<String, Tool> tools;

        public Config(ResourceHandle handle) {
            this.key = (String)handle.getProperty(SceneConfigurations.PROP_KEY, (Object)handle.getName());
            this.path = handle.getPath();
            this.disabled = (Boolean)handle.getProperty(SceneConfigurations.PROP_DISABLED, (Object)Boolean.FALSE);
            this.scenesRoot = (String)handle.getProperty(SceneConfigurations.PROP_SCENES_ROOT, String.class);
            this.placeholder = (String)handle.getProperty(SceneConfigurations.PROP_PLACEHOLDER, String.class);
            this.tools = new LinkedHashMap<String, Tool>();
            for (Resource child : handle.getChildren()) {
                Tool tool = new Tool(ResourceHandle.use((Resource)child));
                this.tools.put(tool.getName(), tool);
            }
        }

        public String getPath() {
            return this.path;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public String getScenesRoot() {
            return this.scenesRoot;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public Tool getTool(String id) {
            return this.tools.get(id);
        }

        public Collection<Tool> getTools() {
            return this.tools.values();
        }

        public class Tool {
            private final String name;
            private final String uri;
            private final String label;
            private final String description;

            public Tool(ResourceHandle handle) {
                this.name = handle.getName();
                this.uri = (String)handle.getProperty(SceneConfigurations.PROP_URI, (Object)"");
                this.label = handle.getTitle();
                this.description = (String)handle.getProperty("jcr:description", (Object)"");
            }

            public String getName() {
                return this.name;
            }

            public String getUri() {
                return this.uri;
            }

            public String getLabel() {
                return this.label;
            }

            public String getDescription() {
                return this.description;
            }
        }
    }
}

