/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.service;

import java.util.HashMap;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.ServiceReference;

public interface ServletRegistry {
    public static final String[] SERVLET_KEY_PROPERTIES = new String[]{"sling.core.servletName", "sling.servlet.resourceTypes", "sling.servlet.paths"};

    @Nullable
    public ServletData getServletData(@NotNull String var1);

    @NotNull
    public static String getServletKey(@NotNull ServiceReference<Servlet> reference) {
        for (String propertyKey : SERVLET_KEY_PROPERTIES) {
            Object servletKey = reference.getProperty(propertyKey);
            if (!(servletKey instanceof String) || !StringUtils.isNotBlank((CharSequence)((String)servletKey))) continue;
            return (String)servletKey;
        }
        return ((String[])reference.getProperty("objectClass"))[0];
    }

    public static class ServletData {
        protected final String servletKey;
        protected final ValueMap properties = new ValueMapDecorator(new HashMap());

        public ServletData(@NotNull ServiceReference<Servlet> reference) {
            this.servletKey = ServletRegistry.getServletKey(reference);
            for (String key : reference.getPropertyKeys()) {
                this.properties.put((Object)key, reference.getProperty(key));
            }
        }

        @NotNull
        public Set<String> getProperyKeys() {
            return this.properties.keySet();
        }

        @NotNull
        public <T> T getPropery(@NotNull String key, @NotNull T defaultValue) {
            return (T)this.properties.get(key, defaultValue);
        }

        @Nullable
        public <T> T getPropery(@NotNull String key, @NotNull Class<T> type) {
            return (T)this.properties.get(key, type);
        }

        @NotNull
        public String getServletKey() {
            return this.servletKey;
        }
    }
}

