/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.service.impl;

import com.composum.sling.nodes.service.ServletRegistry;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class NodesServletRegistry
implements ServletRegistry {
    protected final HashMap<String, ServletRegistry.ServletData> registeredServlets = new HashMap();

    @Reference(service=Servlet.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void bindServlet(ServiceReference<Servlet> reference) {
        ServletRegistry.ServletData servletData = new ServletRegistry.ServletData(reference);
        this.registeredServlets.put(servletData.getServletKey(), servletData);
    }

    protected void unbindServlet(ServiceReference<Servlet> reference) {
        String servletKey = ServletRegistry.getServletKey(reference);
        this.registeredServlets.remove(servletKey);
    }

    @Override
    @Nullable
    public ServletRegistry.ServletData getServletData(@NotNull String servletKey) {
        return this.registeredServlets.get(servletKey);
    }
}

