/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.RequestBundle;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.TagFilteringWriter;
import com.composum.sling.core.util.ValueEmbeddingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Composum Servlet Resource Type", "sling.servlet.methods=GET", "sling.servlet.methods=POST"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class ServletResourceType
extends GenericServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ServletResourceType.class);
    public static final String SERVLET_LABEL = "Composum Servlet Resource Type";
    public static final String WEBCONSOLE_TYPE = "org.apache.felix.inventory.impl.WebConsolePlugin";
    @Reference
    private CoreConfiguration coreConfig;
    @Reference
    private ServiceRestrictions serviceRestrictions;
    @Reference
    private DynamicClassLoaderManager classLoaderManager;
    @Reference
    private ServletResolver servletResolver;
    private ComponentContext context;
    private Config config;
    private ServiceRestrictions.Key permissionKey;
    private ServletWrapper forwardServlet;

    @Activate
    protected void activate(ComponentContext context, Config config) {
        this.context = context;
        this.config = config;
        this.permissionKey = new ServiceRestrictions.Key(config.forward_servlet_permission());
    }

    protected boolean isEnabled(@NotNull SlingHttpServletRequest request, @NotNull ServiceRestrictions.Permission needed) {
        return this.permissionKey.isEmpty() || this.serviceRestrictions.isPermissible(request, this.permissionKey, needed);
    }

    protected ServletWrapper wrapServlet(@NotNull BundleContext bundleContext, @NotNull ServiceReference<Servlet> reference) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            properties.put(key, reference.getProperty(key));
        }
        return this.wrapServlet((Servlet)bundleContext.getService(reference), properties);
    }

    protected ServletWrapper wrapServlet(@NotNull Servlet servlet, @NotNull Map<String, Object> properties) {
        return this.config.webconsole_plugin() ? new WebconsoleWrapper(servlet, properties) : new ServletWrapper(servlet);
    }

    public void service(@NotNull ServletRequest servletRequest, @NotNull ServletResponse response) throws ServletException, IOException {
        if (servletRequest instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)servletRequest;
            if (this.isEnabled(request, ServiceRestrictions.Permission.read)) {
                ServletWrapper forward = this.getForwardServlet();
                if (forward != null) {
                    forward.service((HttpServletRequest)servletRequest, (HttpServletResponse)response);
                } else {
                    ((HttpServletResponse)response).sendError(503);
                }
            } else {
                ((HttpServletResponse)response).sendError(406);
            }
        } else {
            ((HttpServletResponse)response).sendError(502);
        }
    }

    private ServletWrapper getForwardServlet() {
        if (this.forwardServlet == null) {
            try {
                String serviceTypeName = this.config.forward_servlet_serviceType();
                String serviceFilter = this.config.forward_servlet_serviceFilter();
                Class<?> serviceType = this.getType(serviceTypeName);
                BundleContext bundleContext = this.context.getBundleContext();
                Collection candidates = bundleContext.getServiceReferences(Servlet.class, StringUtils.isNotBlank((CharSequence)serviceFilter) ? serviceFilter : null);
                if (candidates.size() == 1) {
                    this.forwardServlet = this.wrapServlet(bundleContext, (ServiceReference<Servlet>)((ServiceReference)candidates.iterator().next()));
                } else if (StringUtils.isNotBlank((CharSequence)serviceTypeName)) {
                    for (ServiceReference candidate : candidates) {
                        Servlet servlet = (Servlet)bundleContext.getService(candidate);
                        if (serviceType != null) {
                            if (!serviceType.isInstance(servlet)) continue;
                            this.forwardServlet = this.wrapServlet(servlet, new HashMap<String, Object>());
                            break;
                        }
                        if (servlet == null || !serviceTypeName.equals(servlet.getClass().getName())) continue;
                        this.forwardServlet = this.wrapServlet(servlet, new HashMap<String, Object>());
                        break;
                    }
                }
                if (this.forwardServlet == null) {
                    LOG.error("no matching service found for '{}'", (Object)serviceTypeName);
                }
            }
            catch (InvalidSyntaxException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.forwardServlet;
    }

    private Class<?> getType(@Nullable String className) {
        try {
            if (StringUtils.isNotBlank((CharSequence)className)) {
                return this.classLoaderManager.getDynamicClassLoader().loadClass(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected class WebconsoleWrapper
    extends ServletWrapper {
        public static final String PLUGIN_CATEGORY = "felix.webconsole.category";
        public static final String PLUGIN_LABEL = "felix.webconsole.label";
        public static final String PLUGIN_TITLE = "felix.webconsole.title";
        public static final String PLUGIN_CSS_REFERENCES = "felix.webconsole.css";
        public static final String ATTR_APP_ROOT = "felix.webconsole.appRoot";
        public static final String ATTR_PLUGIN_ROOT = "felix.webconsole.pluginRoot";
        public static final String ATTR_LABEL_MAP = "felix.webconsole.labelMap";
        public static final String WEBCONSOLE_CLASS = "org.apache.felix.webconsole.internal.servlet.OsgiManager";
        public static final String ATTR_LABEL_MAP_OLD = "org.apache.felix.webconsole.internal.servlet.OsgiManager.appRoot";
        public static final String ATTR_APP_ROOT_OLD = "org.apache.felix.webconsole.internal.servlet.OsgiManager.labelMap";
        public static final String WEBCONSOLE_PATH = "/system/console";
        public static final String PLUGIN_TOOL_PATH = "composum/nodes/system/tools/webconsole/plugin";
        public final String[] CSS_FILES;
        public final String[] JS_FILES;
        public final String[] CSRF_OPTIONS;
        protected final ValueMap properties;
        protected final String[] cssReferences;

        public WebconsoleWrapper(@NotNull Servlet servlet, Map<String, Object> properties) {
            super(servlet);
            this.CSS_FILES = new String[]{"/css/reset-min.css", "/css/jquery-ui.css", "/css/webconsole.css", "/css/admin_compat.css", "/css/corrections.css"};
            this.JS_FILES = new String[]{"/js/jquery-3.3.1.js", "/js/jquery-migrate-3.0.0.js", "/js/jquery-ui-1.12.1.js", "/js/jquery-ui-i18n-1.12.1.js", "/js/jquery.cookies-2.2.0.js", "/js/jquery.tablesorter-2.0.3.js", "/js/autosize.min.js", "/js/support.js"};
            this.CSRF_OPTIONS = new String[]{"/etc/clientlibs/granite/jquery/granite/csrf/source/granite.http.externalize.js", "/etc/clientlibs/granite/jquery/granite/csrf/source/csrf.js", "/libs/clientlibs/granite/jquery/granite/csrf/source/granite.http.externalize.js", "/libs/clientlibs/granite/jquery/granite/csrf/source/csrf.js"};
            this.properties = new ValueMapDecorator(properties);
            this.cssReferences = PropertiesUtil.toStringArray((Object)properties.get(PLUGIN_CSS_REFERENCES));
        }

        @Override
        public void service(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) throws ServletException, IOException {
            if ("GET".equalsIgnoreCase(request.getMethod())) {
                this.renderPlugin(request, response);
            } else {
                if (request instanceof SlingHttpServletRequest && ServletResourceType.this.isEnabled((SlingHttpServletRequest)request, ServiceRestrictions.Permission.write)) {
                    ActionResponseWrapper responseWrapper = new ActionResponseWrapper(response);
                    super.service(request, (HttpServletResponse)responseWrapper);
                }
                this.renderPlugin(request, response);
            }
        }

        protected void renderPlugin(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) throws ServletException, IOException {
            SlingHttpServletRequest slingRequest;
            RequestPathInfo pathInfo;
            String suffix;
            if (request instanceof SlingHttpServletRequest && StringUtils.isNotBlank((CharSequence)(suffix = (pathInfo = (slingRequest = (SlingHttpServletRequest)request).getRequestPathInfo()).getSuffix()))) {
                SuffixRequest requestWrapper = new SuffixRequest(slingRequest, WEBCONSOLE_PATH + suffix);
                super.service((HttpServletRequest)requestWrapper, response);
                return;
            }
            ValueMapDecorator values = new ValueMapDecorator(new HashMap(this.properties));
            String category = (String)values.get(PLUGIN_CATEGORY, (Object)"generic");
            String label = (String)values.get(PLUGIN_LABEL, (Object)"generic");
            String cssClass = "webconsole-" + category.toLowerCase() + "-" + label.toLowerCase();
            String title = ServletResourceType.this.config.webconsole_plugin_title();
            Map<String, String> labelMap = Collections.singletonMap(label, StringUtils.isNotBlank((CharSequence)title) ? title : label);
            String appPath = ServletResourceType.this.config.webconsole_app_path();
            if (StringUtils.isBlank((CharSequence)appPath)) {
                appPath = request.getContextPath() + request.getPathInfo();
            }
            String appRoot = appPath.startsWith(WEBCONSOLE_PATH) ? WEBCONSOLE_PATH : appPath;
            request.setAttribute(ATTR_LABEL_MAP, labelMap);
            request.setAttribute(ATTR_APP_ROOT, (Object)appRoot);
            request.setAttribute(ATTR_PLUGIN_ROOT, (Object)appPath);
            values.put((Object)ATTR_LABEL_MAP, labelMap);
            values.put((Object)ATTR_APP_ROOT, (Object)appRoot);
            values.put((Object)ATTR_PLUGIN_ROOT, (Object)appPath);
            request.setAttribute(ATTR_LABEL_MAP_OLD, labelMap);
            request.setAttribute(ATTR_APP_ROOT_OLD, (Object)WEBCONSOLE_PATH);
            values.put((Object)ATTR_LABEL_MAP_OLD, labelMap);
            values.put((Object)ATTR_APP_ROOT_OLD, (Object)WEBCONSOLE_PATH);
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n    <title>").append(title).append("</title>\n");
            for (String cssFile : this.CSS_FILES) {
                this.appendCssLink(request, writer, ServletResourceType.this.coreConfig.getComposumBase() + PLUGIN_TOOL_PATH, cssFile);
            }
            if (this.cssReferences != null) {
                for (String cssRef : this.cssReferences) {
                    this.appendCssLink(request, writer, appRoot, cssRef.startsWith("/") ? cssRef : "/" + cssRef);
                }
            }
            writer.append("    <script type=\"text/javascript\">\n        // <![CDATA[\n        appRoot = \"").append(appRoot).append("\";\n        pluginRoot = \"").append(appPath).append("\";\n        // ]]>\n    </script>\n");
            for (String jsFile : this.JS_FILES) {
                this.appendJsLink(request, writer, jsFile);
            }
            this.appendCsrfLinks(request, writer);
            writer.append("</head>\n<body class=\"ui-widget webconsole-plugin\">\n<div id=\"main\" class=\"").append(cssClass).append("\">\n");
            if (StringUtils.isNotBlank((CharSequence)title)) {
                writer.append("    <h2 id=\"title\" class=\"webconsole-plugin_title\">").append(title).append("</h2>\n");
            }
            writer.append("    <div id=\"content\" class=\"webconsole-plugin_content\">\n");
            ServletResponseWrapper responseWrapper = new ServletResponseWrapper(request, response, (Map<String, Object>)values);
            super.service(request, (HttpServletResponse)responseWrapper);
            responseWrapper.flush();
            writer.append("    </div>\n</div>\n</body>\n");
        }

        protected void appendCssLink(@NotNull HttpServletRequest request, @NotNull PrintWriter writer, @NotNull String root, @NotNull String path) {
            writer.append("    <link href=\"").append(request.getContextPath()).append(root).append(path).append("\" rel=\"stylesheet\" type=\"text/css\">\n");
        }

        protected void appendJsLink(@NotNull HttpServletRequest request, @NotNull PrintWriter writer, @NotNull String path) {
            writer.append("    <script src=\"").append(request.getContextPath()).append(ServletResourceType.this.coreConfig.getComposumBase()).append(PLUGIN_TOOL_PATH).append(path).append("\" type=\"text/javascript\"></script>\n");
        }

        protected void appendCsrfLinks(@NotNull HttpServletRequest request, @NotNull PrintWriter writer) {
            if (request instanceof SlingHttpServletRequest) {
                SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
                ResourceResolver resolver = slingRequest.getResourceResolver();
                for (String path : this.CSRF_OPTIONS) {
                    Resource resource = resolver.getResource(path);
                    if (resource == null) continue;
                    writer.append("    <script src=\"").append(request.getContextPath()).append(path).append("\" type=\"text/javascript\"></script>\n");
                }
            }
        }

        protected class ActionResponseWrapper
        extends HttpServletResponseWrapper {
            protected ServletOutputStream outputStream;
            protected PrintWriter writer;

            public ActionResponseWrapper(HttpServletResponse response) {
                super(response);
                this.outputStream = new ServletOutputStream(){

                    public void write(int b) {
                    }
                };
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8));
            }

            public ServletOutputStream getOutputStream() {
                return this.outputStream;
            }

            public PrintWriter getWriter() throws IOException {
                return this.writer;
            }
        }
    }

    protected class ServletWrapper {
        protected final Servlet wrappedServlet;

        public ServletWrapper(Servlet servlet) {
            this.wrappedServlet = servlet;
        }

        public void service(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) throws ServletException, IOException {
            this.wrappedServlet.service((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected class ServletResponseWrapper
    extends HttpServletResponseWrapper {
        protected final PrintWriter wrappedWriter;
        protected final ValueEmbeddingWriter valuesWriter;
        protected final Writer transformingWriter;
        protected final PrintWriter printWriter;

        public ServletResponseWrapper(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, Map<String, Object> values) throws IOException {
            super(response);
            Locale locale = request.getLocale();
            RequestBundle i18n = ServletResourceType.this.config.content_translation_on() && request instanceof SlingHttpServletRequest ? RequestBundle.get((SlingHttpServletRequest)((SlingHttpServletRequest)request)) : null;
            this.wrappedWriter = response.getWriter();
            this.valuesWriter = new ValueEmbeddingWriter((Writer)this.wrappedWriter, values, locale, ((Object)((Object)this)).getClass(), (ResourceBundle)i18n);
            this.transformingWriter = ServletResourceType.this.config.content_filter_on() ? new TagFilteringWriter((Writer)this.valuesWriter) : this.valuesWriter;
            this.printWriter = new PrintWriter(this.transformingWriter);
        }

        public PrintWriter getWriter() {
            return this.printWriter;
        }

        public void flush() {
            try {
                this.printWriter.flush();
                this.transformingWriter.flush();
                this.wrappedWriter.flush();
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected class SuffixRequest
    extends SlingHttpServletRequestWrapper {
        protected final String suffix;

        public SuffixRequest(@NotNull SlingHttpServletRequest request, String suffix) {
            super(request);
            this.suffix = suffix;
        }

        public String getPathInfo() {
            return this.suffix;
        }

        public String getRequestURI() {
            return this.suffix;
        }
    }

    @ObjectClassDefinition(name="Composum Servlet Resource Type")
    public static @interface Config {
        @AttributeDefinition(name="Resource Type", description="the resource type which has to be mapped to the servlet")
        public String sling_servlet_resourceTypes();

        @AttributeDefinition(name="Service Type", description="the full qualified service type (class name) to forward to")
        public String forward_servlet_serviceType();

        @AttributeDefinition(name="Service Filter", description="the filter options to find the designated service (webconsole plugin)")
        public String forward_servlet_serviceFilter();

        @AttributeDefinition(name="Permission", description="the necessary permission to use this service")
        public String forward_servlet_permission();

        @AttributeDefinition(name="Webconsole Plugin", description="marks a servlet as a Webconsole plugin implementation")
        public boolean webconsole_plugin() default false;

        @AttributeDefinition(name="Webconsole Plugin Title", description="the title of the rendered Webconsole plugin view")
        public String webconsole_plugin_title() default "";

        @AttributeDefinition(name="Webconsole App Path", description="the path (URI) to use during Webconsole plugin rendering")
        public String webconsole_app_path() default "";

        @AttributeDefinition(name="Filter Content", description="if selected the generated HTML is filtered")
        public boolean content_filter_on() default false;

        @AttributeDefinition(name="Translation", description="if selected all placeholders are used for translations if not a value")
        public boolean content_translation_on() default false;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "'{sling.servlet.resourceTypes}' > '{forward.servlet.serviceType}' [{forward.servlet.serviceFilter}]";
    }
}

