/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.servlet.SourceModel;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Restricted(key="nodes/repository/source")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Source Servlet", "sling.servlet.paths=/bin/cpm/nodes/source", "sling.servlet.methods=GET", "sling.servlet.extensions=xml", "sling.servlet.extensions=zip", "sling.servlet.extensions=pkg", "sling.auth.requirements=/bin/cpm/nodes/source"})
public class SourceServlet
extends SlingSafeMethodsServlet
implements RestrictedService {
    public static final String SERVLET_PATH = "/bin/cpm/nodes/source";
    public static final String SERVICE_KEY = "nodes/repository/source";
    @Reference
    private ServiceRestrictions restrictions;
    @Reference
    protected NodesConfiguration nodesConfig;
    protected BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key(SERVICE_KEY);
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        if (this.restrictions.isPermissible(request, this.getServiceKey(), ServiceRestrictions.Permission.read)) {
            Resource resource = null;
            RequestPathInfo pathInfo = request.getRequestPathInfo();
            String resourcePath = XSS.filter((String)pathInfo.getSuffix());
            if (StringUtils.isNotBlank((CharSequence)resourcePath)) {
                ResourceResolver resolver = request.getResourceResolver();
                resource = resolver.getResource(resourcePath);
            }
            if (resource != null && !ResourceUtil.isNonExistingResource(resource)) {
                try {
                    SourceModel sourceModel = new SourceModel(this.nodesConfig, (BeanContext)new BeanContext.Servlet(this.getServletContext(), this.bundleContext, request, response), resource);
                    String name = resource.getName();
                    switch ((String)StringUtils.defaultIfBlank((CharSequence)pathInfo.getExtension(), (CharSequence)"")) {
                        case "xml": {
                            response.setCharacterEncoding("UTF-8");
                            response.setContentType("text/plain;charset=UTF-8");
                            response.setHeader("Content-Disposition", "inline; filename=.content.xml");
                            sourceModel.writeXmlFile(response.getWriter(), true);
                            break;
                        }
                        case "zip": {
                            if (!name.endsWith(".zip")) {
                                name = name + ".zip";
                            }
                            response.setContentType("application/octet-stream");
                            response.setHeader("Content-Disposition", "inline; filename=" + name);
                            sourceModel.writeArchive((OutputStream)response.getOutputStream());
                            break;
                        }
                        case "pkg": {
                            String group = "source";
                            if (name.endsWith(".zip")) {
                                name = name.substring(0, name.length() - 4);
                            }
                            name = name + "-source-package";
                            String version = "current";
                            response.setContentType("application/octet-stream");
                            response.setHeader("Content-Disposition", "inline; filename=" + name + "-" + version + ".zip");
                            sourceModel.writePackage((OutputStream)response.getOutputStream(), group, name, version);
                            break;
                        }
                        default: {
                            response.sendError(400);
                            break;
                        }
                    }
                }
                catch (RepositoryException ex) {
                    throw new ServletException((Throwable)ex);
                }
            } else {
                response.sendError(404);
            }
        } else {
            response.sendError(405);
        }
    }
}

