/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.update.SourceUpdateService;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/repository/source")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Source Update Servlet", "sling.servlet.paths=/bin/cpm/nodes/sourceupload", "sling.servlet.methods=POST", "sling.servlet.extensions=zip", "sling.auth.requirements=/bin/cpm/nodes/sourceupload"})
public class SourceUpdateServlet
extends SlingAllMethodsServlet
implements RestrictedService {
    public static final String SERVLET_PATH = "/bin/cpm/nodes/sourceupload";
    private static final Logger LOG = LoggerFactory.getLogger(SourceUpdateServlet.class);
    @Reference
    private ServiceRestrictions restrictions;
    @Reference
    protected NodesConfiguration nodesConfig;
    @Reference
    protected SourceUpdateService sourceUpdateService;
    protected BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key("nodes/repository/source");
    }

    /*
     * Unable to fully structure code
     */
    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        block14: {
            block13: {
                if (!this.restrictions.isPermissible(request, this.getServiceKey(), ServiceRestrictions.Permission.write)) break block13;
                parameters = request.getRequestParameterMap();
                file = parameters.getValue("file");
                pathInfo = request.getRequestPathInfo();
                try {
                    var6_6 = (String)StringUtils.defaultIfBlank((CharSequence)pathInfo.getExtension(), (CharSequence)"");
                    var7_8 = -1;
                    switch (var6_6.hashCode()) {
                        case 120609: {
                            if (!var6_6.equals("zip")) break;
                            var7_8 = 0;
                        }
                    }
                    switch (var7_8) {
                        case 0: {
                            if (file == null) break;
                            inputStream = file.getInputStream();
                            try {
                                if (inputStream == null) ** GOTO lbl31
                                this.sourceUpdateService.updateFromZip(request.getResourceResolver(), inputStream, XSS.filter((String)pathInfo.getSuffix()));
                                response.setStatus(204);
                                if (inputStream == null) ** GOTO lbl30
                            }
                            catch (Throwable var9_10) {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable var10_11) {
                                        var9_10.addSuppressed(var10_11);
                                    }
                                }
                                throw var9_10;
                            }
                            inputStream.close();
lbl30:
                            // 2 sources

                            return;
lbl31:
                            // 1 sources

                            if (inputStream == null) break;
                            inputStream.close();
                            break;
                        }
                    }
                    response.sendError(400);
                }
                catch (IOException | RuntimeException | RepositoryException | TransformerException ex) {
                    SourceUpdateServlet.LOG.error("Trouble during update: {}", (Object)ex, (Object)ex);
                    response.sendError(500);
                }
                break block14;
            }
            response.sendError(503);
        }
    }
}

