/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.tools;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.nodes.tools.OsgiServiceModel;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.settings.SlingSettingsService;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Tools Bundles Servlet", "sling.servlet.resourceTypes=composum/nodes/system/tools/runtime/settings", "sling.servlet.methods=GET", "sling.servlet.extensions=json"})
public class SettingsServlet
extends SlingSafeMethodsServlet
implements RestrictedService {
    public static final String RESOURCE_TYPE = "composum/nodes/system/tools/runtime/settings";
    public static final String SERVICE_KEY = "system/runtime/settings";
    public static final String HTTP_SERVICE = "org.osgi.service.http.HttpService";
    @Reference
    protected SlingSettingsService slingSettingsService;
    @Reference
    protected ServiceRestrictions restrictions;
    private ServiceRestrictions.Permission permission;
    private boolean enabled = false;
    protected BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.permission = this.restrictions.getPermission(this.getServiceKey());
        this.enabled = this.permission != ServiceRestrictions.Permission.none;
    }

    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key(SERVICE_KEY);
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        if (this.enabled) {
            BeanContext.Servlet context = new BeanContext.Servlet(this.getServletContext(), this.bundleContext, request, response);
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginArray();
            String[] selectors = request.getRequestPathInfo().getSelectors();
            switch (selectors.length > 0 ? selectors[0] : "") {
                case "sling": {
                    this.writeProperties(writer, this.slingSettings());
                    break;
                }
                case "http": {
                    this.writeProperties(writer, this.httpSettings());
                    break;
                }
                default: {
                    this.writeProperties(writer, this.systemSettings());
                }
            }
            writer.endArray();
        } else {
            response.sendError(403);
        }
    }

    protected Map<String, Object> slingSettings() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("Id", this.slingSettingsService.getSlingId());
        values.put("Name", this.slingSettingsService.getSlingName());
        values.put("Description", this.slingSettingsService.getSlingDescription());
        values.put("Home", this.slingSettingsService.getSlingHome());
        values.put("Home Path", this.slingSettingsService.getSlingHomePath());
        values.put("Run Modes", this.slingSettingsService.getRunModes());
        return values;
    }

    protected Map<String, Object> httpSettings() {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        ServiceReference reference = this.bundleContext.getServiceReference(HTTP_SERVICE);
        if (reference != null) {
            OsgiServiceModel service = new OsgiServiceModel(reference);
            values.put("Service Id", service.getServiceId());
            values.put("Service Pid", service.getServicePid());
            values.put("Bundle Id", service.getBundleId());
            values.put("Component Id", service.getComponentId());
            values.put("Component Name", service.getComponentName());
            values.put("Description", service.getDescription());
            values.put("Object Class", service.getObjectClass());
            values.putAll(service.getProperties());
        }
        return values;
    }

    protected Map<String, Object> systemSettings() {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            values.put(entry.getKey().toString(), entry.getValue());
        }
        return values;
    }

    protected void writeProperties(@NotNull JsonWriter writer, @NotNull Map<String, Object> values) throws IOException {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            List<String> value = entry.getValue();
            if (value == null) continue;
            writer.beginObject();
            writer.name("key").value(entry.getKey());
            writer.name("value").value((value instanceof String[] ? Arrays.asList((String[])value) : value).toString());
            writer.endObject();
        }
    }
}

