/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes;

import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.mapping.jcr.ResourceFilterMapping;
import com.composum.sling.nodes.NodesConfiguration;
import java.util.Dictionary;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={NodesConfiguration.class}, property={"service.description=Composum Nodes (Console) Configuration"}, immediate=true)
@Designate(ocd=Configuration.class)
public class NodesConfigImpl
implements NodesConfiguration {
    private volatile Configuration config;
    private volatile ResourceFilter pageNodeFilter;
    private volatile ResourceFilter defaultNodeFilter;
    private volatile ResourceFilter treeIntermediateFilter;
    private volatile ResourceFilter referenceableNodesFilter;
    private volatile ResourceFilter orderableNodesFilter;
    private volatile ResourceFilter sourceNodesFilter;
    private volatile ResourceFilter sourceFolderFilter;
    private volatile ResourceFilter sourceXmlFilter;
    private volatile boolean sourceAdvancedSortAttributes;
    protected volatile Dictionary<String, Object> properties;

    @NotNull
    private Configuration getConfig() {
        return Objects.requireNonNull(this.config, "NodesConfigImpl is not active");
    }

    @Override
    public boolean checkConsoleAccess() {
        return this.getConfig().console_access_check();
    }

    @Override
    @NotNull
    public String[] getConsoleCategories() {
        return this.getConfig().console_categories();
    }

    @Override
    public long getQueryResultLimit() {
        return this.getConfig().query_result_limit();
    }

    @Override
    @NotNull
    public ResourceFilter getPageNodeFilter() {
        return this.pageNodeFilter;
    }

    @Override
    @NotNull
    public ResourceFilter getDefaultNodeFilter() {
        return this.defaultNodeFilter;
    }

    @Override
    @NotNull
    public ResourceFilter getTreeIntermediateFilter() {
        return this.treeIntermediateFilter;
    }

    @Override
    @NotNull
    public ResourceFilter getReferenceableNodesFilter() {
        return this.referenceableNodesFilter;
    }

    @Override
    @NotNull
    public ResourceFilter getOrderableNodesFilter() {
        return this.orderableNodesFilter;
    }

    @Override
    @NotNull
    public ResourceFilter getSourceNodesFilter() {
        return this.sourceNodesFilter;
    }

    @Override
    @NotNull
    public ResourceFilter getSourceFolderNodesFilter() {
        return this.sourceFolderFilter;
    }

    @Override
    @NotNull
    public ResourceFilter getSourceXmlNodesFilter() {
        return this.sourceXmlFilter;
    }

    @Override
    public boolean isSourceAdvancedSortAttributes() {
        return this.sourceAdvancedSortAttributes;
    }

    @Override
    @NotNull
    public String getScenesContentRoot() {
        return this.getConfig().scene_content_root();
    }

    @Override
    @NotNull
    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    @Activate
    @Modified
    public void activate(ComponentContext context, Configuration configuration) {
        this.config = configuration;
        this.properties = context.getProperties();
        this.pageNodeFilter = ResourceFilterMapping.fromString((String)configuration.node_page_filter());
        this.defaultNodeFilter = ResourceFilterMapping.fromString((String)configuration.node_default_filter());
        this.treeIntermediateFilter = ResourceFilterMapping.fromString((String)configuration.tree_intermediate_filter());
        this.referenceableNodesFilter = ResourceFilterMapping.fromString((String)configuration.node_referenceable_filter());
        this.orderableNodesFilter = ResourceFilterMapping.fromString((String)configuration.node_orderable_filter());
        this.sourceNodesFilter = ResourceFilterMapping.fromString((String)configuration.node_source_filter());
        this.sourceFolderFilter = ResourceFilterMapping.fromString((String)configuration.node_source_folder_filter());
        this.sourceXmlFilter = ResourceFilterMapping.fromString((String)configuration.node_source_xml_filter());
        this.sourceAdvancedSortAttributes = configuration.node_source_advanced_attributesort();
    }

    @Deactivate
    protected void deactivate() {
        this.properties = null;
        this.config = null;
        this.pageNodeFilter = null;
        this.defaultNodeFilter = null;
        this.treeIntermediateFilter = null;
        this.referenceableNodesFilter = null;
        this.orderableNodesFilter = null;
        this.sourceNodesFilter = null;
    }

    @ObjectClassDefinition(name="Composum Nodes (Console) Configuration", description="the configuration service for all servlets in the nodes bundles")
    public static @interface Configuration {
        @AttributeDefinition(name="Check Console Access", description="if 'true' (checked) the access to the console pages is checked on servlet access")
        public boolean console_access_check() default true;

        @AttributeDefinition(name="Console Categories", description="the list of categories to determine the views in the core console")
        public String[] console_categories() default {"core", "system", "nodes", "users"};

        @AttributeDefinition(name="Query Result Limit", description="the maximum node count for query results (default: 500)")
        public long query_result_limit() default 500L;

        @AttributeDefinition(name="Content Page Filter", description="the filter configuration to set the scope to the content pages")
        public String node_page_filter() default "or{ResourceType(+'^[a-z]+:.*([Ss]ite|[Pp]age)$'),and{PrimaryType(+'^nt:file$'),MimeType(+'^text/html$')}}";

        @AttributeDefinition(name="The default Node Filter", description="the filter configuration to filter out system nodes")
        public String node_default_filter() default "and{Name(-'^rep:(repo)?[Pp]olicy$'),Path(-'^/(api|bin|services|servlet)(/.*)?$,^/[^/]+\\.servlet(/.*)?$,^/(jcr:)?system(/.*)?$'),Property(servletClass!)}";

        @AttributeDefinition(name="Tree Intermediate (Folder) Filter", description="the filter configuration to determine all intermediate nodes in the tree view")
        public String tree_intermediate_filter() default "or{Folder(),PrimaryType(+'^dam:Asset(Content)?$')}";

        @AttributeDefinition(name="Referenceable Nodes Filter", description="the filter configuration to select reference target nodes")
        public String node_referenceable_filter() default "Type(mix:referenceable)";

        @AttributeDefinition(name="Orderable Nodes Filter", description="the filter configuration to detect ordered nodes (prevent from sorting in the tree)")
        public String node_orderable_filter() default "and{or{Type(node:orderable),PrimaryType(+'^.*([Oo]rdered|[Pp]age).*$,^sling:(Mapping)$,^nt:(unstructured|frozenNode)$,^rep:(ACL|Members|system)$')},PrimaryType(-'^rep:root$')}";

        @AttributeDefinition(name="XML Source Nodes Filter", description="the filter configuration for the source export of the repository content (Source Servlet) that limits which nodes are exported")
        public String node_source_filter() default "PrimaryType(-'^cpp:(Statistics)$,^rep:(.+)$')";

        @AttributeDefinition(name="XML Source Folder Filter", description="the filter configuration for the source export of the repository content (Source Servlet) that determines which nodes are exported as folder")
        public String node_source_folder_filter() default "or{NodeType(+'^nt:hierarchyNode$,^vlt:HierarchyNode$'),Name(+'^cq:dialog$,^cq:htmlTag$,^cq:template$,^cq:design_dialog$,^cq:childEditConfig$')}";

        @AttributeDefinition(name="XML Source Folder Filter", description="the filter configuration for the source export of the repository content (Source Servlet) that determines which nodes are exported as separate XML file (aka vlt:FullCoverage)")
        public String node_source_xml_filter() default "NodeType(+'^vlt:FullCoverage$,^mix:language$,^rep:AccessControl$,^rep:Policy$,^cq:EditConfig$,^cq:WorkflowModel$,^sling:OsgiConfig$')";

        @AttributeDefinition(name="XML Source Advanced Attribute Sort", description="the filter configuration for the source export of the repository content (Source Servlet) that determines whether the attributes are sorted by importance (jcr:primaryType, jcr:mixins, sling:* and then the rest")
        public boolean node_source_advanced_attributesort() default true;

        @AttributeDefinition(name="Scenes Content Root", description="the root path of the scenes content nodes")
        public String scene_content_root() default "/var/composum/nodes/scenes";
    }
}

