/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.ai.impl;

import com.composum.sling.nodes.ai.AIService;
import com.composum.sling.nodes.ai.impl.RateLimiter;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="Composum Nodes AI Service", property={"service.description=AI services based on ChatGPT"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
@Designate(ocd=Configuration.class)
public class AIServiceImpl
implements AIService {
    public static final String SERVICE_NAME = "Composum Nodes AI Service";
    protected static final Logger LOG = LoggerFactory.getLogger(AIServiceImpl.class);
    public static final String DEFAULT_MODEL = "gpt-4-turbo-preview";
    protected static final String CHAT_COMPLETION_URL = "https://api.openai.com/v1/chat/completions";
    protected Configuration config;
    protected String apiKey;
    protected RateLimiter rateLimiter;
    protected Gson gson = new Gson();
    protected CloseableHttpClient httpClient;
    protected String chatURL;
    protected String apiKeyHeader;
    protected String additionalHeader;
    protected String additionalHeaderValue;

    @Override
    public boolean isAvailable() {
        return this.config != null && !this.config.disabled() && StringUtils.isNotBlank((CharSequence)this.apiKey);
    }

    protected boolean isAnthropicClaude() {
        return this.chatURL != null && this.chatURL.contains("api.anthropic.com");
    }

    @Override
    @Nonnull
    public String prompt(@Nullable String systemmsg, @Nonnull String usermsg, @Nullable AIService.ResponseFormat responseFormat) throws AIService.AIServiceException {
        String string;
        block17: {
            if (!this.isAvailable()) {
                throw new AIService.AIServiceNotAvailableException();
            }
            LinkedHashMap<String, String> userMessage = new LinkedHashMap<String, String>();
            userMessage.put("role", "user");
            userMessage.put("content", usermsg);
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("model", StringUtils.defaultIfBlank((CharSequence)this.config.defaultModel(), (CharSequence)DEFAULT_MODEL));
            if (systemmsg != null && this.isAnthropicClaude()) {
                request.put("system", systemmsg);
                request.put("messages", Arrays.asList(userMessage));
            } else if (systemmsg != null) {
                LinkedHashMap<String, String> systemMessage = new LinkedHashMap<String, String>();
                systemMessage.put("role", "system");
                systemMessage.put("content", systemmsg);
                request.put("messages", Arrays.asList(systemMessage, userMessage));
            } else {
                request.put("messages", Arrays.asList(userMessage));
            }
            request.put("temperature", 0);
            if (this.config.maxTokens() > 0) {
                request.put("max_tokens", this.config.maxTokens());
            }
            if (responseFormat == AIService.ResponseFormat.JSON && !this.isAnthropicClaude()) {
                LinkedHashMap<String, String> responseFormatMap = new LinkedHashMap<String, String>();
                responseFormatMap.put("type", "json_object");
                request.put("response_format", responseFormatMap);
            }
            String requestJson = this.gson.toJson(request);
            this.rateLimiter.waitForLimit();
            HttpPost postRequest = new HttpPost(this.chatURL);
            EntityBuilder entityBuilder = EntityBuilder.create();
            entityBuilder.setContentType(ContentType.APPLICATION_JSON);
            entityBuilder.setContentEncoding("UTF-8");
            entityBuilder.setText(requestJson);
            postRequest.setEntity(entityBuilder.build());
            if (this.apiKeyHeader != null) {
                String[] headerSplitted = this.apiKeyHeader.split("\\s");
                String headername = headerSplitted[0];
                String prefix = headerSplitted.length > 1 ? headerSplitted[1].trim() + " " : "";
                postRequest.setHeader(headername, prefix + this.apiKey);
            }
            if (this.additionalHeader != null && this.additionalHeaderValue != null) {
                postRequest.setHeader(this.additionalHeader, this.additionalHeaderValue);
            }
            String id = "#" + System.nanoTime();
            LOG.debug("Request {} to OpenAI: {}", (Object)id, (Object)requestJson);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            try {
                string = this.retrieveMessage(id, response);
                if (response == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("" + e, (Throwable)e);
                    throw new AIService.AIServiceException("Exception accessing the AI: " + e, e);
                }
            }
            response.close();
        }
        return string;
    }

    @Nonnull
    protected String retrieveMessage(String id, CloseableHttpResponse response) throws AIService.AIServiceException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity responseEntity = response.getEntity();
        if (statusCode != 200) {
            String errorbody = responseEntity != null ? responseEntity.toString() : "";
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            responseEntity.writeTo((OutputStream)bytes);
            if (bytes.size() > 0) {
                errorbody = errorbody + "\n" + new String(bytes.toByteArray(), Charsets.UTF_8);
            }
            throw new AIService.AIServiceException("Error from AI backend: " + response.getStatusLine() + " " + errorbody);
        }
        String responseJson = EntityUtils.toString((HttpEntity)responseEntity);
        LOG.debug("Response {} from OpenAI: {}", (Object)id, (Object)responseJson);
        return this.extractText(responseJson);
    }

    @NotNull
    protected String extractText(String responseJson) throws AIService.AIServiceException {
        String text;
        Map responseMap = (Map)this.gson.fromJson(responseJson, Map.class);
        if (responseMap.containsKey("choices")) {
            List choices = (List)responseMap.get("choices");
            Map choice = (Map)choices.get(0);
            String finish_reason = (String)choice.get("finish_reason");
            if (!"stop".equals(finish_reason)) {
                throw new AIService.AIServiceException("Finish reason is not stop: " + finish_reason + " in response: " + responseJson);
            }
            Map message = MapUtils.emptyIfNull((Map)((Map)choice.get("message")));
            text = (String)message.get("content");
        } else if (responseMap.containsKey("content")) {
            List content = (List)responseMap.get("content");
            Map message = (Map)content.get(0);
            text = (String)message.get("text");
        } else {
            LOG.error("Response format not recognized: {}", (Object)responseJson);
            throw new AIService.AIServiceException("Response format not recognized: " + responseJson);
        }
        if (text == null) {
            LOG.error("No message in response: {}", (Object)responseJson);
            throw new AIService.AIServiceException("No message in response: " + responseJson);
        }
        return text;
    }

    @Deactivate
    protected void deactivate() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                LOG.error("Could not close httpClient", (Throwable)e);
            }
        }
        this.config = null;
    }

    @Activate
    @Modified
    protected void activate(Configuration configuration) {
        this.config = configuration;
        this.chatURL = ((String)StringUtils.defaultIfBlank((CharSequence)this.config.chatCompletionUrl(), (CharSequence)CHAT_COMPLETION_URL)).trim();
        String envVariable = this.isAnthropicClaude() ? "ANTHROPIC_API_KEY" : "OPENAI_API_KEY";
        this.apiKey = (String)StringUtils.defaultIfBlank((CharSequence)this.config.openAiApiKey(), (CharSequence)System.getenv(envVariable));
        this.apiKey = (String)StringUtils.defaultIfBlank((CharSequence)this.apiKey, (CharSequence)System.getProperty("openai.api.key"));
        if (this.config.openAiApiKeyFile() != null && !this.config.openAiApiKeyFile().isEmpty()) {
            try {
                this.apiKey = (String)StringUtils.defaultIfBlank((CharSequence)this.apiKey, (CharSequence)FileUtils.readFileToString((File)new File(this.config.openAiApiKeyFile()), (Charset)Charsets.UTF_8));
            }
            catch (IOException e) {
                LOG.error("Could not read OpenAI key from {}", (Object)this.config.openAiApiKeyFile(), (Object)e);
            }
        }
        this.apiKey = StringUtils.trimToNull((String)this.apiKey);
        this.additionalHeader = StringUtils.trimToNull((String)this.config.additionalHeader());
        this.additionalHeaderValue = StringUtils.trimToNull((String)this.config.additionalHeaderValue());
        this.apiKeyHeader = (String)StringUtils.defaultIfBlank((CharSequence)this.config.apiKeyHeader(), (CharSequence)"Authorization Bearer");
        this.rateLimiter = null;
        if (this.isAvailable()) {
            int perMinuteLimit = this.config.requestsPerMinuteLimit() > 0 ? this.config.requestsPerMinuteLimit() : 20;
            this.rateLimiter = new RateLimiter(null, perMinuteLimit, 1, TimeUnit.MINUTES);
            int requestsPerHourLimit = this.config.requestsPerHourLimit() > 0 ? this.config.requestsPerHourLimit() : 60;
            this.rateLimiter = new RateLimiter(this.rateLimiter, requestsPerHourLimit, 1, TimeUnit.HOURS);
            int requestsPerDayLimit = this.config.requestsPerDayLimit() > 0 ? this.config.requestsPerDayLimit() : 120;
            this.rateLimiter = new RateLimiter(this.rateLimiter, requestsPerDayLimit, 1, TimeUnit.DAYS);
            this.httpClient = HttpClientBuilder.create().build();
        }
    }

    @ObjectClassDefinition(name="Composum Nodes AI Service Configuration", description="AI services based on ChatGPT")
    public static @interface Configuration {
        @AttributeDefinition(name="Disable the GPT Chat Completion Service", description="Disable the GPT Chat Completion Service", defaultValue={"false"})
        public boolean disabled() default false;

        @AttributeDefinition(name="Chat Completion URL", description="The URL for chat completions. If not given, the default for OpenAI is used: https://api.openai.com/v1/chat/completions . In the case of Anthropic Claude it is https://api.anthropic.com/v1/messages.")
        public String chatCompletionUrl();

        @AttributeDefinition(name="API key", description="Key for requests to AI backend, in the case of OpenAI from https://platform.openai.com/api-keys. If not given, we check the key file, the environment Variable OPENAI_API_KEY (or in the case of Anthropic Claude ANTHROPIC_API_KEY), and the system property openai.api.key .")
        public String openAiApiKey();

        @AttributeDefinition(name="API key file", description="File containing the API key, as an alternative to API key configuration and the variants described there.")
        public String openAiApiKeyFile();

        @AttributeDefinition(name="Header for API key", description="The header in the request that is used for sending the API key. If it's two words like 'Authorization Bearer' then that second word is used as prefix for the value. Default: 'Authorization Bearer', as used by OpenAI.")
        public String apiKeyHeader();

        @AttributeDefinition(name="Additional Header", description="Optionally, an additional header. In the cause of OpenAI that could be 'OpenAI-Organization'. In the case of Anthropic Claude it could be 'anthropic-version'.")
        public String additionalHeader();

        @AttributeDefinition(name="Additional Header Value", description="The value for the additional header. In the case of OpenAI that could be the organization id. In the case of Anthropic Claude it could be the version of the API, e.g. '2023-06-01'.")
        public String additionalHeaderValue();

        @AttributeDefinition(name="Default model", description="Default model to use for the chat completion. If not configured we take a default, in this version gpt-4-turbo-preview. Please consider the varying prices https://openai.com/pricing or whatever service you use. For programming related questions a GPT-4 / Claude Opus seems necessary, though. Do not configure if not necessary, to follow further changes.")
        public String defaultModel();

        @AttributeDefinition(name="Requests per minute", description="The number of requests per minute - after half of that we do slow down. >0, the default is 100.")
        public int requestsPerMinuteLimit() default 20;

        @AttributeDefinition(name="Requests per hour", description="The number of requests per hour - after half of that we do slow down. >0, the default is 1000.")
        public int requestsPerHourLimit() default 60;

        @AttributeDefinition(name="Requests per day", description="The number of requests per day - after half of that we do slow down. >0, the default is 12000.")
        public int requestsPerDayLimit() default 120;

        @AttributeDefinition(name="Maximum number of tokens", description="Maximum number of tokens in the response. >0, the default is 2048.")
        public int maxTokens() default 2048;
    }
}

