/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.ai.impl;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimiter.class);
    @Nullable
    private final RateLimiter parent;
    @Nonnegative
    private final int limit;
    @Nonnegative
    private final int period;
    @Nonnull
    private final TimeUnit timeUnit;
    private final long periodDurationMillis;
    private int requestCount;
    private long nextResetTime;
    protected static final Pattern PATTERN_LIMIT_ERROR = Pattern.compile("Limit: (\\d+) / min.");

    public RateLimiter(@Nullable RateLimiter parent, @Nonnegative int limit, @Nonnegative int period, @Nonnull TimeUnit timeUnit) {
        this.parent = parent;
        this.limit = limit;
        this.period = period;
        this.timeUnit = timeUnit;
        this.periodDurationMillis = timeUnit.toMillis(period);
    }

    public synchronized void waitForLimit() {
        long now;
        if (this.parent != null) {
            this.parent.waitForLimit();
        }
        if ((now = this.getCurrentTimeMillis()) >= this.nextResetTime) {
            this.requestCount = 1;
            this.nextResetTime = now + this.periodDurationMillis;
        } else {
            ++this.requestCount;
            if (this.requestCount > this.limit / 2) {
                long safetyTime = (long)((this.limit - this.requestCount + 1) * 2) * this.periodDurationMillis / (long)this.limit;
                long earliestRequestTime = this.nextResetTime - safetyTime;
                long delay = 0L;
                if (now < earliestRequestTime) {
                    delay = earliestRequestTime - now;
                }
                try {
                    this.sleep(delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
                now = this.getCurrentTimeMillis();
                if (now >= this.nextResetTime) {
                    this.requestCount = 1;
                    this.nextResetTime = now + this.periodDurationMillis;
                }
            }
        }
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected void sleep(long delay) throws InterruptedException {
        LOG.info("Sleeping for {} ms because of {} requests limit {} in {}", new Object[]{delay, this.requestCount, this.limit, this.period});
        Thread.sleep(delay);
    }

    @Nullable
    public static RateLimiter of(String errorbody) {
        Matcher matcher = PATTERN_LIMIT_ERROR.matcher(errorbody);
        if (matcher.find()) {
            String limitString = matcher.group(1);
            int limit = Integer.parseInt(limitString);
            LOG.info("Found limit {} per minute in errorbody", (Object)limit);
            return new RateLimiter(null, limit, 1, TimeUnit.MINUTES);
        }
        return null;
    }
}

