/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.browser;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.util.HttpUtil;
import com.composum.sling.core.util.SerializableValueMap;
import com.composum.sling.core.util.ValueEmbeddingReader;
import com.composum.sling.nodes.console.Condition;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserViews
implements HttpUtil.CachableInstance {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserViews.class);
    public static final String SA_INSTANCE = BrowserViews.class.getName() + "#instance";
    public static final String PN_ID = "id";
    public static final String PN_RANK = "rank";
    public static final int DEFAULT_RANK = 50;
    public static final String NN_PATTERN = "pattern";
    public static final String NN_TABS = "tabs";
    public static final String NN_TOOLBAR = "toolbar";
    public static final String NN_CONTENT = "content";
    public static final String PN_CONDITION = "condition";
    public static final String PN_ENABLED = "enabled";
    public static final String PN_KEY = "key";
    public static final String PN_ICON = "icon";
    public static final String PN_CSS = "css";
    public static final String PN_GROUP = "group";
    public static final String PN_LABEL = "label";
    public static final String PN_TITLE = "title";
    public static final String PN_HREF = "href";
    public static final String PN_TARGET = "target";
    public static final String PN_PLACEHOLDER = "placeholder";
    public static final String PN_DESCRIPTION = "description";
    public static final String PN_RESOURCE_TYPE = "resourceType";
    public static final String PN_TYPE = "type";
    public static final String TYPE_BUTTON = "button";
    public static final String TYPE_LINK = "link";
    public static final String TYPE_TEXT = "text";
    public static final String QUERY_BASE = "/jcr:root";
    public static final String QUERY_RULE = "/*[@sling:resourceType='composum/nodes/browser/view']";
    protected final List<View> browserViews;
    protected final long created;

    @NotNull
    public static BrowserViews getInstance(@NotNull SlingHttpServletRequest request) {
        return (BrowserViews)HttpUtil.getInstance((SlingHttpServletRequest)request, (String)SA_INSTANCE, (HttpUtil.InstanceFactory)new HttpUtil.InstanceFactory<BrowserViews>(){

            public Class<BrowserViews> getType() {
                return BrowserViews.class;
            }

            public BrowserViews newInstance(SlingHttpServletRequest request) {
                return new BrowserViews(request);
            }
        });
    }

    @Nullable
    public static View getView(@NotNull BeanContext context, @NotNull Resource resource) {
        BrowserViews instance = BrowserViews.getInstance(context.getRequest());
        for (View view : instance.browserViews) {
            if (!view.matches(context, resource)) continue;
            return view;
        }
        return null;
    }

    protected BrowserViews(@NotNull SlingHttpServletRequest request) {
        ResourceResolver resolver = request.getResourceResolver();
        HashMap<String, View> viewMap = new HashMap<String, View>();
        for (String path : resolver.getSearchPath()) {
            this.findBrowserViews(resolver, viewMap, QUERY_BASE + path + QUERY_RULE);
        }
        this.browserViews = new ArrayList(viewMap.values());
        Collections.sort(this.browserViews);
        this.created = System.currentTimeMillis();
    }

    public long getCreated() {
        return this.created;
    }

    protected void findBrowserViews(@NotNull ResourceResolver resolver, @NotNull Map<String, View> viewMap, @NotNull String query) {
        Iterator browserViewContentResources = resolver.findResources(query, "xpath");
        while (browserViewContentResources.hasNext()) {
            Resource browserViewRes = (Resource)browserViewContentResources.next();
            View browserView = new View(ResourceHandle.use((Resource)browserViewRes));
            if (viewMap.containsKey(browserView.getId())) continue;
            viewMap.put(browserView.getId(), browserView);
        }
    }

    public class View
    implements Comparable<View>,
    Serializable {
        protected final ValueMap properties;
        protected final Condition condition;
        protected final List<Tab> tabs;
        protected String tabResourceType = null;
        protected Toolbar toolbar = null;
        protected Content content = null;

        public View(ResourceHandle resource) {
            this.properties = new SerializableValueMap((Map)resource.getValueMap());
            this.condition = Condition.And.fromResource(resource.getChild(BrowserViews.NN_PATTERN));
            this.tabs = new ArrayList<Tab>();
            Resource tabs = resource.getChild(BrowserViews.NN_TABS);
            if (tabs != null) {
                for (Resource tabRes : tabs.getChildren()) {
                    Tab tab = new Tab(tabRes);
                    this.tabs.add(tab);
                    Resource child = tabRes.getChild(BrowserViews.NN_TOOLBAR);
                    if (child != null && this.toolbar == null) {
                        this.toolbar = new Toolbar(child);
                        this.tabResourceType = tab.getResourceType();
                    }
                    if ((child = tabRes.getChild(BrowserViews.NN_CONTENT)) == null || this.content != null) continue;
                    this.content = new Content(child);
                    this.tabResourceType = tab.getResourceType();
                }
            }
        }

        @Override
        public int compareTo(@NotNull View other) {
            return Integer.compare(this.getRank(), other.getRank());
        }

        public String getId() {
            return (String)this.properties.get(BrowserViews.PN_ID, (Object)"");
        }

        public int getRank() {
            return (Integer)this.properties.get(BrowserViews.PN_RANK, (Object)50);
        }

        public boolean matches(@NotNull BeanContext context, @NotNull Resource resource) {
            return this.condition == null || this.condition.accept(context, resource);
        }

        @NotNull
        public String getViewResourceType() {
            return (String)this.properties.get(BrowserViews.PN_RESOURCE_TYPE, (Object)"");
        }

        @NotNull
        public String getTabResourceType() {
            return this.tabResourceType;
        }

        @NotNull
        public List<Tab> getTabs(@NotNull BeanContext context, @NotNull Resource resource) {
            ArrayList<Tab> result = new ArrayList<Tab>();
            for (Tab tab : this.tabs) {
                if (!tab.matches(context, resource)) continue;
                result.add(tab);
            }
            return result;
        }

        @NotNull
        public Toolbar getToolbar(@NotNull BeanContext context, @NotNull Resource resource) {
            return new Toolbar(this.toolbar, context, resource);
        }

        @NotNull
        public Content getContent(@NotNull BeanContext context, @NotNull Resource resource) {
            return this.content;
        }

        public class Content
        implements Serializable {
            protected final ValueMap properties;

            public Content(Resource resource) {
                this.properties = new SerializableValueMap((Map)resource.getValueMap());
            }

            @NotNull
            public String getResourceType() {
                return (String)this.properties.get(BrowserViews.PN_RESOURCE_TYPE, (Object)"");
            }
        }

        public class Toolbar
        implements Serializable {
            protected final ValueMap properties;
            protected final ResourceContext resourceContext;
            protected final List<Group> groups = new ArrayList<Group>();

            public Toolbar(Resource resource) {
                this.properties = new SerializableValueMap((Map)resource.getValueMap());
                this.resourceContext = new ResourceContext(null);
                for (Resource child : resource.getChildren()) {
                    this.groups.add(new Group(child));
                }
            }

            protected Toolbar(@NotNull Toolbar template, @NotNull BeanContext context, Resource resource) {
                this.properties = template.properties;
                this.resourceContext = new ResourceContext(resource);
                for (Group group : template.groups) {
                    if (!group.matches(context, resource)) continue;
                    this.groups.add(new Group(group, context, resource));
                }
            }

            public Collection<Group> getGroups() {
                return this.groups;
            }

            public class Group
            implements Serializable {
                protected final ValueMap properties;
                protected final Condition condition;
                protected final List<Element> elements = new ArrayList<Element>();

                public Group(Resource resource) {
                    this.properties = new SerializableValueMap((Map)resource.getValueMap());
                    this.condition = new Condition.And((String[])this.properties.get(BrowserViews.PN_CONDITION, (Object)new String[0]));
                    for (Resource child : resource.getChildren()) {
                        this.elements.add(new Element(child));
                    }
                    if (this.elements.isEmpty()) {
                        this.elements.add(new Element(resource));
                    }
                }

                protected Group(@NotNull Group template, @NotNull BeanContext context, Resource resource) {
                    this.properties = template.properties;
                    this.condition = template.condition;
                    for (Element element : template.elements) {
                        if (!element.matches(context, resource)) continue;
                        this.elements.add(new Element(element, context, resource));
                    }
                }

                public boolean matches(@NotNull BeanContext context, @NotNull Resource resource) {
                    return this.condition.accept(context, resource);
                }

                public Collection<Element> getElements() {
                    return this.elements;
                }
            }

            public class Element
            implements Serializable {
                protected final String name;
                protected final ValueMap properties;
                protected final Condition condition;
                protected final Condition enabled;
                protected final Boolean isEnabled;

                public Element(Resource resource) {
                    this.name = resource.getName();
                    this.properties = new SerializableValueMap((Map)resource.getValueMap());
                    this.condition = new Condition.And((String[])this.properties.get(BrowserViews.PN_CONDITION, (Object)new String[0]));
                    this.enabled = new Condition.And((String[])this.properties.get(BrowserViews.PN_ENABLED, (Object)new String[0]));
                    this.isEnabled = null;
                }

                public Element(@NotNull Element template, @NotNull BeanContext context, Resource resource) {
                    this.name = template.name;
                    this.properties = template.properties;
                    this.condition = template.condition;
                    this.enabled = template.enabled;
                    this.isEnabled = this.enabled(context, resource);
                }

                public boolean matches(@NotNull BeanContext context, @NotNull Resource resource) {
                    return this.condition.accept(context, resource);
                }

                public boolean enabled(@NotNull BeanContext context, @NotNull Resource resource) {
                    return this.enabled.accept(context, resource);
                }

                public boolean isEnabled() {
                    return this.isEnabled == null || this.isEnabled != false;
                }

                public String getType() {
                    return (String)this.properties.get(BrowserViews.PN_TYPE, (Object)BrowserViews.TYPE_BUTTON);
                }

                public String getKey() {
                    return (String)this.properties.get(BrowserViews.PN_KEY, (Object)this.name);
                }

                @NotNull
                public String getIcon() {
                    return Toolbar.this.resourceContext.adjustValue((String)this.properties.get(BrowserViews.PN_ICON, (Object)""));
                }

                @NotNull
                public String getCss() {
                    return (String)this.properties.get(BrowserViews.PN_CSS, (Object)"");
                }

                @NotNull
                public String getLabel() {
                    return Toolbar.this.resourceContext.adjustValue((String)this.properties.get(BrowserViews.PN_LABEL, (Object)""));
                }

                @NotNull
                public String getTitle() {
                    return Toolbar.this.resourceContext.adjustValue((String)this.properties.get(BrowserViews.PN_TITLE, (Object)""));
                }

                @NotNull
                public String getPlaceholder() {
                    return Toolbar.this.resourceContext.adjustValue((String)this.properties.get(BrowserViews.PN_PLACEHOLDER, (Object)""));
                }

                @NotNull
                public String getHref() {
                    return Toolbar.this.resourceContext.adjustValue((String)this.properties.get(BrowserViews.PN_HREF, (Object)""));
                }

                @NotNull
                public String getTarget() {
                    return (String)this.properties.get(BrowserViews.PN_TARGET, (Object)"");
                }
            }
        }

        public class Tab {
            protected final String name;
            protected final ValueMap properties;
            protected final Condition condition;

            public Tab(Resource resource) {
                this.name = resource.getName();
                this.properties = new SerializableValueMap((Map)resource.getValueMap());
                this.condition = new Condition.And((String[])this.properties.get(BrowserViews.PN_CONDITION, (Object)new String[0]));
            }

            public boolean matches(@NotNull BeanContext context, @NotNull Resource resource) {
                return this.condition.accept(context, resource);
            }

            @NotNull
            public String getResourceType() {
                return (String)this.properties.get(BrowserViews.PN_RESOURCE_TYPE, (Object)"");
            }

            @NotNull
            public String getId() {
                return (String)this.properties.get(BrowserViews.PN_ID, (Object)this.name);
            }

            @NotNull
            public String getKey() {
                return (String)this.properties.get(BrowserViews.PN_KEY, (Object)"");
            }

            @NotNull
            public String getIcon() {
                return (String)this.properties.get(BrowserViews.PN_ICON, (Object)"");
            }

            @NotNull
            public String getCss() {
                return (String)this.properties.get(BrowserViews.PN_CSS, (Object)"");
            }

            @NotNull
            public String getGroup() {
                return (String)this.properties.get(BrowserViews.PN_GROUP, (Object)"");
            }

            @NotNull
            public String getLabel() {
                return (String)this.properties.get(BrowserViews.PN_LABEL, (Object)"");
            }

            @NotNull
            public String getTitle() {
                return (String)this.properties.get(BrowserViews.PN_TITLE, (Object)"");
            }
        }
    }

    public class ResourceContext {
        @NotNull
        protected final Map<String, Object> properties;

        public ResourceContext(Resource resource) {
            if (resource != null) {
                this.properties = new HashMap<String, Object>((Map<String, Object>)resource.getValueMap());
                this.properties.put("name", resource.getName());
                this.properties.put("path", resource.getPath());
            } else {
                this.properties = Collections.emptyMap();
            }
        }

        public String adjustValue(@NotNull String value) {
            try {
                return IOUtils.toString((Reader)new ValueEmbeddingReader((Reader)new StringReader(value), this.properties));
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                return value;
            }
        }
    }
}

