/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.components;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.nodes.console.ConsoleServletBean;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.management.ConfigurationCollectionData;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.ValueInfo;
import org.apache.sling.caconfig.management.multiplexer.ContextPathStrategyMultiplexer;
import org.apache.sling.caconfig.resource.spi.ContextResource;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/repository/resources")
public class CAConfigModel
extends ConsoleServletBean {
    private static final Logger LOG = LoggerFactory.getLogger(CAConfigModel.class);
    @Inject
    protected ConfigurationManager configurationManager;
    @Inject
    protected ContextPathStrategyMultiplexer contextPathStrategyMultiplexer;

    public CAConfigModel(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public CAConfigModel(BeanContext context) {
        super(context);
    }

    public CAConfigModel() {
    }

    @Override
    public void initialize(BeanContext context, Resource resource) {
        Resource suffixResource = null;
        SlingHttpServletRequest request = context.getRequest();
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String suffix = pathInfo.getSuffix();
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            suffixResource = request.getResourceResolver().getResource(suffix);
        }
        super.initialize(context, suffixResource != null ? suffixResource : resource);
    }

    public String getViewType() {
        try {
            if (this.getPath().startsWith("/content")) {
                return "effectiveConfigurationsView";
            }
            if (this.getPath().matches(".*/sling:configs($|/).*")) {
                String configName;
                ConfigurationMetadata metadata;
                if (this.getName().equals("sling:configs")) {
                    return "listConfigurationsView";
                }
                if (this.getResource().getParent().getName().equals("sling:configs")) {
                    String configName2 = this.getResource().getName();
                    ConfigurationMetadata metadata2 = this.configurationManager.getConfigurationMetadata(configName2);
                    if (metadata2 == null) {
                        return null;
                    }
                    if (metadata2.isCollection()) {
                        return "collectionView";
                    }
                    return "configurationView";
                }
                if (this.getResource().getParent().getParent().getName().equals("sling:configs") && (metadata = this.configurationManager.getConfigurationMetadata(configName = this.getResource().getParent().getName())).isCollection()) {
                    return "configurationView";
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error("Cannot determine view type for {}", (Object)this.getPath(), (Object)e);
        }
        return null;
    }

    public List<String> getGlobalConfigPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (String possibleDefault : new String[]{"/conf/global/sling:configs", "/apps/conf/sling:configs", "/libs/conf/sling:configs"}) {
            Resource defaultResource = this.getResolver().getResource(possibleDefault);
            if (defaultResource == null) continue;
            paths.add(possibleDefault);
        }
        return paths;
    }

    public List<ContextResource> getContextPaths() {
        List<ContextResource> contextResources = IteratorUtils.toList((Iterator)this.contextPathStrategyMultiplexer.findContextResources((Resource)this.getResource()));
        contextResources = contextResources.stream().filter(contextResource -> this.getResolver().getResource(contextResource.getConfigRef()) != null).filter(contextResource -> this.getResolver().getResource(contextResource.getConfigRef() + "/sling:configs") != null).collect(Collectors.toList());
        return contextResources;
    }

    public List<ConfigurationMetadata> getAllMetaData() {
        SortedSet names = this.configurationManager.getConfigurationNames();
        return names.stream().map(name -> this.configurationManager.getConfigurationMetadata(name)).collect(Collectors.toList());
    }

    public List<SingletonConfigInfo> getSingletonConfigurations() {
        SortedSet names = this.configurationManager.getConfigurationNames();
        List<SingletonConfigInfo> result = names.stream().filter(name -> Objects.requireNonNull(this.configurationManager.getConfigurationMetadata(name)).isSingleton()).map(name -> new SingletonConfigInfo((String)name, this.configurationManager.getConfiguration((Resource)this.resource, name))).collect(Collectors.toList());
        return result;
    }

    public List<CollectionConfigInfo> getCollectionConfigurations() {
        SortedSet names = this.configurationManager.getConfigurationNames();
        List<CollectionConfigInfo> result = names.stream().filter(name -> Objects.requireNonNull(this.configurationManager.getConfigurationMetadata(name)).isCollection()).map(name -> new CollectionConfigInfo(this.configurationManager.getConfigurationCollection((Resource)this.resource, name))).collect(Collectors.toList());
        return result;
    }

    public CollectionConfigInfo getThisCollectionConfiguration() {
        CollectionConfigInfo configInfo = this.getCollectionConfigurations().stream().filter(collectionConfigInfo -> collectionConfigInfo.getCollectionConfigData().getConfigName().equals(this.getName())).findFirst().orElse(null);
        return configInfo;
    }

    public SingletonConfigInfo getThisSingletonConfiguration() {
        ConfigurationData configurationData;
        ResourceHandle configResource;
        for (configResource = this.getResource(); configResource != null && configResource.getParent() != null && !configResource.getParent().getName().equals("sling:configs"); configResource = configResource.getParent()) {
        }
        String configName = configResource != null ? configResource.getName() : null;
        ConfigurationData configurationData2 = configurationData = configName != null ? this.configurationManager.getConfiguration((Resource)this.getResource(), configName) : null;
        if (configurationData != null) {
            return new SingletonConfigInfo(configName, configurationData);
        }
        return null;
    }

    public ValueInfo<?> getThisProperty() {
        String propertyName = this.getRequest().getParameter("propertyName");
        SingletonConfigInfo configInfo = this.getThisSingletonConfiguration();
        ValueInfo result = null;
        if (configInfo != null && propertyName != null) {
            result = configInfo.getValueInfos().stream().filter(valueInfo -> valueInfo.getPropertyMetadata() != null && valueInfo.getPropertyMetadata().getName().equals(propertyName)).findFirst().orElse(null);
        }
        return result;
    }

    public static String renderValueInfoAsString(Object valueInfo) {
        Object object = ((ValueInfo)valueInfo).getEffectiveValue();
        if (object == null) {
            return "";
        }
        if (object instanceof ConfigurationData) {
            ConfigurationData nestedData = (ConfigurationData)object;
            HashMap<String, String> stringMap = new HashMap<String, String>();
            for (String key : nestedData.getPropertyNames()) {
                ValueInfo nestedValueInfo = nestedData.getValueInfo(key);
                String nestedValueAsString = CAConfigModel.renderValueInfoAsString(nestedValueInfo);
                stringMap.put(key, nestedValueAsString);
            }
            return ((Object)stringMap).toString();
        }
        if (Object[].class.isAssignableFrom(object.getClass())) {
            StringBuilder builder = new StringBuilder();
            for (Object item : (Object[])object) {
                if (builder.length() > 0) {
                    builder.append("<br/>");
                }
                builder.append(item);
            }
            return builder.toString();
        }
        return object.toString();
    }

    public static String renderValueAsString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof ValueMap) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry entry : ((ValueMap)value).entrySet()) {
                if (((String)entry.getKey()).startsWith("jcr:")) continue;
                map.put((String)entry.getKey(), CAConfigModel.renderValueAsString(entry.getValue()));
            }
            return ((Object)map).toString();
        }
        return CAConfigModel.toJson(value);
    }

    protected static String toJson(Object value) {
        StringWriter writer = new StringWriter();
        @NotNull JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        try {
            JsonUtil.jsonValue((JsonWriter)jsonWriter, (Object)value);
        }
        catch (IOException e) {
            LOG.error("Error in converting to String: {}", value, (Object)e);
            return "(error)";
        }
        return ((Object)writer).toString();
    }

    public class PropertyInfo {
        protected final ValueInfo<?> valueInfo;
        protected final String name;
        protected final ConfigurationMetadata metadata;
        private final Class<?> type;

        public PropertyInfo(String name, ValueInfo<?> valueInfo) {
            this.name = name;
            this.metadata = CAConfigModel.this.configurationManager.getConfigurationMetadata(name);
            this.valueInfo = valueInfo;
            this.type = valueInfo != null && valueInfo.getPropertyMetadata() != null ? valueInfo.getPropertyMetadata().getType() : null;
        }

        public ValueInfo<?> getValueInfo() {
            return this.valueInfo;
        }

        public String getName() {
            return this.name;
        }

        public ConfigurationMetadata getMetadata() {
            return this.metadata;
        }

        public boolean isResourceExists() {
            return CAConfigModel.this.getResource().getChild(this.getName()) != null;
        }

        public boolean isMultiValue() {
            return this.type != null && (this.type.isArray() || Collection.class.isAssignableFrom(this.type));
        }

        public String getJsonValue() {
            ValueInfo<?> valueInfo = this.getValueInfo();
            Object value = CAConfigModel.this.getResource().getValueMap().get((Object)valueInfo.getName());
            return CAConfigModel.toJson(value);
        }

        public String getRenderedValue() {
            ValueInfo<?> valueInfo = this.getValueInfo();
            Object value = CAConfigModel.this.getResource().getValueMap().get((Object)valueInfo.getName());
            return CAConfigModel.renderValueAsString(value);
        }

        public boolean isRequired() {
            PropertyMetadata propMetadata = this.valueInfo.getPropertyMetadata();
            return propMetadata != null && propMetadata.getProperties() != null && "true".equals(propMetadata.getProperties().get("required"));
        }

        public Properties getProperties() {
            Properties props = new Properties();
            if (this.valueInfo.getPropertyMetadata() != null && this.valueInfo.getPropertyMetadata().getProperties() != null) {
                props.putAll((Map<?, ?>)this.valueInfo.getPropertyMetadata().getProperties());
                props.remove("required");
            }
            return props;
        }

        public String getPropertiesJsonEncoded() throws UnsupportedEncodingException {
            Properties props = this.getProperties();
            String propertiesJson = props != null ? CAConfigModel.toJson(this.getProperties()) : null;
            return propertiesJson != null ? URLEncoder.encode(propertiesJson, "UTF-8") : null;
        }

        public String getTypeName() {
            Map props;
            String widgetType;
            if (this.type == null) {
                return null;
            }
            if (this.valueInfo != null && this.valueInfo.getPropertyMetadata() != null && this.valueInfo.getPropertyMetadata().getProperties() != null && "pathbrowser".equals(widgetType = (String)(props = this.valueInfo.getPropertyMetadata().getProperties()).get("widgetType"))) {
                return "Path";
            }
            return this.getBasicTypeName(this.type);
        }

        protected String getBasicTypeName(Class<?> clazz) {
            if (clazz == null) {
                return null;
            }
            if (Long.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
                return "Long";
            }
            if (Double.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
                return "Double";
            }
            if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
                return "Boolean";
            }
            if (String.class.isAssignableFrom(clazz)) {
                return "String";
            }
            if (clazz.isArray()) {
                return this.getBasicTypeName(clazz.getComponentType());
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return "String";
            }
            return clazz.getName();
        }
    }

    public class SingletonConfigInfo {
        protected final ConfigurationData configurationData;
        protected final String name;
        protected final ConfigurationMetadata metadata;

        public SingletonConfigInfo(String name, ConfigurationData configurationData) {
            this.name = name;
            this.metadata = CAConfigModel.this.configurationManager.getConfigurationMetadata(name);
            this.configurationData = configurationData;
        }

        public ConfigurationData getConfigurationData() {
            return this.configurationData;
        }

        public String getName() {
            return this.name;
        }

        public ConfigurationMetadata getMetadata() {
            return this.metadata;
        }

        public boolean isResourceExists() {
            return CAConfigModel.this.getResource().getChild(this.getName()) != null;
        }

        public boolean isInherits() {
            Boolean inheritProperty = (Boolean)this.configurationData.getEffectiveValues().get("sling:configPropertyInherit", Boolean.class);
            return inheritProperty != null && inheritProperty != false;
        }

        public List<ValueInfo<?>> getValueInfos() {
            ArrayList valueInfos = new ArrayList();
            for (String propertyName : this.configurationData.getPropertyNames()) {
                if (propertyName.startsWith("jcr:") || propertyName.startsWith("sling:")) continue;
                ValueInfo valueInfo2 = this.configurationData.getValueInfo(propertyName);
                valueInfos.add(valueInfo2);
            }
            Collections.sort(valueInfos, Comparator.comparingInt(valueInfo -> valueInfo.getPropertyMetadata() != null ? valueInfo.getPropertyMetadata().getOrder() : Integer.MAX_VALUE));
            return valueInfos;
        }

        public List<PropertyInfo> getPropertyInfos() {
            return this.getValueInfos().stream().map(valueInfo -> new PropertyInfo(valueInfo.getName(), (ValueInfo<?>)valueInfo)).collect(Collectors.toList());
        }
    }

    public class CollectionConfigInfo {
        protected final ConfigurationCollectionData collectionConfigData;
        protected final ConfigurationMetadata metadata;

        public CollectionConfigInfo(ConfigurationCollectionData configurationCollection) {
            this.collectionConfigData = configurationCollection;
            this.metadata = CAConfigModel.this.configurationManager.getConfigurationMetadata(this.collectionConfigData.getConfigName());
        }

        public boolean isInherits() {
            Object inheritProperty = this.collectionConfigData.getProperties().get("sling:configCollectionInherit");
            return inheritProperty instanceof Boolean && (Boolean)inheritProperty != false;
        }

        public boolean isResourceExists() {
            return CAConfigModel.this.getResource().getChild(this.metadata.getName()) != null;
        }

        public ConfigurationCollectionData getCollectionConfigData() {
            return this.collectionConfigData;
        }

        public ConfigurationMetadata getMetadata() {
            return this.metadata;
        }

        public List<SingletonConfigInfo> getConfigs() {
            return this.collectionConfigData.getItems().stream().map(item -> new SingletonConfigInfo(this.collectionConfigData.getConfigName(), (ConfigurationData)item)).collect(Collectors.toList());
        }
    }
}

