/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.components;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.nodes.console.ConsoleServletBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;

public class MergedModel
extends ConsoleServletBean {
    public static final String METADATA_MERGED = "sling.mergedResource";
    public static final String METADATA_RESOURCES = "sling.mergedResources";
    private transient Boolean mergedResource;
    private transient List<Resource> mergedResources;
    private transient List<String> mergedPaths;

    public MergedModel(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public MergedModel(BeanContext context) {
        super(context);
    }

    public MergedModel() {
    }

    @NotNull
    public ResourceHandle getResource() {
        Resource resource = null;
        SlingHttpServletRequest request = this.context.getRequest();
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String suffix = pathInfo.getSuffix();
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            resource = request.getResourceResolver().getResource(suffix);
        }
        return resource != null ? ResourceHandle.use(resource) : super.getResource();
    }

    public static boolean isMergedResource(@NotNull Resource resource) {
        return Boolean.TRUE.equals(resource.getResourceMetadata().get((Object)METADATA_MERGED));
    }

    public boolean isMergedResource() {
        if (this.mergedResource == null) {
            this.mergedResource = MergedModel.isMergedResource((Resource)this.getResource());
        }
        return this.mergedResource;
    }

    @NotNull
    public List<Resource> getMergedResources() {
        if (this.mergedResources == null) {
            ResourceResolver resolver = this.getResolver();
            this.mergedResources = new ArrayList<Resource>();
            for (String path : this.getMergedPaths()) {
                Resource resource = resolver.getResource(path);
                if (resource == null) continue;
                this.mergedResources.add(0, resource);
            }
        }
        return this.mergedResources;
    }

    @NotNull
    public List<String> getMergedPaths() {
        if (this.mergedPaths == null) {
            String[] paths = (String[])this.getResource().getResourceMetadata().get((Object)METADATA_RESOURCES);
            this.mergedPaths = paths != null ? Arrays.asList(paths) : Collections.emptyList();
        }
        return this.mergedPaths;
    }
}

