/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.consoleplugin;

import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefWriter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Composum Nodes Nodetype Plugin", "felix.webconsole.category=Composum", "felix.webconsole.label=nodetypes", "felix.webconsole.title=Nodetypes", "felix.webconsole.css=nodetypes/slingconsole/composum/nodes/console/nodetypesplugin.css"})
public class NodetypesPlugin
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(NodetypesPlugin.class);
    protected static final String LOC_CSS = "slingconsole/composum/nodes/console/nodetypesplugin.css";
    public static final String PARAM_NAMEREGEX = "nameregex";
    @Reference
    protected ResourceResolverFactory resolverFactory;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().endsWith(LOC_CSS)) {
            response.setContentType("text/css");
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/slingconsole/composum/nodes/console/nodetypesplugin.css"), (OutputStream)response.getOutputStream());
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.print("<html><body><h2>Nodetypes</h2>");
        new NodetypesRunner(writer, request).print();
        writer.println("</body></html>");
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    protected class NodetypesRunner {
        protected final PrintWriter writer;
        protected final HttpServletRequest request;
        protected Pattern nameRegex = null;

        public NodetypesRunner(PrintWriter writer, HttpServletRequest request) {
            this.writer = writer;
            this.request = request;
            if (StringUtils.isNotBlank((CharSequence)XSS.filter((String)request.getParameter(NodetypesPlugin.PARAM_NAMEREGEX)))) {
                String nameRegexStr = XSS.filter((String)request.getParameter(NodetypesPlugin.PARAM_NAMEREGEX));
                try {
                    if (StringUtils.isNotBlank((CharSequence)nameRegexStr)) {
                        this.nameRegex = Pattern.compile(nameRegexStr);
                    }
                }
                catch (PatternSyntaxException e) {
                    writer.println("<p><strong>Regex syntax error: " + e + "</strong></p>");
                }
            }
        }

        public void print() throws ServletException {
            this.printForm();
            this.printNodetypes();
        }

        protected void printNodetypes() throws ServletException {
            this.writer.println("<pre>");
            try (ResourceResolver resolver = null;){
                resolver = NodetypesPlugin.this.resolverFactory.getResourceResolver(null);
                this.writeNodetypes((Session)resolver.adaptTo(Session.class), this.writer, this.nameRegex);
            }
            this.writer.println("</pre>");
        }

        protected void writeNodetypes(Session session, PrintWriter writer, Pattern nodetypeSelector) throws RepositoryException, IOException {
            CompactNodeTypeDefWriter cnd = new CompactNodeTypeDefWriter((Writer)writer, session, true);
            List nodetypes = IteratorUtils.toList((Iterator)session.getWorkspace().getNodeTypeManager().getAllNodeTypes());
            Collections.sort(nodetypes, Comparator.comparing(NodeTypeDefinition::getName));
            for (NodeTypeDefinition definition : nodetypes) {
                if (nodetypeSelector != null && !nodetypeSelector.matcher(definition.getName()).matches()) continue;
                cnd.write(definition);
            }
            cnd.close();
        }

        protected void printForm() {
            this.writer.println("<form action=\"" + this.request.getRequestURL() + "\" method=\"get\">");
            this.writer.println("Restrict printed nodetypes with name matching regular expression: ");
            this.writer.println(" <input type=\"text\" name=\"nameregex\" value=\"" + (this.nameRegex != null ? this.nameRegex.pattern() : "") + "\">");
            this.writer.println(" <input type=\"submit\">\n");
            this.writer.println("</form>");
        }
    }
}

