/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.remote.RemoteClientBuilder;
import com.composum.sling.nodes.mount.remote.RemoteClientSetup;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class RemoteClientSetupImpl
implements RemoteClientSetup {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteClientSetupImpl.class);
    private BundleContext bundleContext;
    private final Map<String, ClientBuilderSet> clientBuilders = new HashMap<String, ClientBuilderSet>();

    @Override
    @NotNull
    public Set<RemoteClientBuilder> getBuilders(@NotNull Collection<String> aspectKeys) {
        LinkedHashSet<RemoteClientBuilder> result = new LinkedHashSet<RemoteClientBuilder>();
        for (String key : aspectKeys) {
            RemoteClientBuilder service;
            ClientBuilderSet set;
            if (!StringUtils.isNotBlank((CharSequence)key) || (set = this.clientBuilders.get(key)) == null || set.size() <= 0 || (service = (RemoteClientBuilder)this.bundleContext.getService((ServiceReference)set.iterator().next())) == null) continue;
            result.add(service);
        }
        return result;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Reference(service=RemoteClientBuilder.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void bindRemoteClientBuilder(ServiceReference<RemoteClientBuilder> reference) {
        String aspectKey = (String)reference.getProperty("aspect.key");
        LOG.info("bindRemoteClientBuilder({}): '{}'", reference, (Object)aspectKey);
        ClientBuilderSet set = this.clientBuilders.get(aspectKey);
        if (set == null) {
            set = new ClientBuilderSet();
            this.clientBuilders.put(aspectKey, set);
        }
        set.add(reference);
    }

    protected void unbindRemoteClientBuilder(ServiceReference<RemoteClientBuilder> reference) {
        String aspectKey = (String)reference.getProperty("aspect.key");
        LOG.info("unbindRemoteClientBuilder({}): '{}'", reference, (Object)aspectKey);
        ClientBuilderSet set = this.clientBuilders.get(aspectKey);
        if (set != null) {
            set.remove(reference);
        }
    }

    protected class ClientBuilderSet
    extends TreeSet<ServiceReference<RemoteClientBuilder>> {
        public ClientBuilderSet() {
            super(new Comparator<ServiceReference<RemoteClientBuilder>>(){

                protected Integer ranking(ServiceReference<RemoteClientBuilder> reference) {
                    return (Integer)reference.getProperty("service.ranking");
                }

                @Override
                public int compare(ServiceReference<RemoteClientBuilder> o1, ServiceReference<RemoteClientBuilder> o2) {
                    return this.ranking(o2).compareTo(this.ranking(o1));
                }
            });
        }
    }
}

