/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.remote.RemoteProvider;
import com.composum.sling.nodes.mount.remote.RemoteResource;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteReader {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteReader.class);
    public static final String NS_PREFIX_JCR = "jcr";
    public static final Pattern DAV_HREF = Pattern.compile("^((https?:)?//[^/]*)?(?<path>(?<parent>(/.*)?)?/(?<name>[^/]+))(?<folder>/)?$");
    protected final RemoteProvider provider;
    public static final String DAV_NS = "dav:";
    public static final String DAV_TYPE_FOLDER = "dav:folder";
    public static final String DAV_TYPE_UNKNOWN = "dav:unknown";
    public static final Pattern STRING_TYPE_PREFIX = Pattern.compile("^\\{([^}]+)}(.*)$");
    public static final Map<String, Boolean> BOOLEAN_VALUES = new HashMap<String, Boolean>(){
        {
            this.put("true", Boolean.TRUE);
            this.put("false", Boolean.FALSE);
            this.put("on", Boolean.TRUE);
            this.put("off", Boolean.FALSE);
        }
    };
    public static final String[] DATE_FORMATS = new String[]{"EEE MMM dd yyyy HH:mm:ss 'GMT'z", "EEE, dd MMM yyyy HH:mm:ss Z", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ss", "dd.MM.yyyy HH:mm:ss"};

    public RemoteReader(@NotNull RemoteProvider provider) {
        this.provider = provider;
    }

    @NotNull
    public String remotePath(@NotNull RemoteResource resource) {
        return this.provider.remotePath(resource.getPath());
    }

    @Nullable
    public RemoteResource loadResource(@NotNull RemoteResource resource, boolean isKnownChild) {
        RemoteResource result = resource;
        resource.children = null;
        resource.values = new ValueMapDecorator(new TreeMap());
        String path = resource.getPath();
        String logHint = null;
        HttpClient httpClient = this.provider.remoteClient.buildClient();
        if (!this.provider.ignoreIt(path)) {
            int statusCode = this.loadJsonResource(resource, httpClient);
            if (statusCode == 200) {
                logHint = ".JSON";
            } else {
                statusCode = this.loadDavResource(resource, httpClient);
                if (statusCode == 200 || statusCode == 207) {
                    logHint = "--DAV";
                } else if (statusCode == 404 && !isKnownChild) {
                    result = null;
                } else {
                    resource.children = new LinkedHashMap<String, Resource>();
                    resource.values.put((Object)"jcr:primaryType", (Object)"not:accessible");
                    logHint = "---??";
                }
            }
        } else {
            result = null;
        }
        if (result != null) {
            result.values = new ValueMapDecorator(Collections.unmodifiableMap(result.values));
        }
        if (LOG.isDebugEnabled() && logHint != null) {
            LOG.debug("load{} ({}): {}", new Object[]{logHint, resource.getPath(), result.children.size()});
        }
        return result;
    }

    @NotNull
    public String getDavUrl(@NotNull RemoteResource resource) {
        return this.getDavUrl(resource.getPath());
    }

    @NotNull
    public String getDavUrl(@NotNull String resourcePath) {
        return this.provider.remoteClient.getHttpUrl(resourcePath);
    }

    protected int loadDavResource(@NotNull RemoteResource resource, @NotNull HttpClient httpClient) {
        int statusCode = 204;
        String url = this.getDavUrl(resource);
        LOG.debug("DAV.load({}) - '{}'", (Object)resource.getPath(), (Object)url);
        try {
            HttpPropfind davGet = this.provider.remoteClient.buildPropfind(url);
            try {
                HttpResponse response = this.provider.remoteClient.execute(httpClient, (HttpUriRequest)davGet);
                statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 207) {
                    MultiStatusResponse[] responses;
                    String path = resource.getPath();
                    resource.children = new LinkedHashMap<String, Resource>();
                    resource.values.clear();
                    boolean resourceIsFolder = false;
                    MultiStatus multiStatus = davGet.getResponseBodyAsMultiStatus(response);
                    for (MultiStatusResponse item : responses = multiStatus.getResponses()) {
                        Matcher itemHref = DAV_HREF.matcher(item.getHref());
                        if (!itemHref.matches()) continue;
                        String itemPath = this.provider.localPath(itemHref.group("path"));
                        boolean isFolder = "/".equals(itemHref.group("folder"));
                        if (itemPath.equals(path)) {
                            this.loadDavResource(resource, item);
                            resourceIsFolder = isFolder;
                            continue;
                        }
                        String name = itemHref.group("name");
                        RemoteResource child = new RemoteResource(resource.resolver, path + "/" + name);
                        this.loadDavResource(child, item);
                        if (this.provider.ignoreIt(path + "/" + name)) continue;
                        this.adjustDavType(child, isFolder);
                        resource.children.put(name, (Resource)child);
                    }
                    this.adjustDavType(resource, resourceIsFolder);
                }
            }
            catch (DavException ex) {
                LOG.error("DAV exception loading '{}': {}", (Object)url, (Object)ex.toString());
                statusCode = 406;
            }
        }
        catch (IOException ex) {
            LOG.error("IO exception loading '{}': {}", (Object)url, (Object)ex.toString());
        }
        return statusCode;
    }

    protected void adjustDavType(@NotNull RemoteResource resource, boolean isFolder) {
        String primaryType = (String)resource.values.get("jcr:primaryType", String.class);
        if (StringUtils.isBlank((CharSequence)primaryType) || primaryType.startsWith(DAV_NS)) {
            Resource content;
            primaryType = isFolder ? DAV_TYPE_FOLDER : (resource.children != null && resource.children.size() > 0 ? ((content = resource.getChild("jcr:content")) instanceof RemoteResource && "nt:resource".equals(((RemoteResource)content).values.get("jcr:primaryType", String.class)) ? "nt:file" : DAV_TYPE_UNKNOWN) : DAV_TYPE_UNKNOWN);
            LOG.debug("DAV.adjust({}) - '{}'", (Object)resource.getPath(), (Object)primaryType);
            resource.values.put((Object)"jcr:primaryType", (Object)primaryType);
        }
    }

    protected void loadDavResource(@NotNull RemoteResource resource, @NotNull MultiStatusResponse response) {
        DavPropertySet properties = response.getProperties(200);
        for (DavProperty prop : properties) {
            this.addDavProperty(resource, prop);
        }
    }

    protected void addDavProperty(@NotNull RemoteResource resource, @NotNull DavProperty<?> property) {
        DavPropertyName propName = property.getName();
        String davNs = propName.getNamespace().getPrefix();
        if (NS_PREFIX_JCR.equals(davNs)) {
            this.addDavProperty(resource, NS_PREFIX_JCR, property);
        }
    }

    protected void addDavProperty(@NotNull RemoteResource resource, @Nullable String ns, @NotNull DavProperty<?> property) {
        DavPropertyName propName = property.getName();
        String key = ns != null ? ns + ":" + propName.getName() : propName.getName();
        Object value = property.getValue();
        if (value instanceof String) {
            resource.values.put((Object)key, this.transform((String)value));
        } else if (value != null) {
            resource.values.put((Object)key, value);
        }
    }

    @NotNull
    public String getJsonUrl(@NotNull RemoteResource resource) {
        return this.getJsonUrl(resource.getPath());
    }

    @NotNull
    public String getJsonUrl(@NotNull String path) {
        String httpUrl = this.provider.remoteClient.getHttpUrl(path);
        return httpUrl.replaceAll("\\.", "%2E") + (path.endsWith("/") ? "" : "/") + ".1.json";
    }

    protected int loadJsonResource(@NotNull RemoteResource resource, @NotNull HttpClient httpClient) {
        int statusCode;
        block20: {
            String url = this.getJsonUrl(resource);
            LOG.debug("JSON.load({}) - '{}'", (Object)resource.getPath(), (Object)url);
            HttpGet httpGet = this.provider.remoteClient.buildHttpGet(url);
            try {
                HttpResponse response = this.provider.remoteClient.execute(httpClient, (HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) break block20;
                try (InputStream stream = response.getEntity().getContent();
                     InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                     JsonReader jsonReader = new JsonReader((Reader)reader);){
                    this.loadJsonResource(resource, jsonReader);
                    if (resource.children == null) {
                        resource.children = new LinkedHashMap<String, Resource>();
                    }
                }
            }
            catch (MalformedJsonException mfex) {
                statusCode = 406;
            }
            catch (IOException ex) {
                LOG.error("exception loading '{}': {}", (Object)url, (Object)ex.toString());
                statusCode = 406;
            }
        }
        return statusCode;
    }

    protected void loadJsonResource(@NotNull RemoteResource resource, @NotNull JsonReader jsonReader) throws IOException {
        resource.children = null;
        resource.values.clear();
        ArrayList<Object> array = null;
        String name = null;
        int skip = 0;
        boolean more = true;
        while (more) {
            switch (jsonReader.peek()) {
                case NAME: {
                    if (skip > 0) {
                        String skipped = jsonReader.nextName();
                        LOG.trace("json.[name]({})", (Object)skipped);
                        break;
                    }
                    name = jsonReader.nextName();
                    LOG.trace("json.name({})", (Object)name);
                    break;
                }
                case STRING: {
                    String string = jsonReader.nextString();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("json.string({}{}:{})", new Object[]{name, array != null ? "[]" : "", string});
                    }
                    if (skip != 0) break;
                    if (array != null) {
                        array.add(string);
                        break;
                    }
                    if (name == null) {
                        throw new IOException("invaid JSON - string without name");
                    }
                    resource.values.put((Object)name, this.transform(string));
                    name = null;
                    break;
                }
                case NUMBER: {
                    Number number;
                    try {
                        number = jsonReader.nextInt();
                    }
                    catch (Exception ignore) {
                        try {
                            number = jsonReader.nextLong();
                        }
                        catch (Exception ignore_) {
                            number = jsonReader.nextDouble();
                        }
                    }
                    if (number instanceof Integer) {
                        number = (long)number;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("json.number({}{}:{})", new Object[]{name, array != null ? "[]" : "", number});
                    }
                    if (skip != 0) break;
                    if (array != null) {
                        array.add(number);
                        break;
                    }
                    if (name == null) {
                        throw new IOException("invaid JSON - number without name");
                    }
                    if (name.startsWith(":jcr:")) {
                        String binaryName = name.substring(1);
                        resource.values.put((Object)binaryName, (Object)new RemoteBinary(resource.getPath() + "/" + binaryName));
                    }
                    resource.values.put((Object)name, (Object)number);
                    name = null;
                    break;
                }
                case BOOLEAN: {
                    Boolean boolVal = jsonReader.nextBoolean();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("json.number({}{}:{})", new Object[]{name, array != null ? "[]" : "", boolVal});
                    }
                    if (skip != 0) break;
                    if (array != null) {
                        array.add(boolVal);
                        break;
                    }
                    if (name == null) {
                        throw new IOException("invaid JSON - boolean without name");
                    }
                    resource.values.put((Object)name, (Object)boolVal);
                    name = null;
                    break;
                }
                case NULL: {
                    jsonReader.nextNull();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("json.NULL({}{})", (Object)name, (Object)(array != null ? "[]" : ""));
                    }
                    if (skip != 0) break;
                    if (array != null) {
                        array.add(null);
                        break;
                    }
                    if (name == null) break;
                    resource.values.put((Object)name, null);
                    name = null;
                    break;
                }
                case BEGIN_ARRAY: {
                    jsonReader.beginArray();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("json.array({}[])...", (Object)name);
                    }
                    if (skip != 0) break;
                    if (name == null) {
                        throw new IOException("invaid JSON - array without name");
                    }
                    array = new ArrayList<Object>();
                    break;
                }
                case END_ARRAY: {
                    jsonReader.endArray();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("json.array({}[]:{})<", (Object)name, array != null ? Integer.valueOf(array.size()) : "null");
                    }
                    if (skip != 0) break;
                    if (array == null) {
                        throw new IOException("invaid JSON - end of array without begin");
                    }
                    resource.values.put((Object)name, (Object)array.toArray());
                    array = null;
                    name = null;
                    break;
                }
                case BEGIN_OBJECT: {
                    jsonReader.beginObject();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("json.object({}{})...", (Object)name, (Object)(array != null ? "[]" : ""));
                    }
                    if (name == null) break;
                    if (skip > 0 || array != null) {
                        ++skip;
                        break;
                    }
                    String path = resource.getPath() + "/" + name;
                    RemoteResource child = new RemoteResource(resource.resolver, path);
                    LOG.debug("JSON.load.child({})...", (Object)path);
                    this.loadJsonResource(child, jsonReader);
                    if (resource.children == null) {
                        resource.children = new LinkedHashMap<String, Resource>();
                    }
                    if (!this.provider.ignoreIt(child.getPath())) {
                        resource.children.put(name, (Resource)child);
                    }
                    name = null;
                    break;
                }
                case END_OBJECT: {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("json.object({}{})<", (Object)name, (Object)(array != null ? "[]" : ""));
                    }
                    if (skip > 0) {
                        --skip;
                    }
                    jsonReader.endObject();
                }
                case END_DOCUMENT: {
                    more = false;
                }
            }
        }
    }

    public Object transform(String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            Matcher typePrefix = STRING_TYPE_PREFIX.matcher(string);
            if (typePrefix.matches()) {
                try {
                    int propertyType = PropertyType.valueFromName((String)typePrefix.group(1));
                    string = typePrefix.group(2);
                    switch (propertyType) {
                        case 6: {
                            Boolean bool = RemoteReader.toBoolean(string);
                            if (bool != null) {
                                return bool;
                            }
                            return bool;
                        }
                        case 5: {
                            Calendar calendar = RemoteReader.toDate(string);
                            if (calendar == null) break;
                            return calendar;
                        }
                    }
                }
                catch (IllegalArgumentException propertyType) {}
            } else {
                Comparable<Calendar> object = RemoteReader.toDate(string);
                if (object != null) {
                    return object;
                }
                object = RemoteReader.toBoolean(string);
                if (object != null) {
                    return object;
                }
            }
        }
        return string;
    }

    @Nullable
    public static Boolean toBoolean(@NotNull String string) {
        return BOOLEAN_VALUES.get(string.toLowerCase());
    }

    @Nullable
    public static Calendar toDate(@NotNull String string) {
        for (String format : DATE_FORMATS) {
            try {
                Date date = new SimpleDateFormat(format, Locale.ENGLISH).parse(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public class RemoteBinary
    extends InputStream {
        protected final String propertyPath;
        private transient HttpGet httpGet;
        private transient InputStream content;

        public RemoteBinary(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        protected void connect() {
            try {
                this.close();
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
            String url = RemoteReader.this.provider.remoteClient.getHttpUrl(this.propertyPath);
            HttpGet httpGet = RemoteReader.this.provider.remoteClient.buildHttpGet(url);
            try {
                HttpResponse response = RemoteReader.this.provider.remoteClient.execute((HttpUriRequest)httpGet);
                StatusLine statusLine = response.getStatusLine();
                switch (statusLine.getStatusCode()) {
                    case 200: {
                        this.content = response.getEntity().getContent();
                        break;
                    }
                    default: {
                        this.content = new ByteArrayInputStream(new byte[0]);
                        this.release();
                        break;
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("exception loading '{}': {}", (Object)url, (Object)ex.toString());
                this.release();
            }
        }

        protected void release() {
            if (this.httpGet != null) {
                this.httpGet.releaseConnection();
                this.httpGet = null;
            }
        }

        protected InputStream content() {
            if (this.content == null) {
                this.connect();
            }
            return this.content;
        }

        @Override
        public int read() throws IOException {
            return this.content().read();
        }

        @Override
        public void close() throws IOException {
            if (this.content != null) {
                this.content.close();
                this.content = null;
            }
            this.release();
        }
    }
}

