/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.remote.RemoteProvider;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={Filter.class}, property={"service.description=Composum Nodes Remote Load Filter", "sling.filter.scope=REQUEST", "service.ranking:Integer=4000"}, immediate=true)
public class RemoteRequestFilter
implements Filter {
    protected Map<String, RemoteProvider> remoteProviders = new ConcurrentHashMap<String, RemoteProvider>();

    @Reference(service=RemoteProvider.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void addRemoteProvider(@NotNull RemoteProvider provider) {
        this.remoteProviders.put(provider.getProviderRoot(), provider);
    }

    protected void removeRemoteProvider(@NotNull RemoteProvider provider) {
        this.remoteProviders.remove(provider.getProviderRoot());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest request;
        RequestPathInfo pathInfo;
        if (servletRequest instanceof SlingHttpServletRequest && "json".equals((pathInfo = (request = (SlingHttpServletRequest)servletRequest).getRequestPathInfo()).getExtension())) {
            String path = pathInfo.getResourcePath();
            for (String remoteRoot : this.remoteProviders.keySet()) {
                if (!path.equals(remoteRoot) && !path.startsWith(remoteRoot + "/")) continue;
                SlingHttpServletResponse response = (SlingHttpServletResponse)servletResponse;
                response.setContentType("application/json;charset=UTF-8");
                JsonWriter writer = new JsonWriter((Writer)response.getWriter());
                writer.beginObject();
                writer.name("jcr:primaryType").value("nt:unstructured");
                writer.endObject();
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

