/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.mount.remote;

import com.composum.sling.nodes.mount.remote.RemoteResolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteResource
extends SyntheticResource {
    public static final String REMOTE_TYPE = "composum/nodes/mount/remote";
    protected RemoteResolver resolver;
    protected final String path;
    protected final String name;
    protected ValueMap values = new ValueMapDecorator(new TreeMap());
    protected Map<String, Resource> children = null;
    protected ModifiableValueMap modifiedValues;
    protected ResourceMetadata metadata = new ResourceMetadata();

    public RemoteResource(@NotNull RemoteResolver resolver, @NotNull String path) {
        super((ResourceResolver)resolver, path, REMOTE_TYPE);
        this.resolver = resolver;
        if (StringUtils.isBlank((CharSequence)path) || !path.startsWith("/")) {
            throw new IllegalArgumentException("an absolute path is required (" + path + ")");
        }
        if ("/".equals(path)) {
            this.path = path;
            this.name = path;
        } else {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.path = path;
            this.name = StringUtils.substringAfterLast((String)path, (String)"/");
            if (StringUtils.isBlank((CharSequence)this.name)) {
                throw new IllegalArgumentException("name not resolvable from '" + path + "'");
            }
        }
    }

    protected RemoteResource(@NotNull RemoteResource template, @NotNull String path) {
        this(template.resolver, path);
        this.values = new ValueMapDecorator(new HashMap(template.values));
        this.children = new LinkedHashMap<String, Resource>();
        for (Map.Entry<String, Resource> entry : template.children().entrySet()) {
            String name = entry.getKey();
            this.children.put(name, (Resource)new RemoteResource((RemoteResource)entry.getValue(), path + "/" + name));
        }
    }

    @NotNull
    protected Map<String, Resource> children() {
        if (this.children == null && this.resolver.provider.remoteReader.loadResource(this, true) == null) {
            this.children = new LinkedHashMap<String, Resource>();
        }
        return this.children;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Resource getParent() {
        return this.resolver.getParent((Resource)this);
    }

    public boolean hasChildren() {
        return this.children().size() > 0;
    }

    @NotNull
    public Iterator<Resource> listChildren() {
        return this.children().values().iterator();
    }

    @NotNull
    public Iterable<Resource> getChildren() {
        return this.children().values();
    }

    @Nullable
    public Resource getChild(@NotNull String relPath) {
        if (relPath.contains("/")) {
            return this.resolver.getResource((Resource)this, relPath);
        }
        return this.children().get(relPath);
    }

    @NotNull
    public String getResourceType() {
        return (String)this.values.get("sling:resourceType", (Object)((String)this.values.get("jcr:primaryType", (Object)"nt:unstructured")));
    }

    @Nullable
    public String getResourceSuperType() {
        return (String)this.values.get("sling:resourceSuperType", String.class);
    }

    public boolean isResourceType(String resourceType) {
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)resourceType) && !(result = resourceType.equals(this.getResourceType()))) {
            result = resourceType.equals(this.getResourceSuperType());
        }
        return result;
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    @NotNull
    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    @NotNull
    public ValueMap getValueMap() {
        return this.values;
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        if (ModifiableValueMap.class.equals(type)) {
            if (this.modifiedValues == null) {
                this.modifiedValues = new ModifiableValueMapDecorator(new HashMap(this.values));
                this.resolver.getChangeSet().addModify(this);
            }
            return (AdapterType)this.modifiedValues;
        }
        return null;
    }

    public static class NonExisting
    extends RemoteResource {
        public NonExisting(@NotNull RemoteResolver resolver, @NotNull String path) {
            super(resolver, path);
        }

        @Override
        @NotNull
        public String getResourceType() {
            return "sling:nonexisting";
        }
    }
}

