/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.Restricted;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.servlet.NodeServlet;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/query/export")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Export Query Json Servlet", "sling.servlet.resourceTypes=composum/nodes/browser/query/export/json/objects", "sling.servlet.methods=POST"})
public class ExportQueryJson
extends SlingAllMethodsServlet
implements RestrictedService {
    private static final Logger LOG = LoggerFactory.getLogger(ExportQueryJson.class);
    public static final String SERVICE_KEY = "nodes/query/export";
    @Reference
    private ServiceRestrictions restrictions;

    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key(SERVICE_KEY);
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        if (this.restrictions.isPermissible(request, this.getServiceKey(), ServiceRestrictions.Permission.read)) {
            Resource resource = request.getResource();
            response.setStatus(200);
            response.setContentType("application/json; charset=UTF-8");
            String filename = XSS.filter((String)request.getRequestPathInfo().getSuffix());
            if (filename != null) {
                while (filename.startsWith("/")) {
                    filename = filename.substring(1);
                }
            }
            if (StringUtils.isBlank((CharSequence)filename)) {
                filename = "query-export.json";
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            int indent = NodeServlet.getJsonSelectorIndent(request);
            JsonWriter writer = new JsonWriter((Writer)response.getWriter());
            if (indent > 0) {
                writer.setIndent(StringUtils.repeat((char)' ', (int)indent));
            }
            try {
                ValueMap values = resource.getValueMap();
                MappingRules rules = NodeServlet.getJsonSelectorRules(request);
                writer.beginObject();
                writer.name("query").value((String)values.get("query", (Object)""));
                for (Resource item : resource.getChildren()) {
                    ValueMap valueMap = (ValueMap)item.adaptTo(ValueMap.class);
                    writer.name(item.getPath());
                    JsonUtil.exportJson((JsonWriter)writer, (Resource)item, (MappingRules)rules);
                }
                writer.endObject();
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        } else {
            response.sendError(405);
        }
    }
}

