/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Restricted(key="nodes/repository/nodetypes")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Show Nodetype Servlet", "sling.servlet.paths=/bin/cpm/nodes/debug/nodetypes", "sling.servlet.methods=GET", "sling.auth.requirements=/bin/cpm/nodes/debug/nodetypes"})
public class NodeTypesServlet
extends SlingSafeMethodsServlet
implements RestrictedService {
    public static final String SERVLET_PATH = "/bin/cpm/nodes/debug/nodetypes";
    public static final String SERVICE_KEY = "nodes/repository/nodetypes";
    public static final String PARAM_NODETYPEREGEX = "nameregex";
    @Reference
    private ServiceRestrictions restrictions;

    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key(SERVICE_KEY);
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        block10: {
            if (this.restrictions.isPermissible(request, this.getServiceKey(), ServiceRestrictions.Permission.read)) {
                Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
                Pattern nodetypeSelector = null;
                String nodetypeParam = request.getParameter(PARAM_NODETYPEREGEX);
                if (StringUtils.isNotBlank((CharSequence)nodetypeParam)) {
                    nodetypeSelector = Pattern.compile(nodetypeParam);
                }
                try (PrintWriter writer = response.getWriter();){
                    this.writeNodetypes(session, writer, nodetypeSelector);
                    break block10;
                }
                catch (RepositoryException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            response.sendError(405);
        }
    }

    protected void writeNodetypes(Session session, PrintWriter writer, Pattern nodetypeSelector) throws RepositoryException, IOException {
        CompactNodeTypeDefWriter cnd = new CompactNodeTypeDefWriter((Writer)writer, session, true);
        List nodetypes = IteratorUtils.toList((Iterator)session.getWorkspace().getNodeTypeManager().getAllNodeTypes());
        nodetypes.sort(Comparator.comparing(NodeTypeDefinition::getName));
        for (NodeTypeDefinition definition : nodetypes) {
            if (nodetypeSelector != null && !nodetypeSelector.matcher(definition.getName()).matches()) continue;
            cnd.write(definition);
        }
        cnd.close();
    }
}

