/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.servlet.Status;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.PropertyUtil;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.mount.ExtendedResolver;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.tika.mime.MimeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/repository/properties")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Property Servlet", "sling.servlet.paths=/bin/cpm/nodes/property", "sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.methods=PUT", "sling.auth.requirements=/bin/cpm/nodes/property"}, immediate=true)
public class PropertyServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyServlet.class);
    public static final String SERVICE_KEY = "nodes/repository/properties";
    public static final String SERVLET_PATH = "/bin/cpm/nodes/property";
    public static final StringFilter DEFAULT_PROPS_FILTER = new StringFilter.BlackList(new String[0]);
    public static final StringFilter BINARY_PROPS_FILTER = new StringFilter.BlackList(new String[0]);
    @Reference
    private NodesConfiguration coreConfig;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);

    @NotNull
    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.get, (ServletOperation)new GetOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.map, (ServletOperation)new MapGetOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.xss, (ServletOperation)new CheckXssOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.bin, (Enum)Operation.get, (ServletOperation)new GetBinaryOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.bin, (Enum)Operation.put, (ServletOperation)new PostBinaryOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.put, (ServletOperation)new PutOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.copy, (ServletOperation)new CopyOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.bin, (Enum)Operation.put, (ServletOperation)new PutBinaryOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.bin, (Enum)Operation.update, (ServletOperation)new PutUpdateOperation());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, (Enum)Extension.json, (Enum)Operation.remove, (ServletOperation)new RemoveOperation());
    }

    protected class PutUpdateOperation
    extends PutBinaryOperation {
        protected PutUpdateOperation() {
        }

        @Override
        protected void postChange(Node node) throws RepositoryException {
            Calendar lastModified = PropertyUtil.getProperty((Node)node, (String)"jcr:lastModified", (Calendar)null);
            if (lastModified != null) {
                Session session = node.getSession();
                String userId = session.getUserID();
                PropertyUtil.setProperty((Node)node, (String)"jcr:lastModified", (Object)GregorianCalendar.getInstance(), (int)5);
                if (StringUtils.isNotBlank((CharSequence)userId)) {
                    PropertyUtil.setProperty((Node)node, (String)"jcr:lastModifiedBy", (Object)userId, (int)1);
                }
            }
        }

        @Override
        protected void postChange(Resource resource) {
            Calendar lastModified;
            ModifiableValueMap values = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            if (values != null && (lastModified = (Calendar)values.get("jcr:lastModified", Calendar.class)) != null) {
                values.put((Object)"jcr:lastModified", (Object)GregorianCalendar.getInstance());
            }
        }
    }

    protected class PutBinaryOperation
    implements ServletOperation {
        protected PutBinaryOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                ServletInputStream input = request.getInputStream();
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    Session session = node.getSession();
                    PropertyUtil.setProperty((Node)node, (String)"jcr:data", (InputStream)input);
                    this.postChange(node);
                    session.save();
                } else {
                    boolean isFileUpdate;
                    ResourceResolver resolver = resource.getResourceResolver();
                    ResourceHandle parent = null;
                    boolean bl = isFileUpdate = resource.getName().equals("jcr:content") && resource.getValueMap().get((Object)"jcr:primaryType").equals("nt:resource") && (parent = resource.getParent()) != null && parent.getValueMap().get((Object)"jcr:primaryType").equals("nt:file");
                    if (isFileUpdate && resolver instanceof ExtendedResolver) {
                        ValueMap values = resource.getValueMap();
                        ((ExtendedResolver)resolver).upload(parent.getPath(), (InputStream)input, null, (String)values.get("jcr:mimeType", String.class), StandardCharsets.UTF_8.name());
                        resolver.commit();
                    } else {
                        ModifiableValueMap values = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
                        if (values != null) {
                            values.put((Object)"jcr:data", (Object)input);
                            this.postChange((Resource)resource);
                            resolver.commit();
                        } else {
                            response.sendError(400, "can't modify '" + resource.getPath() + "'");
                            return;
                        }
                    }
                }
                response.setContentLength(0);
                response.setStatus(200);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }

        protected void postChange(Node node) throws RepositoryException {
        }

        protected void postChange(Resource resource) {
        }
    }

    protected class PostBinaryOperation
    implements ServletOperation {
        protected PostBinaryOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    RequestParameterMap parameters = request.getRequestParameterMap();
                    RequestParameter file = parameters.getValue("value");
                    if (file != null) {
                        RequestParameter nameParam = parameters.getValue("name");
                        String name = nameParam != null ? nameParam.getString() : "jcr:data";
                        LOG.info(resource.getPath() + ": update POST for binary property '" + name + "'");
                        Session session = node.getSession();
                        InputStream input = file.getInputStream();
                        PropertyUtil.setProperty((Node)node, (String)name, (InputStream)input);
                        session.save();
                        response.setContentLength(0);
                        response.setStatus(200);
                    } else {
                        LOG.error(resource.getPath() + ": invalid file update POST - no file/binary content");
                        response.sendError(400, "no binary/file content");
                    }
                } else {
                    LOG.error(resource.getPath() + ": invalid file update POST - resource has no content node");
                    response.sendError(400, "can't determine file node '" + resource.getPath() + "'");
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class GetBinaryOperation
    implements ServletOperation {
        protected GetBinaryOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            block10: {
                if (resource == null || !resource.isValid()) {
                    response.setStatus(404);
                    return;
                }
                try {
                    String name = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"name", (String)"jcr:data");
                    Node node = (Node)resource.adaptTo(Node.class);
                    if (node != null) {
                        Binary binary;
                        Property property = node.getProperty(name);
                        Binary binary2 = binary = property != null ? property.getBinary() : null;
                        if (binary != null) {
                            try {
                                this.prepareResponse(response, resource, binary.getSize());
                                this.sendContent(response, binary.getStream());
                                break block10;
                            }
                            finally {
                                binary.dispose();
                            }
                        }
                        response.sendError(404, "no binary '" + name + "' property found");
                        break block10;
                    }
                    ValueMap values = resource.getValueMap();
                    InputStream content = (InputStream)values.get(name, InputStream.class);
                    if (content != null) {
                        this.prepareResponse(response, resource, null);
                        this.sendContent(response, content);
                    } else {
                        LOG.error(resource.getPath() + ": invalid binary GET - resource has no content node");
                        response.sendError(400, "can't determine file node '" + resource.getPath() + "'");
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.sendError(400, ex.getMessage());
                }
            }
        }

        protected void prepareResponse(@NotNull SlingHttpServletResponse response, ResourceHandle resource, @Nullable Long size) {
            Calendar lastModified;
            String filename;
            MimeType mimeType = MimeTypeUtil.getMimeType((Resource)resource);
            if (mimeType != null) {
                response.setContentType(mimeType.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)(filename = MimeTypeUtil.getFilename((Resource)resource, null)))) {
                response.setHeader("Content-Disposition", "inline; filename=" + filename);
            }
            if ((lastModified = (Calendar)resource.getProperty("jcr:lastModified", Calendar.class)) != null) {
                response.setDateHeader("Last-Modified", lastModified.getTimeInMillis());
            }
            if (size != null) {
                response.setContentLength(size.intValue());
            }
            response.setStatus(200);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendContent(@NotNull SlingHttpServletResponse response, @Nullable InputStream input) throws IOException {
            if (input != null) {
                BufferedInputStream buffered = new BufferedInputStream(input);
                try {
                    IOUtils.copy((InputStream)buffered, (OutputStream)response.getOutputStream());
                }
                finally {
                    buffered.close();
                    input.close();
                }
            } else {
                throw new IOException("no content found");
            }
        }
    }

    protected class CopyOperation
    extends BulkOperation {
        protected CopyOperation() {
        }

        @Override
        protected ResourceHandle prepare(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException {
            if (resource != null && !resource.isValid()) {
                resource = ResourceHandle.use((Resource)ResourceUtil.getOrCreateResource((ResourceResolver)request.getResourceResolver(), (String)resource.getPath(), (String)"nt:unstructured"));
            }
            return resource;
        }

        @Override
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull ResourceHandle resource, @Nullable Node node, @NotNull BulkParameters parameters, @NotNull JsonWriter writer) throws RepositoryException, ServletException, IOException {
            if (parameters.path != null && parameters.names != null) {
                writer.beginObject();
                writer.name("copied").beginArray();
                if (node != null) {
                    Session session = node.getSession();
                    Node template = session.getNode(parameters.path);
                    if (template != null) {
                        for (String name : parameters.names) {
                            try {
                                Property property = template.getProperty(name);
                                if (property == null) continue;
                                this.clearProperty(node, name);
                                if (property.isMultiple()) {
                                    node.setProperty(name, property.getValues());
                                } else {
                                    node.setProperty(name, property.getValue());
                                }
                                writer.value(name);
                            }
                            catch (PathNotFoundException pathNotFoundException) {}
                        }
                    }
                    session.save();
                } else {
                    ResourceResolver resolver = resource.getResourceResolver();
                    ModifiableValueMap values = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
                    Resource template = resolver.getResource(parameters.path);
                    if (values != null && template != null) {
                        ValueMap templateValues = template.getValueMap();
                        for (String name : parameters.names) {
                            Object value = templateValues.get((Object)name);
                            if (value == null) continue;
                            values.put((Object)name, value);
                            writer.value(name);
                        }
                    }
                    resolver.commit();
                }
                writer.endArray();
                writer.endObject();
            }
        }
    }

    protected class RemoveOperation
    extends BulkOperation {
        protected RemoveOperation() {
        }

        @Override
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull ResourceHandle resource, @Nullable Node node, @NotNull BulkParameters parameters, @NotNull JsonWriter writer) throws RepositoryException, ServletException, IOException {
            Session session = node != null ? node.getSession() : null;
            ModifiableValueMap values = node == null ? (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class) : null;
            writer.beginObject();
            if (parameters.names != null) {
                writer.name("removed").beginArray();
                for (String name : parameters.names) {
                    if (node != null) {
                        this.clearProperty(node, name);
                    } else if (values != null) {
                        values.remove((Object)name);
                    }
                    writer.value(name);
                }
                writer.endArray();
            }
            writer.endObject();
            if (session != null) {
                session.save();
            } else if (values != null) {
                resource.getResourceResolver().commit();
            }
        }

        protected class Result {
            public List<String> names;

            protected Result() {
            }
        }
    }

    protected abstract class BulkOperation
    implements ServletOperation {
        protected BulkOperation() {
        }

        protected ResourceHandle prepare(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException {
            return resource;
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            try {
                resource = this.prepare(request, response, resource);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.setStatus(500);
                return;
            }
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            BulkParameters parameters = (BulkParameters)AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, BulkParameters.class);
            if (parameters != null) {
                try {
                    response.setStatus(200);
                    JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                    Node node = (Node)resource.adaptTo(Node.class);
                    this.doIt(request, response, resource, node, parameters, writer);
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.sendError(400, ex.getMessage());
                }
            }
        }

        protected abstract void doIt(@NotNull SlingHttpServletRequest var1, @NotNull SlingHttpServletResponse var2, @NotNull ResourceHandle var3, @Nullable Node var4, @NotNull BulkParameters var5, @NotNull JsonWriter var6) throws RepositoryException, ServletException, IOException;

        protected void clearProperty(@NotNull Node node, @NotNull String name) throws RepositoryException {
            try {
                Property property = node.getProperty(name);
                if (property != null) {
                    if (property.isMultiple()) {
                        node.setProperty(name, (Value[])null);
                    } else {
                        node.setProperty(name, (Value)null);
                    }
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }

        protected class Result {
            public Object result;

            protected Result() {
            }
        }
    }

    protected static class BulkParameters {
        public String path;
        public List<String> names;

        protected BulkParameters() {
        }
    }

    protected class PutOperation
    implements ServletOperation {
        protected PutOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (resource == null) {
                response.setStatus(404);
                return;
            }
            if (!resource.isValid()) {
                try {
                    resource = ResourceHandle.use((Resource)ResourceUtil.getOrCreateResource((ResourceResolver)request.getResourceResolver(), (String)resource.getPath(), (String)"nt:unstructured"));
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.setStatus(500);
                    return;
                }
            }
            try {
                JsonUtil.JsonProperty property = (JsonUtil.JsonProperty)AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, JsonUtil.JsonProperty.class);
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    Session session = node.getSession();
                    boolean available = JsonUtil.setJsonProperty((Node)node, (JsonUtil.JsonProperty)property, (MappingRules)ResponseUtil.getDefaultJsonMapping());
                    session.save();
                    response.setStatus(200);
                    if (available) {
                        response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                        ResponseUtil.writeJsonProperty((Resource)resource, (SlingHttpServletResponse)response, (Node)node, (String)property.name);
                    } else {
                        response.setContentLength(0);
                    }
                } else {
                    ModifiableValueMap values = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
                    if (values != null) {
                        int type = StringUtils.isNotBlank((CharSequence)property.type) ? PropertyType.valueFromName((String)property.type) : 1;
                        Object value = JsonUtil.makeValueObject((int)type, (Object)property.value);
                        if (property.oldname != null && !property.oldname.equals(property.name)) {
                            values.remove((Object)property.oldname);
                        }
                        values.put((Object)property.name, value);
                        resource.getResourceResolver().commit();
                    } else {
                        response.sendError(400, "can't modify resource (" + resource.getPath() + ")");
                    }
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class GetOperation
    implements ServletOperation {
        protected GetOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (resource == null || !resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                String name = XSS.filter((String)request.getParameter("name"));
                if (node != null && StringUtils.isNotBlank((CharSequence)name)) {
                    response.setStatus(200);
                    ResponseUtil.writeJsonProperty((Resource)resource, (SlingHttpServletResponse)response, (Node)node, (String)name);
                } else {
                    response.sendError(400, "no property name parameter found");
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class MapGetOperation
    implements ServletOperation {
        protected MapGetOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (!(resource = AbstractServiceServlet.tryToUseRawSuffix((SlingHttpServletRequest)request, (ResourceHandle)resource)).isValid()) {
                response.setStatus(404);
                return;
            }
            StringFilter filter = resource.isFile() ? BINARY_PROPS_FILTER : DEFAULT_PROPS_FILTER;
            try {
                MappingRules mapping = new MappingRules(MappingRules.getDefaultMappingRules(), null, null, null, new MappingRules.PropertyFormat((MappingRules.PropertyFormat.Scope)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"format", (Enum)((MappingRules.PropertyFormat.Scope)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)MappingRules.PropertyFormat.Scope.definition))), (MappingRules.PropertyFormat.Binary)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"binary", (Enum)((MappingRules.PropertyFormat.Binary)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)MappingRules.PropertyFormat.Binary.link)))), null, null);
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                response.setStatus(200);
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    JsonUtil.writeJsonProperties((Resource)resource, (JsonWriter)jsonWriter, (StringFilter)filter, (Node)node, (MappingRules)mapping);
                } else {
                    ValueMap values = ResourceUtil.getValueMap((Resource)resource);
                    JsonUtil.writeJsonValueMap((Resource)resource, (JsonWriter)jsonWriter, (StringFilter)filter, (ValueMap)values, (MappingRules)mapping);
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class CheckXssOperation
    implements ServletOperation {
        protected CheckXssOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            Status status = new Status(request, response);
            String[] value = request.getParameterValues("value");
            boolean result = true;
            if (value != null && value.length > 0) {
                for (int i = 0; result && i < value.length; ++i) {
                    result = PropertyUtil.xssCheck((String)value[i]);
                }
            }
            if (!result) {
                status.warn("XSS check failed", new Object[0]);
            }
            status.sendJson();
        }
    }

    public static enum Operation {
        get,
        put,
        update,
        map,
        copy,
        remove,
        xss;

    }

    public static enum Extension {
        json,
        bin;

    }
}

